/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.EnhancedJTextField;
import com.cookiecadger.Utils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SettingsDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JPanel generalPanel;
    private JPanel databasePanel;
    private JTabbedPane tabbedPane;
    private EnhancedJTextField txtTsharkPath;
    private JTextField txtDatabaseHost;
    private JTextField txtDatabaseUser;
    private JTextField txtDatabaseName;
    private JTextField txtDatabaseRefreshRate;
    private JComboBox comboSessionDetection;
    private JComboBox comboDatabaseEngine;
    private JCheckBox chckbxAllowUpdates;
    private JCheckBox chckbxEnableDemoMode;
    private JPasswordField txtDatabasePass;
    private JLabel lblDatabaseHost;
    private JLabel lblDatabaseUser;
    private JLabel lblDatabasePass;
    private JLabel lblDatabaseName;
    private JLabel lblDatabaseRefreshRate;

    public SettingsDialog() {
        this.setTitle("Program Settings");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setBounds(100, 100, 450, 300);
        this.setModal(true);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new GridLayout(1, 0, 0, 0));
        this.tabbedPane = new JTabbedPane(1);
        this.contentPanel.add(this.tabbedPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Save");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String dbEngine = ((Utils.databaseEngineChoices)((Object)SettingsDialog.this.comboDatabaseEngine.getSelectedItem())).name().toLowerCase();
                Utils.savePreference("dbEngine", dbEngine);
                Utils.savePreference("databaseHost", SettingsDialog.this.txtDatabaseHost.getText());
                Utils.savePreference("databaseUser", SettingsDialog.this.txtDatabaseUser.getText());
                Utils.savePreference("databasePass", new String(SettingsDialog.this.txtDatabasePass.getPassword()));
                Utils.savePreference("databaseName", SettingsDialog.this.txtDatabaseName.getText());
                Utils.savePreference("databaseRefreshRate", SettingsDialog.this.txtDatabaseRefreshRate.getText());
                Utils.savePreference("tsharkPath", SettingsDialog.this.txtTsharkPath.getText());
                String bSessionDetection = ((Utils.sessionDetectionChoices)((Object)SettingsDialog.this.comboSessionDetection.getSelectedItem())).name().toLowerCase();
                if (bSessionDetection.equals("prompt")) {
                    Utils.savePreference("bSessionDetection", -1);
                } else if (bSessionDetection.equals("yes")) {
                    Utils.savePreference("bSessionDetection", 1);
                } else {
                    Utils.savePreference("bSessionDetection", 0);
                }
                Utils.savePreference("bUseDemoMode", SettingsDialog.this.chckbxEnableDemoMode.isSelected());
                Utils.savePreference("bCheckForUpdates", SettingsDialog.this.chckbxAllowUpdates.isSelected());
                JOptionPane.showMessageDialog(null, "You must restart Cookie Cadger for changes to take effect.");
                SettingsDialog.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.generalPanel = new JPanel();
        this.generalPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.generalPanel.setLayout(null);
        this.tabbedPane.addTab("General Settings", null, this.generalPanel, null);
        JLabel lblPathTothsark = new JLabel("Path to 'tshark' binary:");
        lblPathTothsark.setBounds(12, 6, 180, 15);
        this.generalPanel.add(lblPathTothsark);
        this.txtTsharkPath = new EnhancedJTextField();
        this.txtTsharkPath.setBounds(12, 24, 400, 19);
        this.generalPanel.add(this.txtTsharkPath);
        this.txtTsharkPath.setColumns(10);
        JSeparator separator = new JSeparator();
        separator.setBounds(0, 100, 434, 2);
        this.generalPanel.add(separator);
        JLabel lblSessionDetection = new JLabel("Session detection:");
        lblSessionDetection.setBounds(12, 60, 140, 15);
        this.generalPanel.add(lblSessionDetection);
        this.comboSessionDetection = new JComboBox();
        this.comboSessionDetection.setModel(new DefaultComboBoxModel<Utils.sessionDetectionChoices>(Utils.sessionDetectionChoices.values()));
        this.comboSessionDetection.setBounds(159, 56, 250, 24);
        this.generalPanel.add(this.comboSessionDetection);
        this.chckbxAllowUpdates = new JCheckBox("Allow automatic checking for software updates?");
        this.chckbxAllowUpdates.setBounds(12, 120, 400, 23);
        this.generalPanel.add(this.chckbxAllowUpdates);
        this.chckbxEnableDemoMode = new JCheckBox("Enable 'demo mode' (requires session detection)");
        this.chckbxEnableDemoMode.setBounds(12, 150, 400, 23);
        this.generalPanel.add(this.chckbxEnableDemoMode);
        this.databasePanel = new JPanel();
        this.databasePanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.databasePanel.setLayout(null);
        this.tabbedPane.addTab("Database Settings", null, this.databasePanel, null);
        JLabel lblDatabase = new JLabel("Database:");
        lblDatabase.setBounds(12, 12, 80, 15);
        this.databasePanel.add(lblDatabase);
        this.comboDatabaseEngine = new JComboBox();
        this.comboDatabaseEngine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                boolean bUsingExternal = !source.getSelectedItem().equals((Object)Utils.databaseEngineChoices.SQLITE);
                SettingsDialog.this.changeDatabaseFields(bUsingExternal);
            }
        });
        this.comboDatabaseEngine.setModel(new DefaultComboBoxModel<Utils.databaseEngineChoices>(Utils.databaseEngineChoices.values()));
        this.comboDatabaseEngine.setBounds(95, 8, 316, 24);
        this.databasePanel.add(this.comboDatabaseEngine);
        JSeparator separator_1 = new JSeparator();
        separator_1.setBounds(0, 48, 434, 2);
        this.databasePanel.add(separator_1);
        this.lblDatabaseHost = new JLabel("Database Host:");
        this.lblDatabaseHost.setBounds(12, 62, 120, 15);
        this.lblDatabaseHost.setEnabled(false);
        this.databasePanel.add(this.lblDatabaseHost);
        this.lblDatabaseUser = new JLabel("Database User:");
        this.lblDatabaseUser.setBounds(12, 86, 120, 15);
        this.lblDatabaseUser.setEnabled(false);
        this.databasePanel.add(this.lblDatabaseUser);
        this.lblDatabasePass = new JLabel("Database Pass:");
        this.lblDatabasePass.setBounds(12, 110, 120, 15);
        this.lblDatabasePass.setEnabled(false);
        this.databasePanel.add(this.lblDatabasePass);
        this.lblDatabaseName = new JLabel("Database Name:");
        this.lblDatabaseName.setBounds(12, 134, 120, 15);
        this.lblDatabaseName.setEnabled(false);
        this.databasePanel.add(this.lblDatabaseName);
        this.lblDatabaseRefreshRate = new JLabel("Database Refresh Rate (in seconds):");
        this.lblDatabaseRefreshRate.setEnabled(false);
        this.lblDatabaseRefreshRate.setBounds(12, 158, 264, 15);
        this.databasePanel.add(this.lblDatabaseRefreshRate);
        this.txtDatabaseHost = new JTextField();
        this.txtDatabaseHost.setBounds(146, 60, 265, 19);
        this.txtDatabaseHost.setEnabled(false);
        this.databasePanel.add(this.txtDatabaseHost);
        this.txtDatabaseHost.setColumns(10);
        this.txtDatabaseUser = new JTextField();
        this.txtDatabaseUser.setColumns(10);
        this.txtDatabaseUser.setBounds(146, 84, 265, 19);
        this.txtDatabaseUser.setEnabled(false);
        this.databasePanel.add(this.txtDatabaseUser);
        this.txtDatabasePass = new JPasswordField();
        this.txtDatabasePass.setColumns(10);
        this.txtDatabasePass.setBounds(146, 108, 265, 19);
        this.txtDatabasePass.setEnabled(false);
        this.databasePanel.add(this.txtDatabasePass);
        this.txtDatabaseName = new JTextField();
        this.txtDatabaseName.setColumns(10);
        this.txtDatabaseName.setBounds(146, 132, 265, 19);
        this.txtDatabaseName.setEnabled(false);
        this.databasePanel.add(this.txtDatabaseName);
        this.txtDatabaseRefreshRate = new JTextField();
        this.txtDatabaseRefreshRate.setEnabled(false);
        this.txtDatabaseRefreshRate.setColumns(10);
        this.txtDatabaseRefreshRate.setBounds(290, 156, 64, 19);
        this.databasePanel.add(this.txtDatabaseRefreshRate);
        String dbEngine = Utils.getPreference("dbEngine", "sqlite");
        Utils.databaseEngineChoices[] databaseEngineChoicesArray = Utils.databaseEngineChoices.values();
        int n = databaseEngineChoicesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Utils.databaseEngineChoices enum_option = databaseEngineChoicesArray[n2];
            if (enum_option.name().toLowerCase().equals(dbEngine.toLowerCase())) {
                this.comboDatabaseEngine.setSelectedItem((Object)enum_option);
                if (!enum_option.equals((Object)Utils.databaseEngineChoices.SQLITE)) break;
                this.changeDatabaseFields(false);
                break;
            }
            ++n2;
        }
        this.txtDatabaseHost.setText(Utils.getPreference("databaseHost", ""));
        this.txtDatabaseUser.setText(Utils.getPreference("databaseUser", ""));
        this.txtDatabasePass.setText(Utils.getPreference("databasePass", ""));
        this.txtDatabaseName.setText(Utils.getPreference("databaseName", ""));
        this.txtDatabaseRefreshRate.setText(Utils.getPreference("databaseRefreshRate", 15).toString());
        int bSessionDetection = Utils.getPreference("bSessionDetection", -1);
        if (bSessionDetection == -1) {
            this.comboSessionDetection.setSelectedItem((Object)Utils.sessionDetectionChoices.PROMPT);
        } else if (bSessionDetection == 1) {
            this.comboSessionDetection.setSelectedItem((Object)Utils.sessionDetectionChoices.YES);
        } else {
            this.comboSessionDetection.setSelectedItem((Object)Utils.sessionDetectionChoices.NO);
        }
        String tsharkPathSaved = Utils.getPreference("tsharkPath", "");
        this.txtTsharkPath.setText(tsharkPathSaved);
        if (tsharkPathSaved.length() == 0) {
            this.txtTsharkPath.setPlaceholder((String)Utils.programSettings.get("tsharkPath"), new Font("SansSerif", 1, 12));
        }
        this.chckbxAllowUpdates.setSelected(Utils.getPreference("bCheckForUpdates", true));
        this.chckbxEnableDemoMode.setSelected(Utils.getPreference("bUseDemoMode", false));
    }

    private void changeDatabaseFields(boolean bUsingExternal) {
        this.txtDatabaseHost.setEnabled(bUsingExternal);
        this.txtDatabaseUser.setEnabled(bUsingExternal);
        this.txtDatabasePass.setEnabled(bUsingExternal);
        this.txtDatabaseName.setEnabled(bUsingExternal);
        this.txtDatabaseRefreshRate.setEnabled(bUsingExternal);
        this.lblDatabaseHost.setEnabled(bUsingExternal);
        this.lblDatabaseUser.setEnabled(bUsingExternal);
        this.lblDatabasePass.setEnabled(bUsingExternal);
        this.lblDatabaseName.setEnabled(bUsingExternal);
        this.lblDatabaseRefreshRate.setEnabled(bUsingExternal);
    }
}

