/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class RequestInterceptor
implements HttpRequestInterceptor {
    private String cookies = null;
    private String referer = null;
    private String useragent = null;
    private String randomization = null;
    private String authorization = null;

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (this.cookies != null && this.cookies.length() > 0) {
            request.removeHeaders("Cookie");
            request.addHeader("Cookie", this.cookies);
        }
        if (this.referer != null && this.referer.length() > 0) {
            request.removeHeaders("Referer");
            request.removeHeaders("Referrer");
            request.addHeader("Referer", this.referer);
            this.setReferer(null);
        }
        if (this.useragent != null && this.useragent.length() > 0) {
            request.removeHeaders("User-Agent");
            request.addHeader("User-Agent", this.useragent);
        }
        if (this.authorization != null && this.authorization.length() > 0) {
            request.removeHeaders("Authorization");
            request.addHeader("Authorization", this.authorization);
        }
        Header[] acceptHeaders = request.getHeaders("Accept");
        if (this.randomization != null && acceptHeaders.length == 1) {
            request.removeHeaders("Accept");
            request.addHeader("Accept", String.valueOf(acceptHeaders[0].getValue()) + ";" + this.randomization);
        }
    }

    public void setCookies(String cookies) {
        this.cookies = cookies;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setRandomization(String randomization) {
        this.randomization = randomization;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setUserAgent(String useragent) {
        this.useragent = useragent;
    }

    public void clear() {
        this.cookies = null;
        this.referer = null;
        this.useragent = null;
        this.authorization = null;
    }
}

