/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.BrowserHandler;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class ReplayDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextArea txtUri;
    private JTextArea txtUserAgent;
    private JTextArea txtReferer;
    private JTextArea txtCookies;
    private JTextArea txtAuthorization;
    private String domain = null;

    public ReplayDialog(String domain, String uri, String userAgent, String referer, String cookies, String authorization) {
        this.domain = domain;
        this.setTitle("Modify & Replay Request");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setBounds(100, 100, 650, 520);
        this.setModal(true);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JLabel lblDomain = new JLabel("");
        lblDomain.setFont(new Font("Dialog", 1, 16));
        lblDomain.setBounds(12, 6, 623, 24);
        lblDomain.setText(domain);
        this.contentPanel.add(lblDomain);
        JLabel lblUri = new JLabel("URI:");
        lblUri.setBounds(12, 40, 120, 15);
        this.contentPanel.add(lblUri);
        JScrollPane scrollPaneUri = new JScrollPane();
        scrollPaneUri.setBounds(12, 58, 623, 40);
        this.contentPanel.add(scrollPaneUri);
        this.txtUri = new JTextArea();
        this.txtUri.setText(uri);
        this.txtUri.setLineWrap(true);
        scrollPaneUri.setViewportView(this.txtUri);
        JLabel lblUserAgent = new JLabel("User Agent:");
        lblUserAgent.setBounds(12, 110, 120, 15);
        this.contentPanel.add(lblUserAgent);
        JScrollPane scrollPaneUserAgent = new JScrollPane();
        scrollPaneUserAgent.setBounds(12, 128, 623, 40);
        this.contentPanel.add(scrollPaneUserAgent);
        this.txtUserAgent = new JTextArea();
        this.txtUserAgent.setText(userAgent);
        this.txtUserAgent.setLineWrap(true);
        scrollPaneUserAgent.setViewportView(this.txtUserAgent);
        JLabel lblReferer = new JLabel("Referer:");
        lblReferer.setBounds(12, 180, 120, 15);
        this.contentPanel.add(lblReferer);
        JScrollPane scrollPaneReferer = new JScrollPane();
        scrollPaneReferer.setBounds(12, 198, 623, 40);
        this.contentPanel.add(scrollPaneReferer);
        this.txtReferer = new JTextArea();
        this.txtReferer.setText(referer);
        this.txtReferer.setLineWrap(true);
        scrollPaneReferer.setViewportView(this.txtReferer);
        JLabel lblAuthorization = new JLabel("Authorization:");
        lblAuthorization.setBounds(12, 250, 120, 15);
        this.contentPanel.add(lblAuthorization);
        JScrollPane scrollPaneAuthorization = new JScrollPane();
        scrollPaneAuthorization.setBounds(12, 268, 623, 40);
        this.contentPanel.add(scrollPaneAuthorization);
        this.txtAuthorization = new JTextArea();
        this.txtAuthorization.setText(authorization);
        this.txtAuthorization.setLineWrap(true);
        scrollPaneAuthorization.setViewportView(this.txtAuthorization);
        JLabel lblCookies = new JLabel("Cookies:");
        lblCookies.setBounds(12, 320, 120, 15);
        this.contentPanel.add(lblCookies);
        JScrollPane scrollPaneCookies = new JScrollPane();
        scrollPaneCookies.setBounds(12, 338, 623, 100);
        this.contentPanel.add(scrollPaneCookies);
        this.txtCookies = new JTextArea();
        this.txtCookies.setText(cookies);
        this.txtCookies.setLineWrap(true);
        scrollPaneCookies.setViewportView(this.txtCookies);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Replay");
        final String loadDomain = this.domain;
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                final String loadUri = ReplayDialog.this.txtUri.getText();
                final String loadUserAgent = ReplayDialog.this.txtUserAgent.getText();
                final String loadReferer = ReplayDialog.this.txtReferer.getText();
                final String loadCookies = ReplayDialog.this.txtCookies.getText();
                final String loadAuthorization = ReplayDialog.this.txtAuthorization.getText();
                SwingWorker<Object, Object> loadRequestWorker = new SwingWorker<Object, Object>(){

                    @Override
                    public Object doInBackground() {
                        BrowserHandler.loadRequestIntoBrowser(loadDomain, loadUri, loadUserAgent, loadReferer, loadCookies, loadAuthorization);
                        return null;
                    }
                };
                loadRequestWorker.run();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Close");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReplayDialog.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }
}

