/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.CookieCadgerFrame;
import com.cookiecadger.CookieCadgerHeadless;
import com.cookiecadger.MacHandler;
import com.cookiecadger.MacSupport;
import com.cookiecadger.Utils;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;

public class Program {
    public static void main(final String[] args) {
        MacSupport.initIfMac("Cookie Cadger", false, "/resource/cookiecadger.png", new MacHandler(){

            @Override
            public void handleQuit(Object applicationEvent) {
                System.exit(0);
            }

            @Override
            public void handleAbout(Object applicationEvent) {
                Utils.displayAboutWindow();
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (args.length > 0) {
                    String[] stringArray = args;
                    int n = args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String arg = stringArray[n2];
                        if (arg.contains("-help") || arg.contains("/help") || arg.contains("/?") || arg.contains("-?")) {
                            System.err.println("Cookie Cadger, version 1.08");
                            System.err.println("Example usage:\njava -jar CookieCadger.jar \n\t--tshark=/usr/sbin/tshark\n\t--headless=on\n\t--interfacenum=2\t(requires --headless=on)\n\t--detection=on\n\t--demo=on\n\t--update=on\n\t--dbengine=mysql\t(default is 'sqlite' for local, file-based storage)\n\t--dbhost=localhost\t(requires --dbengine=mysql)\n\t--dbuser=user\t\t(requires --dbengine=mysql)\n\t--dbpass=pass\t\t(requires --dbengine=mysql)\n\t--dbname=cadgerdata\t(requires --dbengine=mysql)\n\t--dbrefreshrate=15\t(in seconds, requires --dbengine=mysql, requires --headless=off)");
                            return;
                        }
                        ++n2;
                    }
                }
                Utils.loadApplicationPreferences();
                Utils.handleProgramArguments(args);
                if (GraphicsEnvironment.isHeadless()) {
                    Utils.consoleMessage("No graphical environment found. Dropping to headless mode.");
                    Utils.programSettings.put("bHeadless", true);
                }
                if (((Boolean)Utils.programSettings.get("bHeadless")).booleanValue()) {
                    new CookieCadgerHeadless();
                } else {
                    try {
                        CookieCadgerFrame cookieCadgerFrame = new CookieCadgerFrame();
                        cookieCadgerFrame.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

