/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.BrowserHandler;
import com.cookiecadger.EnhancedJListItem;
import com.cookiecadger.ProcessWatcher;
import com.cookiecadger.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;

public class CaptureHandler {
    public ArrayList<Boolean> bCapturing = new ArrayList();
    public ArrayList<String> deviceName = new ArrayList();
    public ArrayList<String> deviceDescription = new ArrayList();
    public ArrayList<Process> deviceCaptureProcess = new ArrayList();
    public ArrayList<String> sessionDetectors = new ArrayList();

    public CaptureHandler() {
        this.loadPlugins();
    }

    public void startCapture(int ethDevNumber, String pcapFile) throws IOException {
        ArrayList<String> nonTabbedOutput;
        Date capStart;
        block38: {
            InputStreamReader isr;
            InputStream is;
            block39: {
                ProcessBuilder pb = null;
                Process proc = null;
                ProcessWatcher pw = null;
                is = null;
                capStart = new Date();
                nonTabbedOutput = new ArrayList<String>();
                if (pcapFile == null || pcapFile.isEmpty()) {
                    Utils.consoleMessage("Opening '" + this.deviceName.get(ethDevNumber) + "' for traffic capture.");
                    pb = new ProcessBuilder((String)Utils.programSettings.get("tsharkPath"), "-i", this.deviceName.get(ethDevNumber), "-f", "tcp dst port 80 or udp src port 5353 or udp src port 138", "-T", "fields", "-e", "eth.src", "-e", "wlan.sa", "-e", "ip.src", "-e", "ipv6.src", "-e", "tcp.srcport", "-e", "tcp.dstport", "-e", "udp.srcport", "-e", "udp.dstport", "-e", "browser.command", "-e", "browser.server", "-e", "dns.resp.name", "-e", "http.host", "-e", "http.request.uri", "-e", "http.accept", "-e", "http.accept_encoding", "-e", "http.user_agent", "-e", "http.referer", "-e", "http.cookie", "-e", "http.authorization", "-e", "http.authbasic");
                    this.deviceCaptureProcess.set(ethDevNumber, pb.start());
                    pw = new ProcessWatcher(this.deviceCaptureProcess.get(ethDevNumber));
                    is = this.deviceCaptureProcess.get(ethDevNumber).getInputStream();
                } else {
                    Utils.consoleMessage("Opening '" + pcapFile + "' for traffic capture.");
                    pb = new ProcessBuilder((String)Utils.programSettings.get("tsharkPath"), "-r", pcapFile, "-T", "fields", "-e", "eth.src", "-e", "wlan.sa", "-e", "ip.src", "-e", "ipv6.src", "-e", "tcp.srcport", "-e", "tcp.dstport", "-e", "udp.srcport", "-e", "udp.dstport", "-e", "browser.command", "-e", "browser.server", "-e", "dns.resp.name", "-e", "http.host", "-e", "http.request.uri", "-e", "http.accept", "-e", "http.accept_encoding", "-e", "http.user_agent", "-e", "http.referer", "-e", "http.cookie", "-e", "http.authorization", "-e", "http.authbasic");
                    proc = pb.start();
                    pw = new ProcessWatcher(proc);
                    is = proc.getInputStream();
                }
                isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                try {
                    while ((line = br.readLine()) != null || pw.isFinished()) {
                        if (line != null) {
                            if (line.contains("\t")) {
                                String[] mdnsResponses;
                                String mdnsNameStr;
                                String[] values = line.split("\t", -1);
                                if (values.length <= 4) continue;
                                String macAddressWired = values[0];
                                String macAddressWireless = values[1];
                                String macAddress = !macAddressWired.isEmpty() ? macAddressWired : (!macAddressWireless.isEmpty() ? macAddressWireless : "Unknown");
                                String ipv4Address = values[2];
                                String ipv6Address = values[3];
                                String tcpDestination = values[5];
                                String udpSource = values[6];
                                String netbiosCommand = values[8];
                                String netbiosName = values[9];
                                String mdnsName = values[10];
                                String requestHost = values[11];
                                String requestUri = values[12];
                                String accept = values[13];
                                String acceptEncoding = values[14];
                                String userAgent = values[15];
                                String refererUri = values[16];
                                String cookieData = values[17];
                                String authorization = values[18];
                                String authBasic = values[19];
                                boolean bUsefulData = false;
                                int clientID = -1;
                                if (pcapFile != null && !pcapFile.isEmpty() && !tcpDestination.equals("80") && !udpSource.equals("5353") && !udpSource.equals("138") || accept.contains(";" + Integer.toString(Utils.getLocalRandomization()))) continue;
                                if (!requestUri.isEmpty()) {
                                    bUsefulData = true;
                                    clientID = this.handleClient(macAddress);
                                    this.processRequest(macAddress, ipv4Address, ipv6Address, requestHost, accept, acceptEncoding, requestUri, userAgent, refererUri, cookieData, authorization, authBasic);
                                } else if (!netbiosCommand.isEmpty() && netbiosCommand.equals("0x0f") && !netbiosName.isEmpty()) {
                                    bUsefulData = true;
                                    clientID = this.handleClient(macAddress);
                                    Utils.dbInstance.setStringValue("clients", "netbios_hostname", netbiosName, "mac_address", macAddress);
                                } else if (!(mdnsName.isEmpty() || !mdnsName.contains(",") || (mdnsNameStr = (mdnsResponses = mdnsName.split(","))[mdnsResponses.length - 1]).contains(".arpa") || mdnsNameStr.contains("_tcp") || mdnsNameStr.contains("_udp") || mdnsNameStr.contains("<Root>"))) {
                                    bUsefulData = true;
                                    clientID = this.handleClient(macAddress);
                                    mdnsNameStr = mdnsNameStr.replace(".local", "");
                                    Utils.dbInstance.setStringValue("clients", "mdns_hostname", mdnsNameStr, "mac_address", macAddress);
                                }
                                if (bUsefulData) {
                                    if (!ipv4Address.isEmpty()) {
                                        Utils.dbInstance.setStringValue("clients", "ipv4_address", ipv4Address, "mac_address", macAddress);
                                    }
                                    if (!ipv6Address.isEmpty()) {
                                        Utils.dbInstance.setStringValue("clients", "ipv6_address", ipv6Address, "mac_address", macAddress);
                                    }
                                }
                                if (Utils.cookieCadgerFrame == null) continue;
                                Utils.cookieCadgerFrame.updateDescriptionForMac(macAddress);
                                continue;
                            }
                            nonTabbedOutput.add(line);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException values) {
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    break block38;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        if (pcapFile != null && !pcapFile.isEmpty() && proc != null) {
                            proc.destroy();
                        } else if (this.deviceCaptureProcess.get(ethDevNumber) != null) {
                            this.deviceCaptureProcess.get(ethDevNumber).destroy();
                        }
                        break block38;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                if (br == null) break block39;
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
        if (pcapFile != null && pcapFile.isEmpty() && Utils.cookieCadgerFrame != null) {
            Utils.cookieCadgerFrame.stopCapture(ethDevNumber);
        }
        Date capEnd = new Date();
        int runTimeInSeconds = (int)((capEnd.getTime() - capStart.getTime()) / 1000L);
        if ((pcapFile == null || pcapFile.isEmpty()) && runTimeInSeconds <= 20) {
            Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + "============================================================================");
            Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + "Start of diagnostic information for interface '" + this.deviceName.get(ethDevNumber) + "'");
            Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + "============================================================================");
            for (String output : nonTabbedOutput) {
                Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + output);
            }
            Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + "============================================================================");
            Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + "Potential error detected! Capture stopped / died in " + Integer.toString(runTimeInSeconds) + " seconds.");
            Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + "All messages from the 'tshark' program have been printed above to assist you in solving any errors.");
            Utils.consoleMessage(String.valueOf(this.deviceName.get(ethDevNumber)) + ": " + "============================================================================");
        } else if (pcapFile == null || pcapFile.isEmpty()) {
            Utils.consoleMessage("'" + this.deviceName.get(ethDevNumber) + "' has been closed and is finished with traffic capture. Capture duration: " + Integer.toString(runTimeInSeconds) + " seconds.");
        } else {
            Utils.consoleMessage("'" + pcapFile + "' has finished processing. Processing duration: " + Integer.toString(runTimeInSeconds) + " seconds.");
        }
    }

    private void processRequest(final String macAddress, String ipv4Address, String ipv6Address, final String requestHost, final String accept, String acceptEncoding, final String requestUri, final String userAgent, final String refererUri, final String cookieData, final String authorization, String authBasic) {
        int clientID = -1;
        int domainID = -1;
        int reqID = -1;
        try {
            if (Utils.dbInstance.containsValue("clients", "mac_address", macAddress)) {
                clientID = Utils.dbInstance.getIntegerValue("clients", "id", "mac_address", macAddress);
                if (Utils.cookieCadgerFrame != null) {
                    Utils.cookieCadgerFrame.clientsList.performHighlight(macAddress, Color.BLUE);
                }
            } else {
                clientID = Utils.dbInstance.createClient(macAddress);
            }
            Utils.dbInstance.setStringValue("clients", "has_http_requests", Integer.toString(1), "id", Integer.toString(clientID));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (Utils.dbInstance.containsValue("domains", "name", requestHost)) {
                domainID = Utils.dbInstance.getIntegerValue("domains", "id", "name", requestHost);
            } else {
                domainID = Utils.dbInstance.createDomain(requestHost);
                if (Utils.cookieCadgerFrame != null && !Utils.cookieCadgerFrame.clientsList.isSelectionEmpty() && ((EnhancedJListItem)Utils.cookieCadgerFrame.clientsList.getSelectedValue()).toString().equals(macAddress) && (Utils.cookieCadgerFrame.txtDomainSearch.getText().isEmpty() || Utils.cookieCadgerFrame.txtDomainSearch.getText().length() > 0 && requestHost.toLowerCase().contains(Utils.cookieCadgerFrame.txtDomainSearch.getText().toLowerCase()))) {
                    Utils.cookieCadgerFrame.domainsListModel.addElement(new EnhancedJListItem(domainID, requestHost, null));
                }
            }
            if (Utils.cookieCadgerFrame != null) {
                Utils.cookieCadgerFrame.domainsList.performHighlight(requestHost, Color.BLUE);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            reqID = Utils.dbInstance.createRequest(requestUri, userAgent, refererUri, cookieData, authorization, authBasic, domainID, clientID);
            String description = Utils.generateDescriptionForRequest(reqID, true, true);
            Utils.dbInstance.setStringValue("requests", "description", description, "id", Integer.toString(reqID));
            if (Utils.cookieCadgerFrame != null && !Utils.cookieCadgerFrame.clientsList.isSelectionEmpty() && ((EnhancedJListItem)Utils.cookieCadgerFrame.clientsList.getSelectedValue()).toString().equals(macAddress) && !Utils.cookieCadgerFrame.domainsList.isSelectionEmpty() && (((EnhancedJListItem)Utils.cookieCadgerFrame.domainsList.getSelectedValue()).toString().equals(requestHost) || ((EnhancedJListItem)Utils.cookieCadgerFrame.domainsList.getSelectedValue()).toString().equals("[ All Domains ]")) && (Utils.cookieCadgerFrame.txtRequestSearch.getText().isEmpty() || Utils.cookieCadgerFrame.txtRequestSearch.getText().length() > 0 && requestUri.toLowerCase().contains(Utils.cookieCadgerFrame.txtRequestSearch.getText().toLowerCase()))) {
                Date now = new Date();
                String dateString = DateFormat.getTimeInstance(2).format(now);
                boolean bShowAllDomains = false;
                if (!Utils.cookieCadgerFrame.domainsList.isSelectionEmpty() && ((EnhancedJListItem)Utils.cookieCadgerFrame.domainsList.getSelectedValue()).toString().equals("[ All Domains ]")) {
                    bShowAllDomains = true;
                }
                String requestDisplay = null;
                requestDisplay = bShowAllDomains ? String.valueOf(requestHost) + requestUri : requestUri;
                EnhancedJListItem requestItem = new EnhancedJListItem(reqID, String.valueOf(dateString) + ": " + requestDisplay, description);
                Utils.cookieCadgerFrame.requestsListModel.addElement(requestItem);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (Utils.cookieCadgerFrame != null) {
            if (!Utils.cookieCadgerFrame.clientsListModel.contains(macAddress) && (Utils.cookieCadgerFrame.txtClientSearch.getText().isEmpty() || Utils.cookieCadgerFrame.txtClientSearch.getText().length() > 0 && macAddress.contains(Utils.cookieCadgerFrame.txtClientSearch.getText()))) {
                Utils.cookieCadgerFrame.clientsListModel.addElement(new EnhancedJListItem(clientID, macAddress, null));
                Utils.cookieCadgerFrame.clientsList.performHighlight(macAddress, Color.BLUE);
            }
            Utils.cookieCadgerFrame.updateDescriptionForMac(macAddress);
        }
        final int requestID = reqID;
        if ((Integer)Utils.programSettings.get("bSessionDetection") != 1) {
            return;
        }
        if (cookieData.isEmpty() || requestHost.isEmpty() || requestUri.isEmpty() || accept.isEmpty() || cookieData.isEmpty() || requestUri.contains("favicon.")) {
            return;
        }
        SwingWorker<Object, Object> analyzeRequestWorker = new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                block13: {
                    String uniqueID = String.valueOf(macAddress) + "," + requestHost;
                    try {
                        if (Utils.dbInstance.containsValue("sessions", "user_token", uniqueID)) break block13;
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine engine = manager.getEngineByName("js");
                        for (String sd : CaptureHandler.this.sessionDetectors) {
                            FileReader reader = new FileReader(sd);
                            try {
                                engine.eval(reader);
                            }
                            catch (ScriptException se) {
                                System.err.println("Exception in plugin '" + sd + "', stack trace follows:");
                                se.printStackTrace();
                            }
                            reader.close();
                            try {
                                if (engine instanceof Invocable) {
                                    ((Invocable)((Object)engine)).invokeFunction("processRequest", requestHost, requestUri, userAgent, accept, cookieData);
                                }
                            }
                            catch (ScriptException se) {
                                System.err.println("Exception in plugin '" + sd + "', function 'processRequest'. Stack trace follows:");
                                se.printStackTrace();
                            }
                            String description = "";
                            String profileImageUrl = "";
                            String sessionUri = "";
                            try {
                                description = (String)engine.get("description");
                                profileImageUrl = (String)engine.get("profileImageUrl");
                                sessionUri = (String)engine.get("sessionUri");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (description == null || description.length() <= 0 || description.equals("null")) continue;
                            if (profileImageUrl != null && profileImageUrl.equals("null")) {
                                profileImageUrl = null;
                            }
                            if (sessionUri != null && sessionUri.equals("null")) {
                                sessionUri = null;
                            }
                            CaptureHandler.this.handleSession(requestID, uniqueID, description, profileImageUrl, sessionUri);
                            if (Utils.cookieCadgerFrame != null && ((JCheckBox)Utils.cookieCadgerFrame.getComponentByName("chckbxAutomaticallyLoadSessions")).isSelected()) {
                                BrowserHandler.loadRequestIntoBrowser(requestHost, requestUri, userAgent, refererUri, cookieData, authorization);
                            }
                            break;
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                return null;
            }
        };
        analyzeRequestWorker.execute();
    }

    private int handleClient(String macAddress) {
        try {
            if (Utils.dbInstance.containsValue("clients", "mac_address", macAddress)) {
                return Utils.dbInstance.getIntegerValue("clients", "id", "mac_address", macAddress);
            }
            if (Utils.cookieCadgerFrame == null) {
                Utils.consoleMessage("New client: " + macAddress);
            }
            return Utils.dbInstance.createClient(macAddress);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void handleSession(int requestID, String userToken, String description, String profilePhotoUrl, String sessionUri) {
        try {
            if (!Utils.dbInstance.containsValue("sessions", "user_token", userToken)) {
                int sessionID = Utils.dbInstance.createSession(requestID, userToken, description, profilePhotoUrl, sessionUri);
                if (Utils.cookieCadgerFrame != null) {
                    Utils.cookieCadgerFrame.changeSessionsList(false);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void initializeDeviceList() {
        String tsharkPath = (String)Utils.programSettings.get("tsharkPath");
        if (tsharkPath.isEmpty()) {
            String[] stringArray = Utils.knownTsharkLocations;
            int n = Utils.knownTsharkLocations.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (new File(path).exists()) {
                    Utils.consoleMessage("tshark located at " + path);
                    tsharkPath = path;
                    Utils.programSettings.put("tsharkPath", path);
                    break;
                }
                ++n2;
            }
        } else if (new File(tsharkPath).exists()) {
            Utils.consoleMessage("tshark specified at " + tsharkPath);
        } else {
            this.tsharkNotice("You specified a path to 'tshark', but the given path is invalid.");
            tsharkPath = "";
            Utils.savePreference("tsharkPath", "");
            Utils.programSettings.put("tsharkPath", "");
        }
        if (tsharkPath.isEmpty()) {
            this.tsharkNotice("Error: couldn't find 'tshark' (part of the 'Wireshark' suite). This software cannot capture or analyze packets without it.\nYou can still load previously saved sessions for replaying in the browser, but be aware you might encounter errors.\n\nYou can manually specify the location to 'tshark' in the 'Program Settings' area, or as a program argument.\n\nUsage:\njava -jar CookieCadger.jar --tshark=<full path to tshark>");
        } else {
            Utils.consoleMessage("Querying tshark for capture devices; tshark output follows:");
            String line = "";
            try {
                ProcessBuilder pb = new ProcessBuilder(tsharkPath, "-D");
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                InputStream is = proc.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    Utils.consoleMessage(line);
                    boolean isNumericStart = true;
                    try {
                        Integer.parseInt(line.substring(0, 1));
                    }
                    catch (Exception e) {
                        isNumericStart = false;
                    }
                    if (!isNumericStart) continue;
                    if (line.contains("(") && line.contains(")")) {
                        this.deviceDescription.add(line.substring(line.indexOf(" (") + 2, line.indexOf(")")).trim());
                        this.deviceName.add(line.substring(line.indexOf(". ") + 2, line.indexOf(" (")));
                    } else {
                        this.deviceDescription.add("no description");
                        this.deviceName.add(line.substring(line.indexOf(" ") + 1));
                    }
                    this.bCapturing.add(false);
                    this.deviceCaptureProcess.add(null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Utils.consoleMessage("Capture device search completed with " + this.deviceName.size() + " devices found.");
        }
    }

    private void loadPlugins() {
        String userTempDirectory;
        if (((Boolean)Utils.programSettings.get("bCheckForUpdates")).booleanValue()) {
            try {
                userTempDirectory = System.getProperty("java.io.tmpdir").replace("\\", "/");
                File pluginsFile = new File(String.valueOf(userTempDirectory) + "/plugins.zip");
                String UrlString = "https://www.cookiecadger.com/files/plugins.zip";
                HttpURLConnection httpConnection = (HttpURLConnection)new URL(UrlString).openConnection();
                httpConnection.setRequestMethod("GET");
                httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
                httpConnection.setRequestProperty("User-Agent", "Cookie Cadger, 1.08");
                FileUtils.copyInputStreamToFile((InputStream)httpConnection.getInputStream(), (File)pluginsFile);
                try {
                    FileUtils.cleanDirectory((File)new File(String.valueOf(userTempDirectory) + "/plugins"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Utils.unZipFile(pluginsFile.getAbsolutePath(), String.valueOf(userTempDirectory) + "/plugins");
                pluginsFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String pluginClassFilename;
            userTempDirectory = System.getProperty("java.io.tmpdir").replace("\\", "/");
            File folder = new File(String.valueOf(userTempDirectory) + "/plugins/");
            File[] listOfFiles = folder.listFiles();
            int i = 0;
            while (i < listOfFiles.length && listOfFiles[i].isFile()) {
                pluginClassFilename = listOfFiles[i].getName();
                if (pluginClassFilename.toLowerCase().endsWith(".js")) {
                    this.sessionDetectors.add(String.valueOf(userTempDirectory) + "/plugins/" + pluginClassFilename);
                }
                ++i;
            }
            folder = new File(String.valueOf(Utils.executionPath) + "/plugins/");
            listOfFiles = folder.listFiles();
            i = 0;
            while (i < listOfFiles.length && listOfFiles[i].isFile()) {
                pluginClassFilename = listOfFiles[i].getName();
                if (pluginClassFilename.toLowerCase().endsWith(".js")) {
                    this.sessionDetectors.add(String.valueOf(Utils.executionPath) + "/plugins/" + pluginClassFilename);
                }
                ++i;
            }
        }
        catch (NullPointerException userTempDirectory2) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void tsharkNotice(String notice) {
        if (Utils.cookieCadgerFrame != null) {
            JOptionPane.showMessageDialog(null, notice);
        } else {
            Utils.consoleMessage(notice);
        }
    }
}

