/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch.recent;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class RecentSearches {
    private static final int MAX_ITEMS = 5;
    private static final long FIVE_DAYS = 432000000L;
    private LinkedList<ResultsModel.ItemResult> recent = new LinkedList();
    private static RecentSearches instance;
    private static final char dateSep = ':';
    private static final String RECENT_SEARCHES = "recentSearches";

    private RecentSearches() {
        this.readRecentFromPrefs();
    }

    public static RecentSearches getDefault() {
        if (instance == null) {
            instance = new RecentSearches();
        }
        return instance;
    }

    public void add(ResultsModel.ItemResult result) {
        Date now = new GregorianCalendar().getTime();
        for (ResultsModel.ItemResult ir : this.recent) {
            if (!this.stripHTMLnames(ir.getDisplayName()).equals(this.stripHTMLnames(result.getDisplayName()))) continue;
            ir.setDate(now);
            return;
        }
        if ("SearchSetup".equals(result.getAction().getClass().getSimpleName())) {
            return;
        }
        if (this.recent.size() >= 5) {
            this.recent.removeLast();
        }
        result.setDate(now);
        this.recent.addFirst(result);
        this.storeRecentToPrefs();
    }

    public List<ResultsModel.ItemResult> getSearches() {
        LinkedList<ResultsModel.ItemResult> fiveDayList = new LinkedList<ResultsModel.ItemResult>();
        for (ResultsModel.ItemResult ir : this.recent) {
            if (new GregorianCalendar().getTime().getTime() - ir.getDate().getTime() >= 432000000L) continue;
            fiveDayList.add(ir);
        }
        return fiveDayList;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(RecentSearches.class);
    }

    private void storeRecentToPrefs() {
        Iterator it = this.recent.iterator();
        for (int i = 0; i < 5; ++i) {
            if (it.hasNext()) {
                ResultsModel.ItemResult td = (ResultsModel.ItemResult)it.next();
                this.prefs().put(RECENT_SEARCHES + i, this.stripHTMLnames(td.getDisplayName()) + ':' + td.getDate().getTime());
                continue;
            }
            this.prefs().put(RECENT_SEARCHES + i, "");
        }
    }

    private void readRecentFromPrefs() {
        for (int i = 0; i < 5; ++i) {
            String item = this.prefs().get(RECENT_SEARCHES + i, "");
            int semicolonPos = item.lastIndexOf(58);
            if (semicolonPos < 0) continue;
            try {
                String name = item.substring(0, semicolonPos);
                long time = Long.parseLong(item.substring(semicolonPos + 1));
                ResultsModel.ItemResult incomplete = new ResultsModel.ItemResult(null, new FakeAction(name), name, new Date(time));
                this.recent.add(incomplete);
                continue;
            }
            catch (NumberFormatException nfe) {
                Logger l = Logger.getLogger(RecentSearches.class.getName());
                l.log(Level.INFO, "Failed to read recent searches", item);
            }
        }
    }

    private String stripHTMLnames(String s) {
        return s.replaceAll("<.*?>", "").trim();
    }

    public final class FakeAction
    implements Runnable {
        private String name;
        private Runnable action;

        private FakeAction(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            if (this.action == null || this.action instanceof FakeAction) {
                ResultsModel model = ResultsModel.getInstance();
                CommandEvaluator.evaluate(this.stripHTMLandPackageNames(this.name), model);
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                int rSize = model.getSize();
                for (int j = 0; j < rSize; ++j) {
                    ResultsModel.ItemResult res = (ResultsModel.ItemResult)model.getElementAt(j);
                    if (!RecentSearches.this.stripHTMLnames(res.getDisplayName()).equals(RecentSearches.this.stripHTMLnames(this.name))) continue;
                    this.action = res.getAction();
                    if (this.action instanceof FakeAction) continue;
                    this.action.run();
                    break;
                }
            } else {
                this.action.run();
            }
        }

        private String stripHTMLandPackageNames(String s) {
            s = RecentSearches.this.stripHTMLnames(s);
            return s.replaceAll("\\(.*\\)", "").trim();
        }
    }
}

