/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.options;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.ui.graph.view2d.options.DisplayOptionsPanelController;
import com.paterva.maltego.util.ui.ColorButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class DisplayPanel
extends JPanel {
    private static final String PREF_TYPE_OVERLAY = "showTypeOverlayIcons";
    private static final String PREF_ATTACHMENTS_OVERLAY = "showAttachmentsOverlayIcons";
    private final DisplayOptionsPanelController _controller;
    private Color _defaultColor;
    private JCheckBox _attachmentsOverlayCheckBox;
    private JButton _changeColorButton;
    private JButton _linkColorButton;
    private JCheckBox _showEdit;
    private JCheckBox _typeOverlayCheckBox;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;

    DisplayPanel(DisplayOptionsPanelController displayOptionsPanelController) {
        this._controller = displayOptionsPanelController;
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._showEdit = new JCheckBox();
        this.jLabel1 = new JLabel();
        this._linkColorButton = new ColorButton();
        this._changeColorButton = new JButton();
        this.jPanel2 = new JPanel();
        this._typeOverlayCheckBox = new JCheckBox();
        this._attachmentsOverlayCheckBox = new JCheckBox();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jPanel1.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this._showEdit, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._showEdit.text"));
        this._showEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this._showEditActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this._linkColorButton, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._linkColorButton.text"));
        this._linkColorButton.setMaximumSize(new Dimension(15, 15));
        this._linkColorButton.setMinimumSize(new Dimension(15, 15));
        this._linkColorButton.setPreferredSize(new Dimension(15, 15));
        this._linkColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this._linkColorButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this._changeColorButton, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._changeColorButton.text"));
        this._changeColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this._changeColorButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._linkColorButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._changeColorButton)).addComponent(this._showEdit)).addContainerGap(231, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._showEdit).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this._changeColorButton).addComponent(this._linkColorButton, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jPanel2.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this._typeOverlayCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._typeOverlayCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this._attachmentsOverlayCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._attachmentsOverlayCheckBox.text"));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._typeOverlayCheckBox).addComponent(this._attachmentsOverlayCheckBox)).addContainerGap(111, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this._typeOverlayCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._attachmentsOverlayCheckBox)));
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(93, Short.MAX_VALUE)));
    }

    private void _showEditActionPerformed(ActionEvent actionEvent) {
        this._controller.changed();
    }

    private void _linkColorButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void _changeColorButtonActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Choose a Link Color", this._defaultColor);
        if (color != null) {
            this._defaultColor = color;
        }
        this._controller.changed();
        this.updateLinkColorButton();
    }

    void load() {
        this._showEdit.setSelected(NbPreferences.forModule(DisplayPanel.class).getBoolean("showEdgeCreationProperties", true));
        this._defaultColor = MaltegoLinkSpec.getDefaultManualLinkColor();
        this.updateLinkColorButton();
        this._typeOverlayCheckBox.setSelected(NbPreferences.forModule(DisplayPanel.class).getBoolean(PREF_TYPE_OVERLAY, true));
        this._attachmentsOverlayCheckBox.setSelected(NbPreferences.forModule(DisplayPanel.class).getBoolean(PREF_ATTACHMENTS_OVERLAY, true));
    }

    void store() {
        NbPreferences.forModule(DisplayPanel.class).putBoolean("showEdgeCreationProperties", this._showEdit.isSelected());
        MaltegoLinkSpec.setDefaultManualLinkColor((Color)this._defaultColor);
        MaltegoLinkSpec maltegoLinkSpec = MaltegoLinkSpec.getManualSpec();
        maltegoLinkSpec.getColorProperty().setDefaultValue((Object)this._defaultColor);
        NbPreferences.forModule(DisplayPanel.class).putBoolean(PREF_TYPE_OVERLAY, this._typeOverlayCheckBox.isSelected());
        NbPreferences.forModule(DisplayPanel.class).putBoolean(PREF_ATTACHMENTS_OVERLAY, this._attachmentsOverlayCheckBox.isSelected());
    }

    boolean valid() {
        return true;
    }

    private void updateLinkColorButton() {
        this._linkColorButton.setBackground(this._defaultColor);
    }
}

