/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import yguard.A.A.C;
import yguard.A.A.D;
import yguard.A.A._;
import yguard.A.I.S;
import yguard.A.I.mB;

public class LegendBackgroundRenderer
extends mB {
    public static final int POSITION_NE = 0;
    public static final int POSITION_SE = 1;
    public static final int POSITION_NW = 2;
    public static final int POSITION_SW = 3;
    private EntityColorFactory _factory;
    private Legend _legend = new Legend();
    private boolean _needsReCalc = true;
    private int _position = 0;
    private MyListener _graphListener = new MyListener();

    public LegendBackgroundRenderer(S s, EntityColorFactory entityColorFactory) {
        super(s);
        this._factory = entityColorFactory;
        this.connect((D)s.H());
    }

    public void setNeedsRecalc() {
        this._needsReCalc = true;
    }

    public Font getFont() {
        return this._legend.getFont();
    }

    public void setFont(Font font) {
        this._legend.setFont(font);
    }

    public void setLegendTextColor(Color color) {
        this._legend.setTextColor(color);
    }

    public Color getLegendTextColor() {
        return this._legend.getTextColor();
    }

    public int getLegendPosition() {
        return this._position;
    }

    public void setLegendPosition(int n) {
        this._position = n;
    }

    private void recalcLegend() {
        MaltegoGraph maltegoGraph = MaltegoGraphManager.get((D)this.view.H());
        EntityRegistry entityRegistry = EntityRegistry.forGraph((D)this.view.H());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MaltegoEntity object : maltegoGraph.entities()) {
            if (hashMap.containsKey(object.getTypeName())) continue;
            String string = object.getTypeName();
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(object.getTypeName());
            if (maltegoEntitySpec != null) {
                string = maltegoEntitySpec.getDisplayName();
            }
            hashMap.put(object.getTypeName(), string);
        }
        this._legend.clear();
        for (Map.Entry entry : hashMap.entrySet()) {
            this._legend.add(entry.getKey(), this._factory.getTypeColor((String)entry.getKey()), (String)entry.getValue());
        }
        this._needsReCalc = false;
    }

    public void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        super.paint(graphics2D, n, n2, n3, n4);
        if (this.view.\u00dd() <= this.view.\u00d0()) {
            if (this._needsReCalc) {
                this.recalcLegend();
            }
            Rectangle rectangle = new Rectangle(this._legend.getRectangle(graphics2D));
            Point point = this.calcLocation(rectangle);
            rectangle.translate(point.x, point.y);
            if (this._legend.needsRepainting() || rectangle.intersects(this.toWorldRect(n, n2, n3, n4))) {
                this.undoWorldTransform(graphics2D);
                this._legend.paint(graphics2D, point.x, point.y);
                this.redoWorldTransform(graphics2D);
            }
        }
    }

    private Rectangle toWorldRect(int n, int n2, int n3, int n4) {
        int n5 = this.view.J((double)n);
        int n6 = this.view.I((double)n2);
        int n7 = this.view.J((double)(n + n3)) - n5;
        int n8 = this.view.I((double)(n2 + n4)) - n6;
        return new Rectangle(n5, n6, n7, n8);
    }

    private Point calcLocation(Rectangle rectangle) {
        int n = 10;
        int n2 = 10;
        switch (this._position) {
            case 0: {
                return new Point((int)((double)this.view.getWidth() - rectangle.getWidth() - (double)n), n2);
            }
            case 2: {
                return new Point(n, n2);
            }
            case 1: {
                return new Point((int)((double)this.view.getWidth() - rectangle.getWidth() - (double)n), (int)((double)this.view.getHeight() - rectangle.getHeight() - (double)n2 - 15.0));
            }
            case 3: {
                return new Point(n, (int)((double)this.view.getHeight() - rectangle.getHeight() - (double)n2 - 15.0));
            }
        }
        return new Point(n, n2);
    }

    public void disconnect(D d2) {
        d2.B((_)this._graphListener);
    }

    public void connect(D d2) {
        d2.A((_)this._graphListener);
    }

    private static class Legend {
        private Set<LegendEntry> _entries = new HashSet<LegendEntry>();
        private boolean _needsRepainting = true;
        private Rectangle _rect;
        private int _rowHeight = 14;
        private int[] _colX;
        private int _spacingX = 10;
        private int _colorWidth = 12;
        private int _colorHeight = 8;
        private int _spacingY = 0;
        private Color _textColor = Color.GRAY;
        private Font _font = Font.decode("Arial-10");

        public Font getFont() {
            return this._font;
        }

        public void setFont(Font font) {
            this._font = font;
        }

        public void setTextColor(Color color) {
            this._textColor = color;
        }

        public Color getTextColor() {
            return this._textColor;
        }

        public void add(Object object, Color color, String string) {
            if (this._entries.add(new LegendEntry(object, color, string))) {
                this._needsRepainting = true;
            }
        }

        public void remove(Object object) {
            if (this._entries.remove(new LegendEntry(object))) {
                this._needsRepainting = true;
            }
        }

        public void clear() {
            this._needsRepainting = true;
            this._entries.clear();
        }

        private void calculateRect(Graphics2D graphics2D) {
            int n = 4;
            int[] nArray = new int[n];
            int n2 = 0;
            int n3 = 0;
            for (LegendEntry legendEntry : this._entries) {
                if (n2 >= n - 1) {
                    n2 = 0;
                }
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
                Rectangle2D rectangle2D = this.getFont().getStringBounds(legendEntry.description, fontRenderContext);
                int n4 = (int)rectangle2D.getWidth() + 3;
                nArray[n2] = Math.max(nArray[n2], n4 + this._colorWidth);
                legendEntry.column = n2++;
                legendEntry.row = ++n3;
            }
            this._colX = new int[n];
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                this._colX[i] = n5;
                n5 += nArray[i] + this._spacingX;
            }
            this._rect = new Rectangle(n5, this._rowHeight * (1 + n3));
        }

        public void paint(Graphics2D graphics2D, int n, int n2) {
            if (this.needsRepainting()) {
                this.calculateRect(graphics2D);
            }
            Color color = graphics2D.getColor();
            for (LegendEntry legendEntry : this._entries) {
                int n3 = this._colX[legendEntry.column] + n;
                int n4 = legendEntry.row * (this._spacingY + this._rowHeight) + n2;
                int n5 = n4 + (this._rowHeight - this._colorHeight) / 2;
                graphics2D.setColor(legendEntry.color);
                graphics2D.fillRect(n3, n5, this._colorWidth, this._colorHeight);
                graphics2D.setColor(Color.GRAY);
                graphics2D.drawRect(n3, n5, this._colorWidth, this._colorHeight);
                graphics2D.setFont(this._font);
                graphics2D.setColor(this._textColor);
                graphics2D.drawString(legendEntry.description, n3 + this._colorWidth + 5, n5 + this._colorHeight);
            }
            this._needsRepainting = false;
            graphics2D.setColor(color);
        }

        public Rectangle getRectangle(Graphics2D graphics2D) {
            if (this.needsRepainting()) {
                this.calculateRect(graphics2D);
            }
            return this._rect;
        }

        public boolean needsRepainting() {
            return this._needsRepainting;
        }

        private class LegendEntry {
            public String description;
            public Object key;
            public Color color;
            public int row;
            public int column;

            public LegendEntry(Object object, Color color, String string) {
                this.key = object;
                this.color = color;
                this.description = string;
            }

            private LegendEntry(Object object) {
                this(object, Color.BLACK, "");
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                LegendEntry legendEntry = (LegendEntry)object;
                return this.key == legendEntry.key || this.key != null && this.key.equals(legendEntry.key);
            }

            public int hashCode() {
                int n = 5;
                n = 53 * n + (this.key != null ? this.key.hashCode() : 0);
                return n;
            }
        }
    }

    private class MyListener
    implements _ {
        private MyListener() {
        }

        public void onGraphEvent(C c2) {
            if (c2.C() == 0 || c2.C() == 3) {
                LegendBackgroundRenderer.this._needsReCalc = true;
                LegendBackgroundRenderer.this.view.I();
            }
        }
    }
}

