/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.BookmarkFactory;
import com.paterva.maltego.ui.graph.view2d.EntityImagePainter;
import com.paterva.maltego.ui.graph.view2d.EntityLabelNodeRealizer;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.RoundRectHotSpotPainter;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jdesktop.swingx.color.ColorUtil;
import yguard.A.I.;
import yguard.A.I.FA;
import yguard.A.I.QA;
import yguard.A.I.V;
import yguard.A.I.XA;
import yguard.A.I.aB;

public class DetailedNodeRealizer {
    public static final String DEFAULT_NOTE = "(Click here to add notes)";
    public static final int IMAGE_SIZE = 48;
    public static final int LEFT_LABEL_SIZE = 16;
    public static final int RIGHT_LABEL_SIZE = 16;
    public static final int IMAGE_MARGIN_X = 3;
    public static final int IMAGE_MARGIN_Y = 3;
    public static final int LABEL_MARGIN = 4;
    protected static final int BOOKMARK_MARGIN_X = 0;
    protected static final int BOOKMARK_MARGIN_Y = 0;
    protected static final int BOOKMARK_LABEL_WIDTH = 14;
    protected static final int BOOKMARK_LABEL_HEIGHT = 14;
    protected static final int NOTES_MARGIN_X = 2;
    protected static final int NOTES_MARGIN_Y = 16;
    protected static final int NOTES_LABEL_WIDTH = 10;
    protected static final int NOTES_LABEL_HEIGHT = 14;
    public static final int LABEL_BOTTOM = 0;
    public static final int LABEL_NOTES = 1;
    public static final int LABEL_BOOKMARK = 2;
    public static final int LABEL_NOTES_EDIT = 3;
    public static final Color NOTES_SHADOW_COLOR_NORMAL;
    public static final Color NOTES_SHADOW_COLOR_HOVER;
    public static final Color NOTES_CLOSE_COLOR;
    public static final int NOTES_SHADOW_SIZE = 5;
    public static final int NOTES_TEXT_MARGIN = 10;
    public static final int NOTES_CLOSE_SIZE = 5;
    public static final int NOTES_CLOSE_MARGIN_X = 11;
    public static final int NOTES_CLOSE_MARGIN_y = 4;
    private static String _nodeRealizerConfig;
    private static String _notesLabelConfig;
    private static String _bookmarkLabelConfig;
    private static String _notesEditLabelConfig;
    private static final Color NOTES_LABEL_COLOR;
    private static final Color NOTES_LABEL_COLOR_EMPTY;

    public FA create() {
        return this.create(this.getDefaultConfig());
    }

    public FA create(String string) {
        EntiyNodeRealizer entiyNodeRealizer = new EntiyNodeRealizer();
        entiyNodeRealizer.setConfiguration(string);
        this.createLabels((.A)entiyNodeRealizer);
        this.updateSize((.A)entiyNodeRealizer);
        return entiyNodeRealizer;
    }

    public void updateSize(.A a2) {
        this.updateSizeNode(a2);
        this.updateSizeNotes(a2);
        this.updateSizeBookmark(a2);
    }

    protected void updateSizeNode(.A a2) {
        double d2 = 51.0;
        double d3 = 51.0;
        aB aB2 = a2.getLabel();
        aB2.calculateSize();
        if (aB2.isVisible()) {
            d2 += 2.0 * (3.0 + aB2.getHeight());
        }
        d3 += 38.0;
        if (aB2.isVisible()) {
            d3 = Math.max(d3, aB2.getWidth() + 4.0);
        }
        a2.setSize(d3, d2);
    }

    protected void updateSizeNotes(.A a2) {
        double d2 = a2.getWidth();
        double d3 = a2.getHeight();
        aB aB2 = a2.getLabel(1);
        double d4 = d2 / 2.0 + 24.0 - 2.0 - 10.0;
        double d5 = d3 / 2.0 - 24.0 + 16.0;
        aB2.setFreeOffset(d4, d5);
    }

    protected void updateSizeBookmark(.A a2) {
        double d2 = a2.getWidth();
        double d3 = a2.getHeight();
        aB aB2 = a2.getLabel(2);
        double d4 = d2 / 2.0 + 24.0 - 0.0 - 14.0;
        double d5 = d3 / 2.0 - 24.0 + 0.0;
        aB2.setFreeOffset(d4, d5);
    }

    protected String getDefaultConfig() {
        if (_nodeRealizerConfig == null) {
            _nodeRealizerConfig = "DefaultEntityNodeRealizer";
            FA._O _O2 = FA.getFactory();
            Map map = _O2.C();
            EntityImagePainter entityImagePainter = new EntityImagePainter();
            RoundRectHotSpotPainter roundRectHotSpotPainter = new RoundRectHotSpotPainter();
            map.put(FA._K.class, entityImagePainter);
            map.put(FA._R.class, roundRectHotSpotPainter);
            _O2.A(_nodeRealizerConfig, map);
        }
        return _nodeRealizerConfig;
    }

    protected String getNotesLabelConfig() {
        if (_notesLabelConfig == null) {
            _notesLabelConfig = "Notes";
            V._A _A2 = aB.getFactory();
            Map map = _A2.B();
            NotesConfig notesConfig = new NotesConfig();
            map.put(V._C.class, notesConfig);
            map.put(V._I.class, notesConfig);
            _A2.A(_notesLabelConfig, map);
        }
        return _notesLabelConfig;
    }

    protected String getBookmarkLabelConfig() {
        if (_bookmarkLabelConfig == null) {
            _bookmarkLabelConfig = "Bookmark";
            V._A _A2 = aB.getFactory();
            Map map = _A2.B();
            BookmarkConfig bookmarkConfig = new BookmarkConfig();
            map.put(V._C.class, bookmarkConfig);
            map.put(V._I.class, bookmarkConfig);
            _A2.A(_bookmarkLabelConfig, map);
        }
        return _bookmarkLabelConfig;
    }

    protected String getNotesEditLabelConfig() {
        if (_notesEditLabelConfig == null) {
            _notesEditLabelConfig = "NotesEdit";
            V._A _A2 = aB.getFactory();
            Map map = _A2.B();
            NotesEditConfig notesEditConfig = new NotesEditConfig();
            map.put(V._C.class, notesEditConfig);
            map.put(V._I.class, notesEditConfig);
            _A2.A(_notesEditLabelConfig, map);
        }
        return _notesEditLabelConfig;
    }

    protected void createLabels(.A a2) {
        this.createLabel(a2);
        this.createNotesLabel(a2);
        this.createBookmarkLabel(a2);
        this.createNotesEditLabel(a2);
    }

    protected aB createLabel(.A a2) {
        aB aB2 = a2.getLabel();
        aB2.setModel((byte)1);
        aB2.setPosition((byte)101);
        aB2.setFont(NodeRealizerSettings.getDefault().getValueLabelFont());
        aB2.setTextColor(NodeRealizerSettings.getDefault().getValueLabelColor());
        return aB2;
    }

    protected aB createBookmarkLabel(.A a2) {
        aB aB2 = a2.createNodeLabel();
        aB2.setModel((byte)4);
        aB2.setConfiguration(this.getBookmarkLabelConfig());
        aB2.setVisible(false);
        a2.addLabel(aB2);
        return aB2;
    }

    protected aB createNotesLabel(.A a2) {
        aB aB2 = a2.createNodeLabel();
        aB2.setModel((byte)4);
        aB2.setConfiguration(this.getNotesLabelConfig());
        aB2.setBackgroundColor(NOTES_LABEL_COLOR_EMPTY);
        aB2.setVisible(false);
        a2.addLabel(aB2);
        return aB2;
    }

    protected aB createNotesEditLabel(.A a2) {
        aB aB2 = a2.createNodeLabel();
        aB2.setModel((byte)5);
        aB2.setPosition((byte)105);
        aB2.setConfiguration(this.getNotesEditLabelConfig());
        aB2.setVisible(false);
        aB2.setLineColor(NOTES_SHADOW_COLOR_NORMAL);
        aB2.setAlignment((byte)0);
        aB2.setDistance(1.0);
        aB2.setTextColor(NOTES_CLOSE_COLOR);
        a2.addLabel(aB2);
        return aB2;
    }

    public static double getNotesCloseX(V v) {
        return v.getWidth() - 5.0 - 11.0;
    }

    public static double getNotesCloseY(V v) {
        return 5.0;
    }

    public static Rectangle2D.Double getNotesCloseRect(V v) {
        return new Rectangle2D.Double(DetailedNodeRealizer.getNotesCloseX(v), DetailedNodeRealizer.getNotesCloseY(v), 5.0, 5.0);
    }

    static {
        MaltegoLAF.Safe safe = new MaltegoLAF.Safe();
        NOTES_SHADOW_COLOR_NORMAL = ColorUtil.setAlpha((Color)safe.getColor("note-shadow-color"), (int)safe.getInt("note-shadow-alpha"));
        NOTES_SHADOW_COLOR_HOVER = ColorUtil.setAlpha((Color)safe.getColor("note-shadow-hover-color"), (int)safe.getInt("note-shadow-hover-alpha"));
        NOTES_LABEL_COLOR = safe.getColor("note-overlay-color");
        NOTES_LABEL_COLOR_EMPTY = ColorUtil.setAlpha((Color)safe.getColor("note-overlay-empty-color"), (int)safe.getInt("note-overlay-empty-aplha"));
        NOTES_CLOSE_COLOR = safe.getColor("note-close-button-color");
    }

    private static class NotesEditConfig
    extends XA {
        private double _oldScale = 0.0;
        private long _hackTime = 0L;
        private V _hackLabel = null;

        private NotesEditConfig() {
        }

        public void paintBox(V v, Graphics2D graphics2D, double d2, double d3, double d4, double d5) {
            Object object;
            Object object2;
            Object object3;
            double d6 = Math.ceil(d2 + 1.0);
            double d7 = Math.ceil(d3 + 1.0);
            double d8 = Math.floor(d4 - 5.0 - 3.0);
            double d9 = Math.floor(d5 - 5.0 - 3.0);
            Shape shape = new Rectangle2D.Double(d6, d7, d8, d9);
            double d10 = d6 + d8 * 0.5;
            double d11 = d7 + d9 * 0.5;
            if (v instanceof aB) {
                double d12;
                double d13;
                double d14;
                object3 = ((aB)v).getRealizer();
                object2 = ((aB)v).getNode();
                object = (QA)object2.H();
                .A a2 = object.f(object2);
                double d15 = object.S(object2);
                double d16 = object.O(object2);
                if (!a2.contains(d10, d11)) {
                    d14 = d10 - object3.getCenterX();
                    d13 = d11 - object3.getCenterY();
                    Point2D.Double double_ = new Point2D.Double();
                    a2.findIntersection(d15, d16, d10, d11, (Point2D)double_);
                    double d17 = Math.sqrt(d14 * d14 + d13 * d13);
                    if (d17 > 0.0) {
                        d15 = ((Point2D)double_).getX() - 10.0 * d14 / d17;
                        d16 = ((Point2D)double_).getY() - 10.0 * d13 / d17;
                    }
                }
                if ((d12 = Math.sqrt((d14 = d10 - d15) * d14 + (d13 = d11 - d16) * d13)) > 0.0) {
                    double d18 = Math.min(d8, d9) * 0.25;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo((float)d15, (float)d16);
                    generalPath.lineTo((float)(d10 + d13 * d18 / d12), (float)(d11 - d14 * d18 / d12));
                    generalPath.lineTo((float)(d10 - d13 * d18 / d12), (float)(d11 + d14 * d18 / d12));
                    generalPath.closePath();
                    Area area = new Area(shape);
                    area.add(new Area(generalPath));
                    shape = area;
                }
            }
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
            object3 = v.getBackgroundColor();
            if (object3 != null) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fill(shape);
                graphics2D.setColor((Color)object3);
                graphics2D.fillRect((int)d6, (int)d7, (int)d8, 10);
            }
            if ((object2 = v.getLineColor()) != null) {
                graphics2D.setColor((Color)object2);
                graphics2D.draw(shape);
            }
            graphics2D.setColor(NOTES_CLOSE_COLOR);
            graphics2D.translate(d2, d3);
            object = DetailedNodeRealizer.getNotesCloseRect(v);
            graphics2D.drawLine((int)object.x, (int)object.y, (int)(object.x + object.width), (int)(object.y + object.height));
            graphics2D.drawLine((int)(object.x + object.width), (int)object.y, (int)object.x, (int)(object.y + object.height));
            graphics2D.translate(-d2, -d3);
        }

        public void paintContent(V v, Graphics2D graphics2D, double d2, double d3, double d4, double d5) {
            super.paintContent(v, graphics2D, d2 + 10.0, d3 + 10.0, d4 - 20.0 - 5.0, d5 - 20.0 - 5.0);
        }

        public void paint(V v, Graphics2D graphics2D) {
            double d2 = graphics2D.getTransform().getScaleX();
            if (d2 != this._oldScale) {
                this._oldScale = d2;
                this._hackTime = System.currentTimeMillis();
                this._hackLabel = v;
            } else if (this._hackLabel == v) {
                this._hackTime = 0L;
            }
            if (System.currentTimeMillis() - this._hackTime < 1000L) {
                this.calculateContentSize(v, graphics2D.getFontRenderContext());
            }
            super.paint(v, graphics2D);
        }

        public void calculateContentSize(V v, FontRenderContext fontRenderContext) {
            super.calculateContentSize(v, fontRenderContext);
            int n = 25;
            v.setContentSize(v.getWidth() + (double)n, v.getHeight() + (double)n);
        }
    }

    private static class BookmarkConfig
    extends HoveredScaledConfig {
        private BookmarkConfig() {
        }

        @Override
        protected void paintScaled(V v, Graphics2D graphics2D, int n, int n2) {
            Color color = v.getBackgroundColor();
            boolean bl = this.isHovered(v);
            GraphicsUtils.drawShadedFatPentagram((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2, (Color)color, (boolean)bl, (boolean)bl);
        }

        public void calculateContentSize(V v, FontRenderContext fontRenderContext) {
            v.setContentSize(14.0, 14.0);
        }
    }

    private static class NotesConfig
    extends HoveredScaledConfig {
        private NotesConfig() {
        }

        @Override
        public void paintBox(V v, Graphics2D graphics2D, double d2, double d3, double d4, double d5) {
            d2 = Math.ceil(d2);
            d3 = Math.ceil(d3);
            d4 = Math.floor(d4 - 1.0);
            d5 = Math.floor(d5 - 3.0);
            super.paintBox(v, graphics2D, d2, d3, d4, d5);
        }

        @Override
        protected void paintScaled(V v, Graphics2D graphics2D, int n, int n2) {
            Color color = v.getBackgroundColor();
            Color color2 = ColorUtilities.brighterTranslucent((Color)color, (int)200, (int)color.getAlpha());
            Color color3 = new Color(50, 50, 50, color.getAlpha());
            int n3 = n / 2;
            int n4 = 3;
            int[] nArray = new int[]{3, 3, n - 3, n - 3, n3, 3};
            int[] nArray2 = new int[]{3, n2 - 3, n2 - 3, n3, 3, 3};
            if (this.isHovered(v)) {
                graphics2D.setColor(color);
            } else {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, n, n2, color);
                graphics2D.setPaint(gradientPaint);
            }
            graphics2D.fillPolygon(nArray, nArray2, nArray.length);
            if (this.isHovered(v)) {
                graphics2D.setStroke(new BasicStroke(5.0f, 1, 1));
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
                graphics2D.setColor(color3);
            }
            graphics2D.drawPolygon(nArray, nArray2, nArray.length);
            graphics2D.drawLine(n3, 3, n3, n3);
            graphics2D.drawLine(n3, n3, n - 3, n3);
        }

        public void calculateContentSize(V v, FontRenderContext fontRenderContext) {
            v.setContentSize(10.0, 14.0);
        }
    }

    private static abstract class HoveredScaledConfig
    extends XA {
        private HoveredScaledConfig() {
        }

        protected abstract void paintScaled(V var1, Graphics2D var2, int var3, int var4);

        public void paintBox(V v, Graphics2D graphics2D, double d2, double d3, double d4, double d5) {
            AffineTransform affineTransform = graphics2D.getTransform();
            double d6 = 0.1f;
            graphics2D.scale(d6, d6);
            int n = (int)(d2 / d6);
            int n2 = (int)(d3 / d6);
            int n3 = (int)(d4 / d6);
            int n4 = (int)(d5 / d6);
            graphics2D.translate(n, n2);
            this.paintScaled(v, graphics2D, n3, n4);
            graphics2D.setTransform(affineTransform);
        }

        protected boolean isHovered(V v) {
            boolean bl = false;
            Object object = v.getUserData();
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            return bl;
        }
    }

    public class EntiyNodeRealizer
    extends EntityLabelNodeRealizer {
        public void update() {
            DetailedNodeRealizer.this.updateSize((.A)this);
        }

        @Override
        protected FA create() {
            return DetailedNodeRealizer.this.create();
        }

        @Override
        protected void onTextUpdated() {
            this.update();
        }

        @Override
        protected void onNotesUpdated(String string) {
            Color color;
            aB aB2 = this.getLabel(1);
            if (aB2 != null) {
                color = NOTES_LABEL_COLOR;
                if (StringUtilities.isNullOrEmpty((String)string)) {
                    color = NOTES_LABEL_COLOR_EMPTY;
                } else {
                    aB2.setVisible(true);
                }
                aB2.setBackgroundColor(color);
            }
            if ((color = this.getLabel(3)) != null) {
                if (StringUtilities.isNullOrEmpty((String)string)) {
                    color.setText("");
                } else {
                    color.setText(string);
                }
            }
        }

        @Override
        protected void onShowNotesUpdated(boolean bl) {
            aB aB2 = this.getLabel(3);
            if (aB2 != null) {
                aB2.setVisible(bl);
            }
        }

        @Override
        protected void onBookmarkUpdated(Integer n) {
            aB aB2;
            BookmarkFactory bookmarkFactory = BookmarkFactory.getDefault();
            Color color = bookmarkFactory.getColor(n);
            aB aB3 = this.getLabel(2);
            if (aB3 != null) {
                aB3.setBackgroundColor(color);
                if (n != null) {
                    aB3.setVisible(true);
                }
            }
            if ((aB2 = this.getLabel(3)) != null) {
                color = bookmarkFactory.getNoteColor(n);
                aB2.setBackgroundColor(color);
            }
        }
    }
}

