/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.ui.graph.nodes.EntityNode;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.SpecActionMenuFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import yguard.A.A.D;

public class SpecActionsMenuAction
extends NodeAction
implements Presenter.Popup,
Presenter.Menu,
Presenter.Toolbar {
    protected void performAction(Node[] nodeArray) {
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray.length > 0;
    }

    public String getName() {
        return "Type Actions";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getPopupPresenter() {
        JMenu jMenu = null;
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray.length > 0) {
            EntityRegistry entityRegistry = this.getRegistry(nodeArray[0]);
            List<MaltegoEntity> list = this.getEntities(nodeArray);
            jMenu = new SpecActionMenuFactory().createMenu(this.getName(), list, entityRegistry);
        }
        return jMenu;
    }

    private List<MaltegoEntity> getEntities(Node[] nodeArray) {
        ArrayList<MaltegoEntity> arrayList = new ArrayList<MaltegoEntity>();
        for (Node node : nodeArray) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
            if (maltegoEntity == null) continue;
            arrayList.add(maltegoEntity);
        }
        return arrayList;
    }

    private EntityRegistry getRegistry(Node node) {
        EntityNode entityNode;
        GraphNode graphNode;
        EntityRegistry entityRegistry = null;
        if (node instanceof EntityNode && (graphNode = (entityNode = (EntityNode)node).findGraphNode()) != null) {
            D d2 = (D)graphNode.getLookup().lookup(D.class);
            entityRegistry = EntityRegistry.forGraph((D)d2);
        }
        if (entityRegistry == null) {
            System.out.println("Warning: Entity registry for graph not found. Falling back to default.");
            entityRegistry = EntityRegistry.getDefault();
        }
        return entityRegistry;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    protected String iconResource() {
        return "com/paterva/maltego/transform/runner/RunTransform.png";
    }
}

