/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.nodes.MergeEntitiesController;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.I.QA;
import yguard.A.J.M;

public class MergeAction
extends NodeAction {
    private static final String PREF_MERGE_LINKS = "mergeActionMergeSimilarLinks";

    protected void performAction(Node[] nodeArray) {
        GraphWrapper graphWrapper = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        D d2 = this.getModelGraph();
        QA qA = this.getGraph2D(d2);
        D d3 = this.getViewGraph(graphWrapper[0]);
        QA qA2 = this.getGraph2D(d3);
        MergeEntitiesController mergeEntitiesController = new MergeEntitiesController(Arrays.asList(graphWrapper));
        EditDialogDescriptor editDialogDescriptor = new EditDialogDescriptor("Select Primary Entity", (WizardDescriptor.Panel)mergeEntitiesController);
        boolean bl = NbPreferences.forModule(MergeAction.class).getBoolean(PREF_MERGE_LINKS, true);
        editDialogDescriptor.putProperty("mergeSimilarLinks", (Object)bl);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)editDialogDescriptor))) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)editDialogDescriptor.getProperty("primaryEntity");
            bl = (Boolean)editDialogDescriptor.getProperty("mergeSimilarLinks");
            NbPreferences.forModule(MergeAction.class).putBoolean(PREF_MERGE_LINKS, bl);
            ArrayList<MaltegoEntity> arrayList = new ArrayList<MaltegoEntity>();
            for (Object object : graphWrapper) {
                MaltegoEntity maltegoEntity2 = (MaltegoEntity)object.getLookup().lookup(MaltegoEntity.class);
                arrayList.add(maltegoEntity2);
            }
            GraphWrapper graphWrapper2 = MaltegoGraphManager.getWrapper((D)d2);
            GraphWrapper graphWrapper3 = MaltegoGraphManager.getWrapper((D)d3);
            M m = qA2.P(graphWrapper3.node(maltegoEntity));
            graphWrapper2.beginUpdate();
            for (MaltegoEntity maltegoEntity2 : arrayList) {
                if (maltegoEntity.equals(maltegoEntity2)) continue;
                PartMergeStrategy.PreferOriginal.merge((MaltegoPart)maltegoEntity, (MaltegoPart)maltegoEntity2);
                this.transferLinks(graphWrapper2, maltegoEntity2, maltegoEntity, bl);
                graphWrapper2.remove(maltegoEntity2);
            }
            graphWrapper2.reAdd(maltegoEntity);
            qA.A(graphWrapper2.node(maltegoEntity), m);
            graphWrapper2.endUpdate();
            qA2.A(graphWrapper3.node(maltegoEntity), true);
            StatusDisplayer.getDefault().setStatusText(arrayList.size() + " entities merged");
        }
    }

    private QA getGraph2D(D d2) {
        QA qA = null;
        if (d2 instanceof QA) {
            qA = (QA)d2;
        }
        return qA;
    }

    private M getCenter(List<MaltegoEntity> list, QA qA, GraphWrapper graphWrapper) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (MaltegoEntity maltegoEntity : list) {
            d2 += qA.U(graphWrapper.node(maltegoEntity));
            d3 += qA.N(graphWrapper.node(maltegoEntity));
        }
        M m = new M(d2 /= (double)list.size(), d3 /= (double)list.size());
        return m;
    }

    private void transferLinks(GraphWrapper graphWrapper, MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2, boolean bl) {
        Iterable iterable = graphWrapper.links(maltegoEntity);
        for (MaltegoLink maltegoLink : iterable) {
            MaltegoEntity maltegoEntity3 = graphWrapper.source(maltegoLink);
            MaltegoEntity maltegoEntity4 = graphWrapper.target(maltegoLink);
            graphWrapper.remove(maltegoLink);
            if (maltegoEntity3.equals(maltegoEntity)) {
                maltegoEntity3 = maltegoEntity2;
            } else {
                maltegoEntity4 = maltegoEntity2;
            }
            if (maltegoEntity3.equals(maltegoEntity4)) continue;
            MaltegoLink maltegoLink2 = null;
            if (bl) {
                maltegoLink2 = this.getMatchedLink(graphWrapper, maltegoEntity3, maltegoEntity4, maltegoLink);
            }
            if (maltegoLink2 != null) {
                PartMergeStrategy.PreferOriginal.merge(maltegoLink2, (MaltegoPart)maltegoLink);
                continue;
            }
            graphWrapper.connect(maltegoEntity3, maltegoEntity4, maltegoLink);
        }
    }

    private MaltegoLink getMatchedLink(GraphWrapper graphWrapper, MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2, MaltegoLink maltegoLink) {
        MaltegoLink maltegoLink2 = null;
        List<MaltegoLink> list = this.getBetweenLinks(graphWrapper, maltegoEntity, maltegoEntity2);
        for (MaltegoLink maltegoLink3 : list) {
            int n = MatchingRule.Default.match((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)maltegoLink3, (TypedPropertyBag)maltegoLink);
            if (-1 == n) continue;
            maltegoLink2 = maltegoLink3;
            break;
        }
        return maltegoLink2;
    }

    private List<MaltegoLink> getBetweenLinks(GraphWrapper graphWrapper, MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2) {
        ArrayList<MaltegoLink> arrayList = new ArrayList<MaltegoLink>();
        Y y = graphWrapper.node(maltegoEntity);
        Y y2 = graphWrapper.node(maltegoEntity2);
        Z z = y.G();
        while (z.ok()) {
            H h = z.edge();
            if (y2.equals(h.V())) {
                MaltegoLink maltegoLink = graphWrapper.link(h);
                arrayList.add(maltegoLink);
            }
            z.next();
        }
        return arrayList;
    }

    private D getModelGraph() {
        D d2 = null;
        TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
        DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        GraphCookie graphCookie = (GraphCookie)dataObject.getLookup().lookup(GraphCookie.class);
        if (graphCookie != null) {
            d2 = graphCookie.getGraph();
        }
        return d2;
    }

    private D getViewGraph(Node node) {
        Y y = (Y)node.getLookup().lookup(Y.class);
        D d2 = y.H();
        return d2;
    }

    protected boolean enable(Node[] nodeArray) {
        Node[] nodeArray2 = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        return nodeArray2 != null && nodeArray2.length > 1;
    }

    public String getName() {
        return "Merge";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

