/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class RoundRobinColorFactory
extends EntityColorFactory {
    private LegendColorMap _colors;

    @Override
    public Color getColor(MaltegoEntity maltegoEntity) {
        return this.getTypeColor(maltegoEntity.getTypeName());
    }

    @Override
    public Color getTypeColor(String string) {
        if (this._colors == null) {
            this._colors = new LegendColorMap();
        }
        return this._colors.get(string);
    }

    private static class LegendColorMap {
        private Map<Object, Color> _colorMap = new HashMap<Object, Color>();
        private Color[] _colorSequence;
        private int _last;
        private static final Color[] DefaultPalette = new Color[]{Color.decode("0xf26067"), Color.decode("0xffb359"), Color.decode("0x6fc866"), Color.decode("0x3863dc"), Color.decode("0x9a69ff"), Color.decode("0xa1624f"), Color.decode("0xff5998"), Color.decode("0xfff663"), Color.decode("0x83ffb2"), Color.decode("0x70e2e1"), Color.decode("0xffa7e7"), Color.decode("0xc0c0c0"), Color.decode("0xff7c49"), Color.decode("0xffda59"), Color.decode("0xc5ee6e"), Color.decode("0x5faad9"), Color.decode("0xcfc9ff"), Color.decode("0x808080")};
        private static final Color[] PrimaryColorPalette = new Color[]{Color.blue, Color.orange, Color.cyan, Color.yellow, Color.magenta, Color.green, Color.pink, Color.red};

        public LegendColorMap() {
            this(DefaultPalette);
        }

        public LegendColorMap(Color[] colorArray) {
            this._colorSequence = colorArray;
        }

        public Color get(Object object) {
            Color color = this._colorMap.get(object);
            if (color == null) {
                color = this.getNextColor();
                this._colorMap.put(object, color);
            }
            return color;
        }

        private Color getNextColor() {
            ++this._last;
            if (this._last > this._colorSequence.length - 1) {
                this._last = 0;
            }
            return this._colorSequence[this._last];
        }
    }
}

