/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.EntityImageFactory;
import com.paterva.maltego.util.ImageCallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.openide.util.NbBundle;
import yguard.A.A.D;

public class MergeEntityPanel
extends JPanel {
    private final int THUMBNAIL_SIZE = 90;
    private final int NAME_MAX = 40;
    private GraphWrapper _registryGraph;
    private MaltegoEntity _entity;
    private JLabel _imageLabel;
    private JLabel _linksLabel;
    private JLabel _propertiesLabel;
    private JLabel _typeDisplayLabel;
    private JLabel _typeLabel;
    private JLabel _valueLabel;
    private JPanel jPanel1;

    public MergeEntityPanel(GraphWrapper graphWrapper, GraphWrapper graphWrapper2, MaltegoEntity maltegoEntity, String string) {
        String string2;
        this._registryGraph = graphWrapper2;
        this._entity = maltegoEntity;
        EntityRegistry entityRegistry = EntityRegistry.forGraph((D)this._registryGraph.getGraph());
        this.initComponents();
        this.setEntityIcon();
        String string3 = "<empty>";
        Object object = InheritanceHelper.getDisplayValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 40) {
            string3 = string3.substring(0, 40) + "...";
        }
        this._valueLabel.setText(string3);
        String string4 = string2 = maltegoEntity.getTypeName();
        MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(string2);
        if (maltegoEntitySpec != null) {
            string4 = maltegoEntitySpec.getDisplayName();
        }
        this._typeLabel.setText(string2);
        this._typeDisplayLabel.setText(string4);
        this._linksLabel.setText(graphWrapper.node(maltegoEntity).N() + " links");
        this._propertiesLabel.setText(maltegoEntity.getProperties().size() + " properties");
        this.setBorder(new TitledBorder(string));
    }

    private void setEntityIcon() {
        EntityImageFactory entityImageFactory = EntityImageFactory.forGraph(this._registryGraph.getGraph());
        Icon icon = entityImageFactory.getIconMax(this._entity, 90, 90, new ThumbnailImageCallback());
        this._imageLabel.setText("");
        this._imageLabel.setIcon(icon);
    }

    private void initComponents() {
        this._imageLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this._typeDisplayLabel = new JLabel();
        this._typeLabel = new JLabel();
        this._valueLabel = new JLabel();
        this._linksLabel = new JLabel();
        this._propertiesLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this._imageLabel.setHorizontalAlignment(0);
        this._imageLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._imageLabel.text"));
        this.add((Component)this._imageLabel, "North");
        this.jPanel1.setPreferredSize(new Dimension(150, 75));
        this.jPanel1.setLayout(new GridLayout(0, 1));
        this._typeDisplayLabel.setFont(new Font("Tahoma", 0, 12));
        this._typeDisplayLabel.setForeground(SystemColor.controlShadow);
        this._typeDisplayLabel.setHorizontalAlignment(0);
        this._typeDisplayLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._typeDisplayLabel.text"));
        this.jPanel1.add(this._typeDisplayLabel);
        this._typeLabel.setFont(new Font("Tahoma", 0, 10));
        this._typeLabel.setForeground(SystemColor.controlShadow);
        this._typeLabel.setHorizontalAlignment(0);
        this._typeLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._typeLabel.text"));
        this.jPanel1.add(this._typeLabel);
        this._valueLabel.setFont(new Font("Tahoma", 0, 14));
        this._valueLabel.setHorizontalAlignment(0);
        this._valueLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._valueLabel.text"));
        this.jPanel1.add(this._valueLabel);
        this._linksLabel.setFont(new Font("Tahoma", 0, 10));
        this._linksLabel.setForeground(SystemColor.controlShadow);
        this._linksLabel.setHorizontalAlignment(0);
        this._linksLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._linksLabel.text"));
        this.jPanel1.add(this._linksLabel);
        this._propertiesLabel.setFont(new Font("Tahoma", 0, 10));
        this._propertiesLabel.setForeground(SystemColor.controlShadow);
        this._propertiesLabel.setHorizontalAlignment(0);
        this._propertiesLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._propertiesLabel.text"));
        this.jPanel1.add(this._propertiesLabel);
        this.add((Component)this.jPanel1, "Center");
    }

    private class ThumbnailImageCallback
    implements ImageCallback {
        private ThumbnailImageCallback() {
        }

        public void imageReady(Object object, Object object2) {
            MergeEntityPanel.this._imageLabel.setIcon((Icon)object2);
        }

        public void imageFailed(Object object, Exception exception) {
        }

        public boolean needAwtThread() {
            return true;
        }
    }
}

