/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityStringConverter;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.datatransfer.ExTransferable;

public class EntityListCopyAction
extends NodeAction {
    public String getName() {
        return "Copy (as List)";
    }

    protected void performAction(Node[] nodeArray) {
        Node[] nodeArray2 = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        EntityStringConverter entityStringConverter = (EntityStringConverter)Lookup.getDefault().lookup(EntityStringConverter.class);
        ArrayList<MaltegoEntity> arrayList = new ArrayList<MaltegoEntity>(nodeArray2.length);
        for (Node node : nodeArray2) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
            if (maltegoEntity == null) continue;
            arrayList.add(maltegoEntity);
        }
        final String string = entityStringConverter.convert(arrayList);
        ExTransferable.Single single = new ExTransferable.Single(DataFlavor.stringFlavor){

            protected Object getData() throws IOException, UnsupportedFlavorException {
                return string;
            }
        };
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        clipboard.setContents((Transferable)single, null);
    }

    protected boolean enable(Node[] nodeArray) {
        Node[] nodeArray2 = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        return nodeArray2 != null && nodeArray2.length > 0;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

