/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.ui.graph.CopyFactories;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.CookieAction;
import com.paterva.maltego.ui.graph.clipboard.GraphML;
import com.paterva.maltego.ui.graph.clipboard.GraphMLConverter;
import com.paterva.maltego.ui.graph.clipboard.MaltegoFlavor;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.D.q;
import yguard.A.I.;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.o;

public abstract class AbstractGraphMLPasteAction
extends CookieAction<GraphViewCookie> {
    public AbstractGraphMLPasteAction() {
        super(GraphViewCookie.class);
    }

    protected abstract void prePasteGraph(QA var1, QA var2);

    protected abstract void postPasteGraph(QA var1, QA var2);

    @Override
    protected void performAction(GraphViewCookie graphViewCookie) {
        GraphView graphView = graphViewCookie.getGraphView();
        JComponent jComponent = graphView.getViewControl();
        if (jComponent instanceof S) {
            S s = (S)jComponent;
            this.perform(s.H());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(QA qA) {
        GraphML graphML;
        try {
            WindowUtil.showWaitCursor();
            Transferable transferable = this.getTransferable();
            if (transferable == null || !transferable.isDataFlavorSupported(MaltegoFlavor.graphMLFlavor)) {
                return;
            }
            graphML = (GraphML)transferable.getTransferData(MaltegoFlavor.graphMLFlavor);
            QA qA2 = GraphMLConverter.convert(graphML);
            int n = 50;
            if (qA2.\u00e1() > 50) {
                String string = "Only 50 entities can be pasted in the free version of Maltego. Proceed with paste?";
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, "Paste Limit Reached", 2);
                if (NotifyDescriptor.Confirmation.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
                    qA2.\u010a();
                    int n2 = 0;
                    E e = qA2.\u00d1();
                    while (e.ok()) {
                        qA2.A(e.node(), n2 >= 50);
                        ++n2;
                        e.next();
                    }
                    qA2.\u0114();
                } else {
                    return;
                }
            }
            this.prePasteGraph(qA, qA2);
            this.pasteGraph(qA, qA2);
            this.postPasteGraph(qA, qA2);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            graphML = new NotifyDescriptor.Message((Object)("Failed to create entities from text.\n" + iOException.getMessage()), 0);
            graphML.setTitle("Paste Error");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)graphML);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    protected void pasteGraph(QA qA, QA qA2) {
        .A a2 = qA.\u0110();
        o o2 = qA.\u0116();
        qA.\u00e3();
        q._E _E2 = CopyFactories.create(a2, o2, true);
        q q2 = new q(_E2);
        q2.A((D)qA2, (D)qA);
        qA.\u00d0();
    }

    private Transferable getTransferable() {
        Clipboard clipboard = this.getClipboard();
        if (clipboard != null) {
            return clipboard.getContents(this);
        }
        return null;
    }

    private Clipboard getClipboard() {
        return (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

