/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.actions.EditorAction;
import com.paterva.maltego.ui.graph.actions.SelectLinks;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import yguard.A.A.D;
import yguard.A.I.QA;

public class SelectLinksAction
extends EditorAction
implements RibbonPresenter.Button {
    private JCommandButton _button;

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getRibbonButtonPresenter().setEnabled(bl);
    }

    public String getName() {
        return "Select Links";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/SelectLinks.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            this._button = new JCommandButton(this.getName(), ResizableIcons.fromResource((String)this.iconResource()));
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            RichTooltip richTooltip = new RichTooltip(this.getName(), "Select incoming and outgoing links for the selected entities");
            richTooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource()));
            richTooltip.addFooterSection("Click the help button to get more help on Maltego features");
            richTooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._button.setActionRichTooltip(richTooltip);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectLinksAction.this.select(0);
                }
            });
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton jCommandButton) {
                    return SelectLinksAction.this.createPopup();
                }
            });
        }
        return this._button;
    }

    private JCommandPopupMenu createPopup() {
        TopComponent topComponent = this.getTopComponent();
        ExplorerManager explorerManager = SelectLinksAction.find(topComponent);
        JCommandPopupMenu jCommandPopupMenu = new JCommandPopupMenu();
        if (explorerManager != null) {
            this.addMenuButton(jCommandPopupMenu, "Outgoing & Incoming (Ctrl+L)", 0);
            this.addMenuButton(jCommandPopupMenu, "Outgoing (Ctrl+End)", 1);
            this.addMenuButton(jCommandPopupMenu, "Incoming (Ctrl+Home)", 2);
        }
        return jCommandPopupMenu;
    }

    private void addMenuButton(JCommandPopupMenu jCommandPopupMenu, String string, final int n) {
        JCommandMenuButton jCommandMenuButton = new JCommandMenuButton(string, null);
        jCommandMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectLinksAction.this.select(n);
            }
        });
        jCommandPopupMenu.addMenuButton(jCommandMenuButton);
    }

    @Override
    protected void performAction(ExplorerManager explorerManager) throws PropertyVetoException {
    }

    public void select(int n) {
        TopComponent topComponent = this.getTopComponent();
        ExplorerManager explorerManager = SelectLinksAction.find(topComponent);
        if (explorerManager != null) {
            Node node = explorerManager.getRootContext();
            QA qA = (QA)node.getLookup().lookup(D.class);
            if (qA != null) {
                Node[] nodeArray = explorerManager.getSelectedNodes();
                SelectLinks.selectLinks(qA, nodeArray, n);
            }
            this.activateTopComponent(topComponent);
        }
    }

    private void activateTopComponent(final TopComponent topComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                topComponent.requestActive();
            }
        });
    }

    @Override
    protected boolean isEnabled(ExplorerManager explorerManager) {
        return explorerManager != null && explorerManager.getSelectedNodes().length > 0;
    }
}

