/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.ui.graph.BookmarkFactory;
import com.paterva.maltego.ui.graph.actions.EditorAction;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.actions.SelectionToggleAction;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public class SelectBookmarkedAction
extends EditorAction
implements RibbonPresenter.Button {
    private JCommandButton _button;

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getRibbonButtonPresenter().setEnabled(bl);
    }

    public String getName() {
        return "Select Bookmarked";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/Zoom.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            Integer n;
            BookmarkFactory bookmarkFactory = BookmarkFactory.getDefault();
            final JCommandPopupMenu jCommandPopupMenu = new JCommandPopupMenu();
            for (int i = -1; i < bookmarkFactory.getBookmarkCount(); ++i) {
                n = i >= 0 ? Integer.valueOf(i) : null;
                JCommandMenuButton jCommandMenuButton = new JCommandMenuButton("", (ResizableIcon)new ResizableBookmarkIcon(n));
                jCommandMenuButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectBookmarkedAction.this.selectBookmarked(n, false);
                    }
                });
                jCommandPopupMenu.addMenuButton(jCommandMenuButton);
            }
            MultiColorBookmarkIcon multiColorBookmarkIcon = new MultiColorBookmarkIcon();
            this._button = new JCommandButton(this.getName(), (ResizableIcon)multiColorBookmarkIcon);
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            n = new RichTooltip("Select Bookmarked", "Select bookmarked entities");
            n.addFooterSection("Click the help button to get more help on Maltego features");
            n.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._button.setActionRichTooltip((RichTooltip)n);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectBookmarkedAction.this.selectBookmarked(null, true);
                }
            });
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton jCommandButton) {
                    return jCommandPopupMenu;
                }
            });
        }
        return this._button;
    }

    @Override
    protected void performAction(ExplorerManager explorerManager) throws PropertyVetoException {
    }

    private void selectBookmarked(Integer n, boolean bl) {
        final TopComponent topComponent = this.getTopComponent();
        ExplorerManager explorerManager = SelectBookmarkedAction.find(topComponent);
        if (explorerManager != null) {
            if (SelectionMode.isLinks()) {
                ((SelectionToggleAction)SystemAction.get(SelectionToggleAction.class)).performAction();
            }
            List<Node> list = Arrays.asList(explorerManager.getRootContext().getChildren().getNodes());
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : list) {
                boolean bl2;
                MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
                if (maltegoEntity == null) continue;
                Integer n2 = maltegoEntity.getBookmark();
                boolean bl3 = bl2 = n2 == n || n2 != null && n2.equals(n);
                if (bl) {
                    boolean bl4 = bl2 = !bl2;
                }
                if (!bl2) continue;
                arrayList.add(node);
            }
            try {
                explorerManager.setSelectedNodes(arrayList.toArray(new Node[arrayList.size()]));
                ZoomToSelectionAction zoomToSelectionAction = (ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class);
                if (zoomToSelectionAction != null) {
                    zoomToSelectionAction.zoomToSelection();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topComponent.requestActive();
                }
            });
        }
    }

    private static class MultiColorBookmarkIcon
    extends ResizableSquareIcon {
        private MultiColorBookmarkIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                AffineTransform affineTransform = graphics2D.getTransform();
                double d2 = 0.1f;
                graphics2D.scale(d2, d2);
                int n3 = (int)((double)n / d2);
                int n4 = (int)((double)n2 / d2);
                int n5 = (int)((double)this.getIconHeight() / d2);
                graphics2D.translate(n3, n4);
                GraphicsUtils.drawShadedFatPentagram((Graphics2D)graphics2D, (int)0, (int)0, (int)n5, (int)n5, (Color)new Color(100, 255, 100), (Color)new Color(100, 100, 100));
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    private static class ResizableBookmarkIcon
    extends ResizableSquareIcon {
        private Integer _bookmark;

        public ResizableBookmarkIcon(Integer n) {
            this._bookmark = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            BookmarkFactory.getDefault().getIcon(this._bookmark, this.getIconWidth()).paintIcon(component, graphics, n, n2);
        }
    }

    private static abstract class ResizableSquareIcon
    implements ResizableIcon {
        private int _size;

        private ResizableSquareIcon() {
        }

        public void setDimension(Dimension dimension) {
            this._size = Math.min(dimension.width, dimension.height);
        }

        public int getIconWidth() {
            return this._size;
        }

        public int getIconHeight() {
            return this._size;
        }
    }
}

