/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public abstract class OpenTemplateAction
extends CallableSystemAction {
    private static AtomicInteger _integer = new AtomicInteger(0);

    public OpenTemplateAction() {
        this.putProperty("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        try {
            DataObject dataObject = this.getDataObject();
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            openCookie.open();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected DataObject getDataObject() throws DataObjectNotFoundException, IOException {
        String string = this.getTemplate();
        FileObject fileObject = FileUtil.getConfigRoot().getFileObject(string);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        FileSystem fileSystem = FileUtil.createMemoryFileSystem();
        FileObject fileObject2 = fileSystem.getRoot();
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, this.getName(string) + " (" + OpenTemplateAction.getNextCount() + ")");
        return dataObject2;
    }

    protected abstract String getTemplate();

    protected abstract String getName(String var1);

    private static int getNextCount() {
        return _integer.incrementAndGet();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

