/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigFileIO;
import com.paterva.maltego.java.config.ConfigOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;

public class ConfigFileWriter
extends ConfigFileIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ConfigOptions options) {
        if (options.getMaxHeapSize() == null) {
            return;
        }
        OutputStreamWriter fw = null;
        try {
            try {
                String configPath = this.getUserConfigFilePath();
                File dir = new File(new File(configPath).getParent());
                if (dir.exists() || dir.mkdirs()) {
                    File configFile = new File(configPath);
                    String maxMem = "-J-Xmx" + options.getMaxHeapSize() + "m";
                    String defaultOptions = "default_options=\"--branding maltego " + maxMem + " --locale en:US\"\n";
                    if (!configFile.exists()) {
                        fw = new FileWriter(configPath, false);
                        fw.write(defaultOptions);
                    } else {
                        BufferedReader reader = new BufferedReader(new FileReader(configFile));
                        String line = null;
                        String text = "";
                        while ((line = reader.readLine()) != null) {
                            text = text + line + "\n";
                        }
                        reader.close();
                        text = text.contains("-J-Xmx") ? text.replaceAll("-J-Xmx(\\d*)[kKmMgGbB]*", maxMem) : text + "\n" + defaultOptions;
                        fw = new FileWriter(configPath, false);
                        fw.write(text);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Unable to create " + dir.getPath(), "Error", 0);
                }
            }
            finally {
                if (fw != null) {
                    fw.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

