/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LicenseApprovalPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LicenseApprovalStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private LicenseApprovalPanel panel;
    private PanelBodyContainer component;
    private InstallUnitWizardModel model = null;
    private boolean isApproved = false;
    private WizardDescriptor wd;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD = "LicenseApprovalPanel_Header_Head";
    private static final String CONTENT = "LicenseApprovalPanel_Header_Content";
    private RequestProcessor.Task lazyLoadingTask = null;

    public LicenseApprovalStep(InstallUnitWizardModel model) {
        this.model = model;
    }

    public boolean isFinishPanel() {
        return false;
    }

    public Component getComponent() {
        if (this.component == null) {
            LicenseApprovalPanel tmp = new LicenseApprovalPanel(null, this.isApproved);
            this.component = new PanelBodyContainer(this.getBundle(HEAD), this.getBundle(CONTENT), tmp);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
            if (this.wd != null) {
                this.model.modifyOptionsForDoOperation(this.wd);
            }
            this.component.setWaitingState(true);
            this.appendLoadingLazy();
        }
        return this.component;
    }

    private void appendLoadingLazy() {
        this.lazyLoadingTask = Installer.RP.post(new Runnable(){

            @Override
            public void run() {
                LicenseApprovalStep.this.panel = new LicenseApprovalPanel(LicenseApprovalStep.this.model, LicenseApprovalStep.this.isApproved);
                LicenseApprovalStep.this.panel.addPropertyChangeListener("license-approved", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent arg0) {
                        LicenseApprovalStep.this.isApproved = LicenseApprovalStep.this.panel.isApproved();
                        LicenseApprovalStep.this.fireChange();
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LicenseApprovalStep.this.component.setBody(LicenseApprovalStep.this.panel);
                        LicenseApprovalStep.this.component.setWaitingState(false);
                        LicenseApprovalStep.this.fireChange();
                    }
                });
            }
        });
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
        if (this.panel != null) {
            this.model.modifyOptionsForDoOperation(wd);
        }
    }

    public void storeSettings(WizardDescriptor wd) {
        if (WizardDescriptor.NEXT_OPTION.equals(wd.getValue())) {
            this.model.addApprovedLicenses(this.panel.getLicenses());
        } else {
            this.model.modifyOptionsForStartWizard(wd);
        }
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            try {
                if (this.lazyLoadingTask != null && !this.lazyLoadingTask.isFinished()) {
                    this.lazyLoadingTask.cancel();
                }
                this.model.doCleanup(true);
            }
            catch (OperationException x) {
                Logger.getLogger(InstallUnitWizardModel.class.getName()).log(Level.INFO, x.getMessage(), x);
            }
        }
    }

    public boolean isValid() {
        return this.isApproved;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        LicenseApprovalStep licenseApprovalStep = this;
        synchronized (licenseApprovalStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(LicenseApprovalStep.class, (String)key);
    }
}

