/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class ColorHighlighter {
    private JTextComponent comp;
    private Highlighter.HighlightPainter painter;

    public ColorHighlighter(JTextComponent comp, Color c) {
        this.comp = comp;
        this.painter = new ColorHighlightPainter(c);
    }

    public int highlight(String word) {
        Highlighter highlighter = this.comp.getHighlighter();
        for (Highlighter.Highlight h : highlighter.getHighlights()) {
            if (!(h.getPainter() instanceof ColorHighlightPainter)) continue;
            highlighter.removeHighlight(h);
        }
        if (word == null || word.equals("")) {
            return -1;
        }
        String content = null;
        try {
            Document d = this.comp.getDocument();
            content = d.getText(0, d.getLength()).toLowerCase();
        }
        catch (BadLocationException e) {
            return -1;
        }
        word = word.toLowerCase();
        int lastIndex = 0;
        int firstOffset = -1;
        int wordSize = word.length();
        while ((lastIndex = content.indexOf(word, lastIndex)) != -1) {
            int endIndex = lastIndex + wordSize;
            try {
                highlighter.addHighlight(lastIndex, endIndex, this.painter);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            if (firstOffset == -1) {
                firstOffset = lastIndex;
            }
            lastIndex = endIndex;
        }
        return firstOffset;
    }

    class ColorHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public ColorHighlightPainter(Color color) {
            super(color);
        }
    }
}

