/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedJoinInfo;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinLexerInputOperation;
import org.netbeans.lib.lexer.JoinTokenListBase;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;

public class JoinTokenList<T extends TokenId>
implements TokenList<T> {
    private static final Logger LOG = Logger.getLogger(JoinTokenList.class.getName());
    protected final TokenListList<T> tokenListList;
    protected final JoinTokenListBase base;
    protected final int tokenListStartIndex;
    protected int activeTokenListIndex;
    protected EmbeddedTokenList<T> activeTokenList;
    protected int activeStartJoinIndex;
    protected int activeEndJoinIndex;

    public static <T extends TokenId> JoinTokenList<T> create(TokenListList<T> tokenListList, int tokenListStartIndex, int tokenListCount) {
        assert (tokenListCount > 0) : "tokenListCount must be >0";
        JoinTokenListBase base = new JoinTokenListBase(tokenListCount);
        JoinTokenList<T> jtl = new JoinTokenList<T>(tokenListList, base, tokenListStartIndex);
        super.init();
        return jtl;
    }

    public JoinTokenList(TokenListList<T> tokenListList, JoinTokenListBase base, int tokenListStartIndex) {
        this.tokenListList = tokenListList;
        this.base = base;
        this.tokenListStartIndex = tokenListStartIndex;
        this.activeTokenListIndex = -1;
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenListList.languagePath();
    }

    public TokenListList<T> tokenListList() {
        return this.tokenListList;
    }

    public JoinTokenListBase base() {
        return this.base;
    }

    public int tokenListStartIndex() {
        return this.tokenListStartIndex;
    }

    public EmbeddedTokenList<T> tokenList(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " < 0");
        }
        if (index >= this.base.tokenListCount) {
            throw new IndexOutOfBoundsException("index=" + index + " >= size()=" + this.base.tokenListCount);
        }
        return (EmbeddedTokenList)this.tokenListList.get(this.tokenListStartIndex + index);
    }

    public int tokenListCount() {
        return this.base.tokenListCount;
    }

    @Override
    public int tokenCountCurrent() {
        return this.base.joinTokenCount;
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    public int activeStartJoinIndex() {
        return this.activeStartJoinIndex;
    }

    public int activeEndJoinIndex() {
        return this.activeEndJoinIndex;
    }

    public int activeTokenListIndex() {
        return this.activeTokenListIndex;
    }

    public void setActiveTokenListIndex(int activeTokenListIndex) {
        if (this.activeTokenListIndex != activeTokenListIndex) {
            this.activeTokenListIndex = activeTokenListIndex;
            this.fetchActiveTokenListData();
        }
    }

    public EmbeddedTokenList<T> activeTokenList() {
        return this.activeTokenList;
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbedding(int index) {
        AbstractToken<T> token;
        TokenOrEmbedding<T> tokenOrEmbedding;
        this.locateTokenListByIndex(index);
        TokenOrEmbedding<T> tokenOrEmbedding2 = tokenOrEmbedding = this.activeTokenList != null ? this.activeTokenList.tokenOrEmbedding(index - this.activeStartJoinIndex) : null;
        if (index == this.activeStartJoinIndex && tokenOrEmbedding != null && (token = tokenOrEmbedding.token()).getClass() == PartToken.class) {
            tokenOrEmbedding = ((PartToken)token).joinTokenOrEmbedding();
        }
        return tokenOrEmbedding;
    }

    @Override
    public int tokenOffset(AbstractToken<T> token) {
        throw new IllegalStateException("Internal error - should never be called");
    }

    @Override
    public int tokenOffset(int index) {
        AbstractToken<T> token;
        this.locateTokenListByIndex(index);
        if (index == this.activeStartJoinIndex && (token = this.activeTokenList.tokenOrEmbedding(index - this.activeStartJoinIndex).token()).getClass() == PartToken.class) {
            return ((JoinToken)((PartToken)token).joinToken()).offset(null);
        }
        return this.activeTokenList.tokenOffset(index - this.activeStartJoinIndex);
    }

    public int tokenListIndex(int offset, int startIndex, int endIndex) {
        int low = startIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midStartOffset = this.tokenList(mid).startOffset();
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            high = mid;
            break;
        }
        return high;
    }

    @Override
    public int[] tokenIndex(int offset) {
        AbstractToken<T> token;
        boolean activeStartsBelowOffset;
        boolean bl = activeStartsBelowOffset = offset >= this.activeTokenList.startOffset() || this.activeTokenListIndex == 0;
        if (activeStartsBelowOffset) {
            if (offset >= this.activeTokenList.endOffset() && this.activeTokenListIndex + 1 != this.tokenListCount() && offset >= this.tokenList(this.activeTokenListIndex + 1).startOffset() && this.activeTokenListIndex + 1 < this.tokenListCount()) {
                this.activeTokenListIndex = this.tokenListIndex(offset, this.activeTokenListIndex + 1, this.tokenListCount());
                this.fetchActiveTokenListData();
            }
        } else if (this.activeTokenListIndex > 0) {
            this.activeTokenListIndex = this.tokenListIndex(offset, 0, this.activeTokenListIndex);
            if (this.activeTokenListIndex < 0) {
                this.activeTokenListIndex = 0;
            }
            this.fetchActiveTokenListData();
        }
        EmbeddedJoinInfo joinInfo = this.activeTokenList.joinInfo;
        int joinTokenLastPartShift = joinInfo.joinTokenLastPartShift();
        int searchETLTokenCount = this.activeTokenList.joinTokenCount();
        int[] indexAndTokenOffset = LexerUtilsConstants.tokenIndexBinSearch(this.activeTokenList, offset, searchETLTokenCount);
        int etlIndex = indexAndTokenOffset[0];
        indexAndTokenOffset[0] = indexAndTokenOffset[0] + joinInfo.joinTokenIndex();
        if (etlIndex == searchETLTokenCount && joinTokenLastPartShift > 0) {
            this.activeTokenListIndex += joinTokenLastPartShift;
            this.fetchActiveTokenListData();
            PartToken lastPartToken = (PartToken)this.activeTokenList.tokenOrEmbeddingUnsync(0).token();
            indexAndTokenOffset[1] = ((JoinToken)lastPartToken.joinToken()).offset(null);
        } else if (etlIndex == 0 && (token = this.activeTokenList.tokenOrEmbedding(0).token()).getClass() == PartToken.class) {
            indexAndTokenOffset[1] = ((JoinToken)((PartToken)token).joinToken()).offset(null);
        }
        return indexAndTokenOffset;
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        this.locateTokenListByIndex(index);
        return this.activeTokenList.replaceFlyToken(index - this.activeStartJoinIndex, flyToken, offset);
    }

    @Override
    public void wrapToken(int index, EmbeddingContainer<T> embeddingContainer) {
        this.locateTokenListByIndex(index);
        this.activeTokenList.wrapToken(index - this.activeStartJoinIndex, embeddingContainer);
    }

    @Override
    public final int modCount() {
        return this.rootTokenList().modCount() + this.base.extraModCount;
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.rootTokenList().inputAttributes();
    }

    @Override
    public int lookahead(int index) {
        this.locateTokenListByIndex(index);
        return this.activeTokenList.lookahead(index - this.activeStartJoinIndex);
    }

    @Override
    public Object state(int index) {
        this.locateTokenListByIndex(index);
        return this.activeTokenList.state(index - this.activeStartJoinIndex);
    }

    @Override
    public final TokenList<?> rootTokenList() {
        return this.tokenListList.rootTokenList();
    }

    @Override
    public CharSequence inputSourceText() {
        return this.rootTokenList().inputSourceText();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.rootTokenList().tokenHierarchyOperation();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.activeTokenListIndex == 0) {
            return this.activeTokenList.startOffset();
        }
        EmbeddedTokenList<T> firstEtl = this.tokenList(0);
        this.updateStatus(firstEtl);
        return firstEtl.startOffset();
    }

    @Override
    public int endOffset() {
        int tokenListCountM1 = this.tokenListCount() - 1;
        if (tokenListCountM1 < 0) {
            return 0;
        }
        if (this.activeTokenListIndex == tokenListCountM1) {
            return this.activeTokenList.endOffset();
        }
        EmbeddedTokenList<T> lastEtl = this.tokenList(tokenListCountM1);
        this.updateStatus(lastEtl);
        return lastEtl.endOffset();
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    public int tokenStartLocalIndex(int index) {
        int tokenCount = this.tokenCount();
        if (index != tokenCount) {
            this.locateTokenListByIndex(index);
            AbstractToken<T> token = this.activeTokenList.tokenOrEmbeddingUnsync(index - this.activeStartJoinIndex).token();
            if (token.getClass() == PartToken.class) {
                PartToken partToken = (PartToken)token;
                this.activeTokenListIndex -= ((JoinToken)partToken.joinToken()).extraTokenListSpanCount();
                this.fetchActiveTokenListData();
                return this.activeTokenList.tokenCountCurrent() - 1;
            }
            return index - this.activeStartJoinIndex;
        }
        this.setActiveTokenListIndex(this.tokenListCount());
        return 0;
    }

    protected final void locateTokenListByIndex(int joinIndex) {
        if (joinIndex < this.activeStartJoinIndex) {
            if (joinIndex < 0) {
                throw new IndexOutOfBoundsException("index=" + joinIndex + " < 0");
            }
            --this.activeTokenListIndex;
            this.fetchActiveTokenListData();
            if (joinIndex < this.activeStartJoinIndex) {
                this.positionToJoinIndex(joinIndex, 0, this.activeTokenListIndex - 1);
            }
        } else if (joinIndex == this.activeEndJoinIndex) {
            int lps;
            int n = lps = this.activeTokenList != null ? this.activeTokenList.joinInfo.joinTokenLastPartShift() : 0;
            if (lps > 0) {
                this.activeTokenListIndex += lps;
                this.fetchActiveTokenListData();
            } else if (this.activeTokenListIndex + 1 < this.tokenListCount()) {
                ++this.activeTokenListIndex;
                this.fetchActiveTokenListData();
                this.adjustJoinedOrSkipEmpty();
            }
        } else if (joinIndex > this.activeEndJoinIndex && this.activeTokenListIndex + 1 < this.tokenListCount()) {
            ++this.activeTokenListIndex;
            this.fetchActiveTokenListData();
            if (joinIndex >= this.activeEndJoinIndex) {
                this.positionToJoinIndex(joinIndex, this.activeTokenListIndex + 1, this.base.tokenListCount - 1);
            }
        }
    }

    private void positionToJoinIndex(int joinIndex, int low, int high) {
        while (low <= high) {
            this.activeTokenListIndex = low + high >>> 1;
            this.fetchActiveTokenListData();
            if (this.activeStartJoinIndex < joinIndex) {
                low = this.activeTokenListIndex + 1;
                continue;
            }
            if (this.activeStartJoinIndex > joinIndex) {
                high = this.activeTokenListIndex - 1;
                continue;
            }
            this.adjustJoinedOrSkipEmpty();
            return;
        }
        if (this.activeTokenListIndex != high) {
            this.activeTokenListIndex = high;
            this.fetchActiveTokenListData();
        }
    }

    private void adjustJoinedOrSkipEmpty() {
        if (this.activeStartJoinIndex == this.activeEndJoinIndex) {
            int lps = this.activeTokenList.joinInfo.joinTokenLastPartShift();
            if (lps > 0) {
                this.activeTokenListIndex += lps;
                this.fetchActiveTokenListData();
            } else {
                while (this.activeTokenList.tokenCountCurrent() == 0) {
                    ++this.activeTokenListIndex;
                    this.fetchActiveTokenListData();
                    if (this.activeTokenListIndex != this.tokenListCount()) continue;
                    return;
                }
                if (this.activeStartJoinIndex == this.activeEndJoinIndex) {
                    lps = this.activeTokenList.joinInfo.joinTokenLastPartShift();
                    this.activeTokenListIndex += lps;
                    this.fetchActiveTokenListData();
                }
            }
        }
    }

    protected final void fetchActiveTokenListData() {
        if (this.activeTokenListIndex != this.tokenListCount()) {
            this.activeTokenList = this.tokenList(this.activeTokenListIndex);
            this.updateStatus(this.activeTokenList);
            this.activeStartJoinIndex = this.activeTokenList.joinInfo.joinTokenIndex();
            this.activeEndJoinIndex = this.activeStartJoinIndex + this.activeTokenList.joinTokenCount();
        } else {
            this.activeTokenList = null;
            this.activeStartJoinIndex = this.activeEndJoinIndex = this.tokenCount();
        }
    }

    protected void updateStatus(EmbeddedTokenList<T> etl) {
        etl.embeddingContainer().updateStatus();
    }

    private void init() {
        JoinLexerInputOperation lexerInputOperation = new JoinLexerInputOperation(this, 0, null, 0, ((EmbeddedTokenList)this.tokenListList.get(this.tokenListStartIndex)).startOffset());
        lexerInputOperation.init();
        int joinTokenCount = 0;
        int tokenListCount = this.tokenListCount();
        if (tokenListCount > 0) {
            AbstractToken token;
            boolean loggable = LOG.isLoggable(Level.FINE);
            int tokenListIndex = 0;
            EmbeddedTokenList tokenList = this.initTokenList(tokenListIndex, joinTokenCount);
            while ((token = lexerInputOperation.nextToken()) != null) {
                int skipTokenListCount = lexerInputOperation.skipTokenListCount();
                if (skipTokenListCount > 0) {
                    while (--skipTokenListCount >= 0) {
                        tokenList = this.initTokenList(++tokenListIndex, joinTokenCount);
                    }
                    lexerInputOperation.clearSkipTokenListCount();
                }
                if (token.getClass() == JoinToken.class) {
                    JoinToken joinToken = (JoinToken)token;
                    List joinedParts = joinToken.joinedParts();
                    int extraTokenListSpanCount = joinToken.extraTokenListSpanCount();
                    int joinedPartIndex = 0;
                    for (int i = 0; i < extraTokenListSpanCount; ++i) {
                        tokenList.joinInfo.setJoinTokenLastPartShift(extraTokenListSpanCount - i);
                        if (tokenList.textLength() > 0) {
                            tokenList.addToken(joinedParts.get(joinedPartIndex++), 0, null);
                        }
                        tokenList = this.initTokenList(++tokenListIndex, joinTokenCount);
                    }
                    token = joinedParts.get(joinedPartIndex);
                }
                tokenList.addToken(token, lexerInputOperation);
                if (loggable) {
                    StringBuilder sb = new StringBuilder(50);
                    ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)joinTokenCount, (int)2);
                    token.dumpInfo(sb, null, true, true, 0);
                    sb.append('\n');
                    LOG.fine(sb.toString());
                }
                ++joinTokenCount;
            }
            if (loggable) {
                LOG.fine("JoinTokenList created for " + this.tokenListList.languagePath() + " with " + joinTokenCount + " tokens\n");
            }
            while (++tokenListIndex < tokenListCount) {
                tokenList = this.initTokenList(tokenListIndex, joinTokenCount);
            }
            for (int i = tokenListCount - 1; i >= 0; --i) {
                EmbeddedTokenList etl = (EmbeddedTokenList)this.tokenListList.get(this.tokenListStartIndex + i);
                etl.trimStorageToSize();
                assert (etl.joinInfo != null);
            }
        }
        this.base.joinTokenCount = joinTokenCount;
    }

    private EmbeddedTokenList<T> initTokenList(int tokenListIndex, int joinTokenCount) {
        EmbeddedTokenList<T> tokenList = this.tokenList(tokenListIndex);
        if (tokenList.tokenCountCurrent() > 0) {
            tokenList.clear();
        }
        assert (tokenList.joinInfo == null) : "Non-null joinInfo in tokenList " + tokenList.dumpInfo(null) + "\n" + this.tokenListList;
        tokenList.joinInfo = new EmbeddedJoinInfo(this.base, joinTokenCount, tokenListIndex);
        return tokenList;
    }

    public String checkConsistency() {
        String error = LexerUtilsConstants.checkConsistencyTokenList(this, false);
        if (error == null) {
            int joinTokenCount = 0;
            Token activeJoinToken = null;
            int joinedPartCount = 0;
            int nextCheckPartIndex = 0;
            for (int tokenListIndex = 0; tokenListIndex < this.tokenListCount(); ++tokenListIndex) {
                int etlTokenCount;
                EmbeddedTokenList<T> etl = this.tokenList(tokenListIndex);
                error = LexerUtilsConstants.checkConsistencyTokenList(etl, false);
                if (error != null) {
                    return error;
                }
                if (etl.joinInfo == null) {
                    return "Null joinInfo for ETL at token-list-index " + tokenListIndex;
                }
                if (joinTokenCount != etl.joinInfo.joinTokenIndex()) {
                    return "joinTokenIndex=" + joinTokenCount + " != etl.joinInfo.joinTokenIndex()=" + etl.joinInfo.joinTokenIndex() + " at token-list-index " + tokenListIndex;
                }
                if (tokenListIndex != etl.joinInfo.tokenListIndex()) {
                    return "token-list-index=" + tokenListIndex + " != etl.joinInfo.tokenListIndex()=" + etl.joinInfo.tokenListIndex();
                }
                int etlJoinTokenCount = etlTokenCount = etl.tokenCount();
                if (etlTokenCount > 0) {
                    AbstractToken<T> token = etl.tokenOrEmbeddingUnsync(0).token();
                    int startCheckIndex = 0;
                    if (activeJoinToken != null) {
                        if (token.getClass() != PartToken.class) {
                            return "Unfinished joinToken at token-list-index=" + tokenListIndex;
                        }
                        if ((error = this.checkConsistencyJoinToken((JoinToken<T>)activeJoinToken, token, nextCheckPartIndex++, tokenListIndex)) != null) {
                            return error;
                        }
                        if (nextCheckPartIndex == joinedPartCount) {
                            activeJoinToken = null;
                        } else {
                            if (etlTokenCount > 1) {
                                return "More than one token and non-last part of unfinished join token at token-list-index " + tokenListIndex;
                            }
                            --etlJoinTokenCount;
                        }
                        startCheckIndex = 1;
                    }
                    if (etlTokenCount > startCheckIndex) {
                        assert (activeJoinToken == null);
                        token = etl.tokenOrEmbeddingUnsync(etlTokenCount - 1).token();
                        if (token.getClass() == PartToken.class) {
                            --etlJoinTokenCount;
                            activeJoinToken = ((PartToken)token).joinToken();
                            joinedPartCount = ((JoinToken)activeJoinToken).joinedParts().size();
                            nextCheckPartIndex = 0;
                            if (joinedPartCount < 2) {
                                return "joinedPartCount=" + joinedPartCount + " < 2";
                            }
                            if ((error = this.checkConsistencyJoinToken((JoinToken<T>)activeJoinToken, token, nextCheckPartIndex++, tokenListIndex)) != null) {
                                return error;
                            }
                        }
                    }
                    for (int j = startCheckIndex; j < etlJoinTokenCount; ++j) {
                        if (etl.tokenOrEmbeddingUnsync(j).token().getClass() != PartToken.class) continue;
                        return "Inside PartToken at index " + j + "; joinTokenCount=" + etlJoinTokenCount;
                    }
                }
                if (etlJoinTokenCount != etl.joinTokenCount()) {
                    return "joinTokenCount=" + etlJoinTokenCount + " != etl.joinTokenCount()=" + etl.joinTokenCount() + " at token-list-index " + tokenListIndex;
                }
                joinTokenCount += etlJoinTokenCount;
            }
            if (activeJoinToken != null) {
                return "Unfinished join token at end";
            }
            if (joinTokenCount != this.base.joinTokenCount) {
                return "joinTokenCount=" + joinTokenCount + " != base.joinTokenCount=" + this.base.joinTokenCount;
            }
        }
        return error;
    }

    private String checkConsistencyJoinToken(JoinToken<T> joinToken, AbstractToken<T> token, int partIndex, int tokenListIndex) {
        PartToken partToken = (PartToken)token;
        if (joinToken.joinedParts().get(partIndex) != token) {
            return "activeJoinToken.joinedParts().get(" + partIndex + ") != token at token-list-index " + tokenListIndex;
        }
        if (partToken.joinToken() != joinToken) {
            return "Invalid join token of part at partIndex " + partIndex + " at token-list-index " + tokenListIndex;
        }
        EmbeddedTokenList<T> etl = this.tokenList(tokenListIndex);
        int lps = etl.joinInfo.joinTokenLastPartShift();
        if (lps < 0) {
            return "lps=" + lps + " < 0";
        }
        if (tokenListIndex + lps >= this.tokenListCount()) {
            return "Invalid lps=" + lps + " at token-list-index " + tokenListIndex + "; tokenListCount=" + this.tokenListCount();
        }
        AbstractToken<T> lastPart = this.tokenList(tokenListIndex + lps).tokenOrEmbeddingUnsync(0).token();
        if (lastPart.getClass() != PartToken.class) {
            return "Invalid lps: lastPart not PartToken " + lastPart.dumpInfo(null, null, true, true, 0) + " at token-list-index " + tokenListIndex;
        }
        if (((JoinToken)((PartToken)lastPart).joinToken()).lastPart() != lastPart) {
            return "Invalid lps: Not last part " + lastPart.dumpInfo(null, null, true, true, 0) + " at token-list-index " + tokenListIndex;
        }
        return null;
    }

    public StringBuilder dumpInfo(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(256);
        }
        int tokenListCount = this.tokenListCount();
        int digitCount = String.valueOf(tokenListCount - 1).length();
        int activeIndex = this.activeTokenListIndex;
        this.setActiveTokenListIndex(0);
        for (int i = 0; i < tokenListCount; ++i) {
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            this.tokenList(i).dumpInfo(sb);
            sb.append('\n');
        }
        this.setActiveTokenListIndex(activeIndex);
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb = this.dumpInfo(sb);
        return LexerUtilsConstants.appendTokenList(sb, this).toString();
    }
}

