/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.openide.util.ImageUtilities;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;

public class OfficeRibbonUI
extends BasicRibbonUI {
    protected static final Color background = new Color(0x535353);
    protected static final Color taskAreaBg1 = new Color(14146271);
    protected static final Color taskAreaBg2 = new Color(12699343);
    protected static final Color taskAreaBg3 = new Color(11844549);
    protected static final Color taskAreaBg4 = new Color(15200497);
    protected static final Color gray = new Color(0xBEBEBE);
    protected static final Color gray_0 = new Color(190, 190, 190, 0);
    protected static final Color gray2 = new Color(0xEBEBEB);
    protected static final Color gray3 = new Color(0xD3D3D3);
    protected static final Color gray_110 = new Color(190, 190, 190, 110);
    protected static final Color black_69 = new Color(0, 0, 0, 69);
    protected static final Color black_48 = new Color(0, 0, 0, 48);
    protected static final Color black_0 = new Color(0, 0, 0, 0);
    protected BufferedImage taskBackgroundCache;
    protected int tabSpacing = 1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeRibbonUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.ribbon.setOpaque(Boolean.FALSE.booleanValue());
    }

    protected void installComponents() {
        super.installComponents();
        this.ribbon.remove((Component)this.taskBarPanel);
        this.taskBarPanel = new TaskbarPanel();
        this.taskBarPanel.setName("JRibbon Task Bar");
        this.taskBarPanel.setLayout(this.createTaskbarLayoutManager());
        this.ribbon.add((Component)this.taskBarPanel);
        this.bandScrollablePanel.setOpaque(Boolean.FALSE.booleanValue());
        for (Component component : this.bandScrollablePanel.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setOpaque(false);
        }
        this.taskToggleButtonsScrollablePanel.setOpaque(Boolean.FALSE.booleanValue());
        for (Component component : this.taskToggleButtonsScrollablePanel.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setOpaque(false);
        }
    }

    protected LayoutManager createTaskbarLayoutManager() {
        return new TaskbarLayout();
    }

    protected BasicRibbonUI.BandHostPanel createBandHostPanel() {
        return new OfficeBandHostPanel();
    }

    protected BasicRibbonUI.TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new OfficeTaskToggleButtonsHostPanel();
    }

    public int getTaskbarHeight() {
        return 28;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics);
        Insets insets = jComponent.getInsets();
        int n = this.getTaskToggleButtonHeight();
        if (!this.isUsingTitlePane()) {
            n += this.getTaskbarHeight();
        }
        this.paintTaskArea(graphics, 0, insets.top + n - 1, jComponent.getWidth(), jComponent.getHeight() - n - insets.top);
    }

    protected void paintBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(background);
        int n = this.getTaskbarHeight() + this.ribbon.getInsets().top - 1;
        graphics2D.fillRect(0, n, this.ribbon.getWidth(), this.ribbon.getHeight() - n);
    }

    protected void paintTaskArea(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.taskBackgroundCache == null || n3 != this.taskBackgroundCache.getWidth() || n4 != this.taskBackgroundCache.getHeight()) {
            this.taskBackgroundCache = graphics2D.getDeviceConfiguration().createCompatibleImage(n3, n4, 3);
            Graphics2D graphics2D2 = this.taskBackgroundCache.createGraphics();
            OfficeRibbonUI.drawTaskAreaGradient(graphics2D2, n3, n4);
            graphics2D2.dispose();
        }
        graphics2D.drawImage((Image)this.taskBackgroundCache, n, n2, null);
    }

    protected static void drawTaskAreaGradient(Graphics2D graphics2D, int n, int n2) {
        int n3 = n - 1;
        int n4 = n2 - 1;
        int n5 = 3;
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 1.0f, 0.0f, 17.0f, new float[]{0.0f, 1.0f}, new Color[]{taskAreaBg1, taskAreaBg2}));
        graphics2D.fillRect(1, 1, n - 2, 16);
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 17.0f, 0.0f, n4 -= n5, new float[]{0.0f, 1.0f}, new Color[]{taskAreaBg3, taskAreaBg4}));
        graphics2D.fillRect(1, 17, n - 2, n2 - 18 - n5);
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{gray_0, gray};
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 4.0f, 0.0f, fArray, colorArray));
        graphics2D.drawLine(0, 0, n3 - 5, 0);
        graphics2D.drawLine(0, n4, n3 - 5, n4);
        graphics2D.setPaint(new LinearGradientPaint(n3, 0.0f, n3 - 4, 0.0f, fArray, colorArray));
        graphics2D.drawLine(n3 - 4, 0, n3, 0);
        graphics2D.drawLine(n3 - 4, n4, n3, n4);
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 4.0f, fArray, colorArray));
        graphics2D.drawLine(0, 0, 0, n4 - 5);
        graphics2D.drawLine(n3, 0, n3, n4 - 5);
        graphics2D.setPaint(new LinearGradientPaint(0.0f, n4, 0.0f, n4 - 4, fArray, colorArray));
        graphics2D.drawLine(0, n4 - 4, 0, n4);
        graphics2D.drawLine(n3, n4 - 4, n3, n4);
        graphics2D.setColor(gray2);
        graphics2D.drawLine(1, n4 - 2, n3 - 1, n4 - 2);
        graphics2D.setColor(gray3);
        graphics2D.drawLine(2, n4 - 1, n3 - 2, n4 - 1);
        graphics2D.setColor(gray);
        graphics2D.drawLine(1, 1, 1, 1);
        graphics2D.drawLine(1, n4 - 1, 1, n4 - 1);
        graphics2D.drawLine(n3 - 1, 1, n3 - 1, 1);
        graphics2D.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 - 1);
        graphics2D.setColor(gray_110);
        graphics2D.drawLine(1, 2, 1, 2);
        graphics2D.drawLine(2, 1, 2, 1);
        graphics2D.drawLine(n3 - 1, 2, n3 - 1, 2);
        graphics2D.drawLine(n3 - 2, 1, n3 - 2, 1);
        graphics2D.drawLine(n3 - 1, n4 - 2, n3 - 1, n4 - 2);
        graphics2D.drawLine(n3 - 2, n4 - 1, n3 - 2, n4 - 1);
        graphics2D.drawLine(1, n4 - 2, 1, n4 - 2);
        graphics2D.drawLine(2, n4 - 1, 2, n4 - 1);
        graphics2D.setPaint(new LinearGradientPaint(0.0f, (n4 += n5) - 2, 4.0f, n4 - 2, fArray, new Color[]{black_0, black_69}));
        graphics2D.drawLine(0, n4 - 2, n3 - 5, n4 - 2);
        graphics2D.setPaint(new LinearGradientPaint(n3, n4 - 2, n3 - 4, n4 - 2, fArray, new Color[]{black_0, black_69}));
        graphics2D.drawLine(n3 - 4, n4 - 2, n3, n4 - 2);
        graphics2D.setPaint(new LinearGradientPaint(0.0f, n4 - 1, 4.0f, n4 - 1, fArray, new Color[]{black_0, black_48}));
        graphics2D.drawLine(0, n4 - 1, n3 - 5, n4 - 1);
        graphics2D.setPaint(new LinearGradientPaint(n3, n4 - 1, n3 - 4, n4 - 1, fArray, new Color[]{black_0, black_48}));
        graphics2D.drawLine(n3 - 4, n4 - 1, n3, n4 - 1);
    }

    protected class OfficeBandHostPanel
    extends BasicRibbonUI.BandHostPanel {
        public OfficeBandHostPanel() {
            this.setOpaque(false);
        }
    }

    protected class OfficeTaskToggleButtonsHostPanel
    extends BasicRibbonUI.TaskToggleButtonsHostPanel {
        public OfficeTaskToggleButtonsHostPanel() {
            super((BasicRibbonUI)OfficeRibbonUI.this);
            this.setOpaque(false);
        }
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            int n2 = OfficeRibbonUI.this.getBandGap();
            for (Component component : OfficeRibbonUI.this.ribbon.getTaskbarComponents()) {
                n += component.getPreferredSize().width;
                n += n2;
            }
            return new Dimension(n + insets.left + insets.right, OfficeRibbonUI.this.getTaskbarHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = OfficeRibbonUI.this.getBandGap();
            int n2 = insets.left + 1 + OfficeRibbonUI.this.applicationMenuButton.getX() + OfficeRibbonUI.this.applicationMenuButton.getWidth();
            for (Component component : OfficeRibbonUI.this.ribbon.getTaskbarComponents()) {
                int n3 = component.getPreferredSize().width;
                component.setBounds(n2, 2, n3, container.getHeight() - insets.top - insets.bottom - 4);
                n2 += n3 + n;
            }
        }
    }

    private class TaskbarPanel
    extends JPanel {
        private final Image bgLeft;
        private final Image bg;
        private final Image bgRight;

        public TaskbarPanel() {
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(1, 0, 1, 0));
            this.bg = ImageUtilities.loadImage((String)"org/officelaf/ribbon/images/toolbar_bg.png", (boolean)true);
            this.bgLeft = ImageUtilities.loadImage((String)"org/officelaf/ribbon/images/toolbar_bg_left.png", (boolean)true);
            this.bgRight = ImageUtilities.loadImage((String)"org/officelaf/ribbon/images/toolbar_bg_right.png", (boolean)true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            if (this.getComponentCount() == 0) {
                return;
            }
            int n2 = this.getWidth();
            int n3 = 0;
            for (n = 0; n < this.getComponentCount(); ++n) {
                Component component = this.getComponent(n);
                n2 = Math.min(n2, component.getX());
                n3 = Math.max(n3, component.getX() + component.getWidth());
            }
            n = this.bgLeft.getWidth(this);
            int n4 = this.bg.getHeight(this);
            graphics.drawImage(this.bgLeft, n2 - n, 0, this);
            graphics.drawImage(this.bgRight, n3, 0, this);
            graphics.drawImage(this.bg, n2, 0, n3 - n2, n4, this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width + dimension.height / 2, dimension.height);
        }
    }
}

