/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.ImageCache;
import com.paterva.maltego.imgfactory.impl.CachedImageFactory;
import com.paterva.maltego.util.IconResourceProvider;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;

public class IconResourceImageFactory
extends ImageCache {
    private ImageCache _delegate;

    public IconResourceImageFactory() {
        this(new CachedImageFactory());
    }

    public IconResourceImageFactory(ImageCache imageCache) {
        this._delegate = imageCache;
    }

    @Override
    public ImageIcon getImageIcon(Object object, ImageCallback imageCallback) {
        return this.getImageIcon(object, -1, -1, imageCallback);
    }

    @Override
    public ImageIcon getImageIcon(Object object, int n, int n2, ImageCallback imageCallback) {
        if (!this.contains(object) && object instanceof String) {
            int n3 = IconResourceImageFactory.getResourceSize(n, n2);
            String string = object + String.valueOf(n3);
            if (!this.contains(string)) {
                Image image = IconResourceImageFactory.findImage((String)object, n3);
                if (image == null) {
                    System.out.println("No image found for key " + object);
                    return null;
                }
                this._delegate.addImageIcon(string, new ImageIcon(image));
            }
            return this._delegate.getImageIcon(string, n, n2, imageCallback);
        }
        return this._delegate.getImageIcon(object, n, n2, imageCallback);
    }

    @Override
    public Image getImage(Object object, ImageCallback imageCallback) {
        return this.getImage(object, -1, -1, imageCallback);
    }

    @Override
    public Image getImage(Object object, int n, int n2, ImageCallback imageCallback) {
        ImageIcon imageIcon = this.getImageIcon(object, n, n2, imageCallback);
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    private static Image findImage(String string, int n) {
        String string2 = IconResourceProvider.getDefault().getFullName(string);
        if (string2 == null) {
            return null;
        }
        string2 = ImageUtils.getImageFile((String)string2, (int)n);
        return ImageUtilities.loadImage((String)string2);
    }

    private static int getResourceSize(int n, int n2) {
        int n3 = IconResourceImageFactory.positiveMin(n, n2);
        int n4 = 48;
        if (n3 < 0) {
            n3 = 48;
        } else {
            n4 = n3 <= 20 ? 16 : (n3 <= 28 ? 24 : (n3 <= 38 ? 32 : 48));
        }
        return n4;
    }

    private static int positiveMin(int n, int n2) {
        if (n < 0 && n2 < 0) {
            return -1;
        }
        if (n < 0 && n2 > 0) {
            return n2;
        }
        if (n > 0 && n2 < 0) {
            return n;
        }
        return Math.min(n, n2);
    }

    @Override
    public void addImageIcon(Object object, ImageIcon imageIcon) {
        this._delegate.addImageIcon(object, imageIcon);
    }

    @Override
    public ImageIcon resizeImageIcon(Object object, ImageIcon imageIcon, int n, int n2, ImageCallback imageCallback) {
        return this._delegate.resizeImageIcon(object, imageIcon, n, n2, imageCallback);
    }

    @Override
    public void addImage(Object object, Image image) {
        this._delegate.addImage(object, image);
    }

    @Override
    public Image resizeImage(Object object, Image image, int n, int n2, ImageCallback imageCallback) {
        return this._delegate.resizeImage(object, image, n, n2, imageCallback);
    }

    @Override
    public boolean contains(Object object) {
        return this._delegate.contains(object);
    }

    @Override
    public void remove(Object object) {
        this._delegate.remove(object);
    }
}

