/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.ImageCache;
import com.paterva.maltego.imgfactory.impl.ImageFromFileCallback;
import com.paterva.maltego.imgfactory.impl.ImageFromFileThread;
import com.paterva.maltego.imgfactory.impl.ImageFromUrlCallback;
import com.paterva.maltego.imgfactory.impl.ImageFromUrlThread;
import com.paterva.maltego.imgfactory.impl.ImageID;
import com.paterva.maltego.imgfactory.impl.ImageIconCache;
import com.paterva.maltego.imgfactory.impl.ImageSizerCallback;
import com.paterva.maltego.imgfactory.impl.ImageSizerThread;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import sun.awt.shell.ShellFolder;

class CachedImageFactory
extends ImageCache
implements ImageFromUrlCallback,
ImageFromFileCallback,
ImageSizerCallback {
    private HashMap<Thread, FastURL> _urlThreads = new HashMap();
    private HashMap<Thread, Object> _fileThreads = new HashMap();
    private HashMap<Thread, ImageID> _sizerThreads = new HashMap();
    private HashMap<ImageID, ArrayList<CallbackOptions>> _imageRequests = new HashMap();
    private static HashMap<String, ImageIcon> _extIcons;
    private ImageIconCache _cache;
    private RequestProcessor _fetchProcessor;
    private RequestProcessor _resizeProcessor;
    private static int CONCURRENT_FETCH_THREADS;
    private static int CONCURRENT_RESIZE_THREADS;
    private static final boolean DEBUG = false;

    public CachedImageFactory() {
        this(300000, 600000);
    }

    public CachedImageFactory(int n, int n2) {
        _extIcons = new HashMap();
        this._cache = new ImageIconCache(n, n2);
        this._fetchProcessor = new RequestProcessor("Image Fetch Processor", CONCURRENT_FETCH_THREADS, true);
        this._resizeProcessor = new RequestProcessor("Resizing Processor", CONCURRENT_RESIZE_THREADS, true);
    }

    @Override
    public synchronized void addImageIcon(Object object, ImageIcon imageIcon) {
        ImageID imageID = new ImageID(object, -1, -1);
        this._cache.put(imageID, imageIcon);
    }

    @Override
    public synchronized ImageIcon getImageIcon(Object object, ImageCallback imageCallback) {
        return (ImageIcon)this.getImageGeneric(object, -1, -1, imageCallback, true);
    }

    @Override
    public synchronized ImageIcon getImageIcon(Object object, int n, int n2, ImageCallback imageCallback) {
        return (ImageIcon)this.getImageGeneric(object, n, n2, imageCallback, true);
    }

    @Override
    public synchronized ImageIcon resizeImageIcon(Object object, ImageIcon imageIcon, int n, int n2, ImageCallback imageCallback) {
        this.addImageIcon(object, imageIcon);
        return this.getImageIcon(object, n, n2, imageCallback);
    }

    @Override
    public synchronized void addImage(Object object, Image image) {
        ImageID imageID = new ImageID(object, -1, -1);
        this._cache.put(imageID, new ImageIcon(image));
    }

    @Override
    public synchronized Image getImage(Object object, ImageCallback imageCallback) {
        return (Image)this.getImageGeneric(object, -1, -1, imageCallback, false);
    }

    @Override
    public synchronized Image getImage(Object object, int n, int n2, ImageCallback imageCallback) {
        return (Image)this.getImageGeneric(object, n, n2, imageCallback, false);
    }

    @Override
    public synchronized Image resizeImage(Object object, Image image, int n, int n2, ImageCallback imageCallback) {
        this.addImage(object, image);
        ImageIcon imageIcon = this.getImageIcon(object, n, n2, imageCallback);
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    @Override
    public synchronized boolean contains(Object object) {
        ImageID imageID = new ImageID(object, -1, -1);
        return this._cache.contains(imageID);
    }

    @Override
    public void remove(Object object) {
        ImageID imageID = new ImageID(object, -1, -1);
        this._cache.remove(imageID, true);
    }

    private synchronized Object getImageGeneric(Object object, int n, int n2, ImageCallback imageCallback, boolean bl) {
        Object object2;
        if (object instanceof Attachments && (object = (object2 = (Attachments)object).getPrimaryImage()) == null) {
            return null;
        }
        object2 = new ImageID(object, n, n2);
        ImageID imageID = new ImageID(object, -1, -1);
        ImageIcon imageIcon = null;
        boolean bl2 = false;
        if (this._cache.contains((ImageID)object2)) {
            imageIcon = this._cache.get((ImageID)object2);
            bl2 = true;
        } else if (this._cache.contains(imageID) && !CachedImageFactory.mustResize((ImageID)object2, imageIcon = this._cache.get(imageID))) {
            bl2 = true;
        }
        if (!bl2) {
            if (imageCallback == null) {
                imageIcon = this.getImageIconNonThreaded(object, n, n2);
            } else {
                CallbackOptions callbackOptions = new CallbackOptions(imageCallback, bl);
                this.getImageIconThreaded(object, n, n2, callbackOptions);
                return null;
            }
        }
        if (bl || imageIcon == null) {
            return imageIcon;
        }
        return imageIcon.getImage();
    }

    private synchronized ImageIcon getImageIconNonThreaded(Object object, int n, int n2) {
        Serializable serializable;
        ImageID imageID = new ImageID(object, n, n2);
        ImageID imageID2 = new ImageID(object, -1, -1);
        ImageIcon imageIcon = null;
        if (this._cache.contains(imageID2)) {
            imageIcon = this._cache.get(imageID2);
        } else if (object instanceof FastURL) {
            try {
                imageIcon = new ImageIcon(ImageFromUrlThread.getImage(((FastURL)object).getURL()));
            }
            catch (IOException iOException) {
                Logger.getLogger(CachedImageFactory.class.getName()).log(Level.SEVERE, iOException.getMessage() + ": could not load image from URL (1) " + object, iOException);
                return null;
            }
            this._cache.put(imageID2, imageIcon);
        } else if (object instanceof File) {
            serializable = (File)object;
            try {
                BufferedImage bufferedImage = ImageFromFileThread.getImage((File)serializable);
                imageIcon = bufferedImage != null ? new ImageIcon(bufferedImage) : this.getShellIcon((File)serializable);
            }
            catch (IOException iOException) {
                Logger.getLogger(CachedImageFactory.class.getName()).log(Level.SEVERE, iOException.getMessage() + ": could not load image from file " + ((File)serializable).getAbsolutePath(), iOException);
                return null;
            }
            this._cache.put(imageID2, imageIcon);
        } else if (object instanceof Attachment) {
            serializable = (Attachment)object;
            try {
                File file = FileStore.getDefault().get(serializable.getId());
                BufferedImage bufferedImage = ImageFromFileThread.getImage(file);
                imageIcon = bufferedImage != null ? new ImageIcon(bufferedImage) : this.getShellIcon(new File(serializable.getFileName()));
            }
            catch (IOException iOException) {
                Logger.getLogger(CachedImageFactory.class.getName()).log(Level.SEVERE, iOException.getMessage() + ": could not load image from attachment (1) " + serializable, iOException);
                return null;
            }
            this._cache.put(imageID2, imageIcon);
        } else if (object instanceof Image) {
            this.addImage(object, (Image)object);
            imageIcon = this._cache.get(imageID2);
        } else if (object instanceof ImageIcon) {
            this.addImageIcon(object, (ImageIcon)object);
            imageIcon = this._cache.get(imageID2);
        } else {
            Logger.getLogger(CachedImageFactory.class.getName()).log(Level.SEVERE, "Original image not found. (1)");
            return null;
        }
        if (CachedImageFactory.mustResize(imageID, imageIcon)) {
            serializable = new ImageIcon(ImageSizerThread.resize(imageIcon.getImage(), n, n2));
            this._cache.put(imageID, (ImageIcon)serializable);
            return serializable;
        }
        return imageIcon;
    }

    private synchronized void getImageIconThreaded(Object object, int n, int n2, CallbackOptions callbackOptions) {
        ImageID imageID = new ImageID(object, n, n2);
        ImageID imageID2 = new ImageID(object, -1, -1);
        ArrayList<CallbackOptions> arrayList = this._imageRequests.get(imageID);
        if (arrayList != null) {
            this._imageRequests.get(imageID).add(callbackOptions);
        } else {
            Object object2;
            Object object3;
            Serializable serializable;
            boolean bl = false;
            if (this._cache.contains(imageID2)) {
                bl = true;
            } else if (object instanceof Image) {
                this.addImage(object, (Image)object);
                bl = true;
            } else if (object instanceof ImageIcon) {
                this.addImageIcon(object, (ImageIcon)object);
                bl = true;
            } else {
                serializable = new ArrayList();
                ((ArrayList)serializable).add(callbackOptions);
                this._imageRequests.put(imageID, (ArrayList<CallbackOptions>)serializable);
                if (object instanceof FastURL) {
                    try {
                        object3 = (FastURL)object;
                        if (!this._urlThreads.containsValue(object3)) {
                            object2 = new ImageFromUrlThread(object3.getURL(), this);
                            this._urlThreads.put((Thread)object2, (FastURL)object3);
                            this._fetchProcessor.post((Runnable)object2);
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(CachedImageFactory.class.getName()).log(Level.SEVERE, iOException.getMessage() + ": could not load image from URL (2) " + object, iOException);
                    }
                } else if (object instanceof File) {
                    object3 = (File)object;
                    if (!this._fileThreads.containsValue(object3)) {
                        object2 = new ImageFromFileThread((File)object3, (ImageFromFileCallback)this);
                        this._fileThreads.put((Thread)object2, object3);
                        this._fetchProcessor.post((Runnable)object2);
                    }
                } else if (object instanceof Attachment) {
                    object3 = (Attachment)object;
                    try {
                        if (!this._fileThreads.containsValue(object3)) {
                            object2 = FileStore.getDefault().get(object3.getId());
                            ImageFromFileThread imageFromFileThread = new ImageFromFileThread((File)object2, (ImageFromFileCallback)this);
                            this._fileThreads.put(imageFromFileThread, object3);
                            this._fetchProcessor.post((Runnable)imageFromFileThread);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Logger.getLogger(CachedImageFactory.class.getName()).log(Level.SEVERE, fileNotFoundException.getMessage() + ": could not load image from attachment (2) " + object3, fileNotFoundException);
                    }
                } else {
                    Logger.getLogger(CachedImageFactory.class.getName()).log(Level.SEVERE, "Original image not found. (2): {0}", object.toString());
                }
            }
            if (bl) {
                serializable = this._cache.get(imageID2);
                if (CachedImageFactory.mustResize(imageID, (ImageIcon)serializable)) {
                    object3 = new ArrayList();
                    object3.add(callbackOptions);
                    this._imageRequests.put(imageID, (ArrayList<CallbackOptions>)object3);
                    object2 = new ImageSizerThread(((ImageIcon)serializable).getImage(), n, n2, this);
                    this._sizerThreads.put((Thread)object2, imageID);
                    this._resizeProcessor.post((Runnable)object2);
                } else {
                    this.doCallback(imageID, callbackOptions.cb, callbackOptions.returnImageIcon ? serializable : ((ImageIcon)serializable).getImage());
                }
            }
        }
    }

    private void imageOriginalReady(Object object, Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        ImageID imageID = new ImageID(object, -1, -1);
        this._cache.put(imageID, imageIcon);
        Iterator<Map.Entry<ImageID, ArrayList<CallbackOptions>>> iterator = this._imageRequests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ImageID, ArrayList<CallbackOptions>> entry = iterator.next();
            ImageID imageID2 = entry.getKey();
            if (!imageID2.Key.equals(object)) continue;
            if (CachedImageFactory.mustResize(imageID2, imageIcon)) {
                ImageSizerThread imageSizerThread = new ImageSizerThread(imageIcon.getImage(), imageID2.Width, imageID2.Height, this);
                this._sizerThreads.put(imageSizerThread, imageID2);
                this._resizeProcessor.post((Runnable)imageSizerThread);
                continue;
            }
            if (!imageID2.equals(imageID)) {
                this._cache.put(imageID2, imageIcon);
            }
            this.notifyAllReady(imageID2, imageIcon);
            iterator.remove();
        }
    }

    private void imageOriginalFailed(Object object, Exception exception) {
        Iterator<Map.Entry<ImageID, ArrayList<CallbackOptions>>> iterator = this._imageRequests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ImageID, ArrayList<CallbackOptions>> entry = iterator.next();
            ImageID imageID = entry.getKey();
            if (!imageID.Key.equals(object)) continue;
            this.notifyAllFailed(imageID, exception);
            iterator.remove();
        }
    }

    @Override
    public synchronized void imageFromUrlReady(ImageFromUrlThread imageFromUrlThread, Image image) {
        FastURL fastURL = this._urlThreads.get(imageFromUrlThread);
        this.imageOriginalReady(fastURL, image);
        this._urlThreads.remove(imageFromUrlThread);
    }

    @Override
    public synchronized void imageFromUrlFailed(ImageFromUrlThread imageFromUrlThread, Exception exception) {
        FastURL fastURL = this._urlThreads.get(imageFromUrlThread);
        this.imageOriginalFailed(fastURL, exception);
        this._urlThreads.remove(imageFromUrlThread);
    }

    @Override
    public synchronized void imageFromFileReady(ImageFromFileThread imageFromFileThread, Image image) {
        Object object = this._fileThreads.get(imageFromFileThread);
        if (image == null) {
            Object object2;
            if (object instanceof Attachment) {
                object2 = (Attachment)object;
                try {
                    File file = FileStore.getDefault().get(object2.getId());
                    image = this.getShellIcon(file).getImage();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Exceptions.printStackTrace((Throwable)fileNotFoundException);
                }
            }
            if (object instanceof File) {
                object2 = (File)object;
                image = this.getShellIcon((File)object2).getImage();
            }
        }
        this.imageOriginalReady(object, image);
        this._fileThreads.remove(imageFromFileThread);
    }

    @Override
    public synchronized void imageFromFileFailed(ImageFromFileThread imageFromFileThread, Exception exception) {
        Object object = this._fileThreads.get(imageFromFileThread);
        this.imageOriginalFailed(object, exception);
        this._fileThreads.remove(imageFromFileThread);
    }

    @Override
    public synchronized void imageSizerReady(ImageSizerThread imageSizerThread, Image image) {
        ImageID imageID = this._sizerThreads.get(imageSizerThread);
        ImageIcon imageIcon = new ImageIcon(image);
        this._cache.put(imageID, imageIcon);
        this.notifyAllReady(imageID, imageIcon);
        this._imageRequests.remove(imageID);
        this._sizerThreads.remove(imageSizerThread);
    }

    @Override
    public synchronized void imageSizerFailed(ImageSizerThread imageSizerThread, Exception exception) {
        ImageID imageID = this._sizerThreads.get(imageSizerThread);
        this.notifyAllFailed(imageID, exception);
        this._imageRequests.remove(imageID);
        this._sizerThreads.remove(imageSizerThread);
    }

    private static boolean mustResize(ImageID imageID, ImageIcon imageIcon) {
        int n = imageID.Width;
        int n2 = imageID.Height;
        if (n == -1 && n2 == -1) {
            n = imageIcon.getIconWidth();
            n2 = imageIcon.getIconHeight();
        } else if (n == -1) {
            n = CachedImageFactory.calculateRelativeX(imageIcon.getIconWidth(), imageIcon.getIconHeight(), n2);
        } else if (n2 == -1) {
            n2 = CachedImageFactory.calculateRelativeY(imageIcon.getIconWidth(), imageIcon.getIconHeight(), n);
        }
        return imageIcon.getIconWidth() != n || imageIcon.getIconHeight() != n2;
    }

    private static int calculateRelativeY(float f, float f2, float f3) {
        float f4 = f2 / f * f3;
        return Math.round(f4);
    }

    private static int calculateRelativeX(float f, float f2, float f3) {
        float f4 = f / f2 * f3;
        return Math.round(f4);
    }

    private void notifyAllReady(ImageID imageID, ImageIcon imageIcon) {
        ArrayList<CallbackOptions> arrayList = this._imageRequests.get(imageID);
        for (int i = 0; i < arrayList.size(); ++i) {
            CallbackOptions callbackOptions = arrayList.get(i);
            try {
                if (callbackOptions.returnImageIcon) {
                    this.doCallback(imageID, callbackOptions.cb, imageIcon);
                    continue;
                }
                this.doCallback(imageID, callbackOptions.cb, imageIcon.getImage());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void notifyAllFailed(final ImageID imageID, final Exception exception) {
        ArrayList<CallbackOptions> arrayList = this._imageRequests.get(imageID);
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                final CallbackOptions callbackOptions = arrayList.get(i);
                if (callbackOptions.cb.needAwtThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            callbackOptions.cb.imageFailed((Object)imageID, exception);
                        }
                    });
                    continue;
                }
                callbackOptions.cb.imageFailed((Object)imageID, exception);
                continue;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void doCallback(final ImageID imageID, final ImageCallback imageCallback, final Object object) {
        if (imageCallback.needAwtThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    imageCallback.imageReady(imageID.Key, object);
                }
            });
        } else {
            imageCallback.imageReady(imageID.Key, object);
        }
    }

    private ImageIcon getShellIcon(File file) {
        String string = FileUtilities.getFileExtension((File)file);
        ImageIcon imageIcon = null;
        if (_extIcons.containsKey(string)) {
            imageIcon = _extIcons.get(string);
        } else {
            try {
                Image image;
                if (!file.exists()) {
                    file = File.createTempFile("maltego_att_icon", "." + string);
                    file.deleteOnExit();
                }
                if ((image = ShellFolder.getShellFolder(file).getIcon(true)) != null) {
                    imageIcon = new ImageIcon(image);
                }
                if (!string.toLowerCase().equals("ico")) {
                    _extIcons.put(string, imageIcon);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return imageIcon;
    }

    static {
        CONCURRENT_FETCH_THREADS = 5;
        CONCURRENT_RESIZE_THREADS = 3;
    }

    private class CallbackOptions {
        ImageCallback cb;
        boolean returnImageIcon;

        public CallbackOptions(ImageCallback imageCallback, boolean bl) {
            this.cb = imageCallback;
            this.returnImageIcon = bl;
        }
    }
}

