/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.repository.RepositoryUtils;
import com.paterva.maltego.transform.repository.serializer.TransformServerInfoSerializer;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.ListSet;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FSTransformServerRegistry
extends TransformServerRegistry {
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String SEED_FOLDER = "Servers";
    private static final String EXTENSION = "tas";
    private Map<FastURL, TransformServerFile> _map;
    private final Object _lock = new String();

    public Set<TransformServerInfo> findServers(String string, boolean bl) {
        ListSet listSet = new ListSet();
        for (TransformServerInfo transformServerInfo : this.getAll()) {
            if (!FSTransformServerRegistry.enabled(transformServerInfo, bl) || !transformServerInfo.getTransforms().contains(string)) continue;
            listSet.add(transformServerInfo);
        }
        return listSet;
    }

    public boolean exists(String string, boolean bl) {
        for (TransformServerInfo transformServerInfo : this.getAll()) {
            if (!FSTransformServerRegistry.enabled(transformServerInfo, bl) || !transformServerInfo.getTransforms().contains(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean enabled(TransformServerInfo transformServerInfo, boolean bl) {
        if (!bl) {
            return true;
        }
        return transformServerInfo.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TransformServerInfo transformServerInfo) {
        if (transformServerInfo.isDirty()) {
            try {
                Object object = this._lock;
                synchronized (object) {
                    boolean bl;
                    TransformServerFile transformServerFile = this.map().get(transformServerInfo.getUrl());
                    boolean bl2 = bl = transformServerFile == null;
                    if (bl) {
                        transformServerFile = new TransformServerFile(transformServerInfo, this.addServer(transformServerInfo));
                    } else {
                        this.updateServer(transformServerFile.getFile(), transformServerInfo);
                    }
                    this.map().put(transformServerInfo.getUrl(), transformServerFile);
                    transformServerInfo.markClean();
                    if (bl) {
                        this.fireItemAdded(transformServerInfo);
                    } else {
                        this.fireItemChanged(transformServerInfo);
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private FileObject addServer(TransformServerInfo transformServerInfo) throws IOException, XmlSerializationException {
        FileObject fileObject = FSTransformServerRegistry.getOrCreateTasFolder();
        FileObject fileObject2 = RepositoryUtils.createUniqueFile(fileObject, RepositoryUtils.replaceIllegalChars(transformServerInfo.getDisplayName()), EXTENSION);
        this.updateServer(fileObject2, transformServerInfo);
        return fileObject2;
    }

    private void updateServer(FileObject fileObject, TransformServerInfo transformServerInfo) throws IOException {
        this.save(fileObject, transformServerInfo);
        TransformServerFile transformServerFile = this.map().get(transformServerInfo.getUrl());
        if (transformServerFile == null) {
            transformServerFile = new TransformServerFile(transformServerInfo, fileObject);
            this.map().put(transformServerInfo.getUrl(), transformServerFile);
        } else {
            transformServerFile.setInfo(transformServerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(FileObject fileObject, TransformServerInfo transformServerInfo) throws IOException {
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            TransformServerInfoSerializer.write(transformServerInfo, outputStream);
            transformServerInfo.markClean();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformServerInfo get(FastURL fastURL) {
        Object object = this._lock;
        synchronized (object) {
            TransformServerFile transformServerFile = this.map().get(fastURL);
            if (transformServerFile == null) {
                return null;
            }
            return transformServerFile.getInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TransformServerInfo> getAll() {
        Object object = this._lock;
        synchronized (object) {
            LinkedList<TransformServerInfo> linkedList = new LinkedList<TransformServerInfo>();
            for (TransformServerFile transformServerFile : this.map().values()) {
                linkedList.add(transformServerFile.getInfo());
            }
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(FastURL fastURL) {
        Object object = this._lock;
        synchronized (object) {
            return this.map().containsKey(fastURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FastURL fastURL) {
        Object object = this._lock;
        synchronized (object) {
            TransformServerFile transformServerFile = this.map().get(fastURL);
            if (transformServerFile != null) {
                try {
                    transformServerFile.getFile().delete();
                    this.map().remove(fastURL);
                    this.fireItemRemoved(transformServerFile);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private static FileObject getOrCreateTasFolder() throws IOException {
        return FSTransformServerRegistry.getOrCreateFolder(FSTransformServerRegistry.getOrCreateMaltegoFolder(), SEED_FOLDER);
    }

    private static FileObject getOrCreateMaltegoFolder() throws IOException {
        FileObject fileObject = FileUtil.getConfigRoot();
        return FSTransformServerRegistry.getOrCreateFolder(fileObject, MALTEGO_FOLDER);
    }

    private static FileObject getOrCreateFolder(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject.getFileObject(string);
    }

    private static FileObject getTasFolder() {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject(MALTEGO_FOLDER);
        if (fileObject2 != null) {
            return fileObject2.getFileObject(SEED_FOLDER);
        }
        return null;
    }

    private Map<FastURL, TransformServerFile> map() {
        if (this._map == null) {
            this._map = this.load();
        }
        return this._map;
    }

    private Map<FastURL, TransformServerFile> load() {
        HashMap<FastURL, TransformServerFile> hashMap = new HashMap<FastURL, TransformServerFile>();
        FileObject fileObject = FSTransformServerRegistry.getTasFolder();
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getData(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (!EXTENSION.equals(fileObject2.getExt())) continue;
                try {
                    TransformServerInfo transformServerInfo = this.load(fileObject2);
                    transformServerInfo.markClean();
                    hashMap.put(transformServerInfo.getUrl(), new TransformServerFile(transformServerInfo, fileObject2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Exceptions.printStackTrace((Throwable)fileNotFoundException);
                }
                catch (XmlSerializationException xmlSerializationException) {
                    Exceptions.printStackTrace((Throwable)xmlSerializationException);
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransformServerInfo load(FileObject fileObject) throws FileNotFoundException, XmlSerializationException {
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            TransformServerInfo transformServerInfo = this.serializer().read(inputStream);
            return transformServerInfo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private TransformServerInfoSerializer serializer() {
        return new TransformServerInfoSerializer();
    }

    protected class TransformServerFile {
        private TransformServerInfo _info;
        private FileObject _file;

        public TransformServerFile() {
        }

        public TransformServerFile(TransformServerInfo transformServerInfo) {
            this(transformServerInfo, null);
        }

        public TransformServerFile(TransformServerInfo transformServerInfo, FileObject fileObject) {
            this._info = transformServerInfo;
            this._file = fileObject;
        }

        public TransformServerInfo getInfo() {
            return this._info;
        }

        public void setInfo(TransformServerInfo transformServerInfo) {
            this._info = transformServerInfo;
        }

        public FileObject getFile() {
            return this._file;
        }

        public void setFile(FileObject fileObject) {
            this._file = fileObject;
        }
    }
}

