/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.view2d.DetailedNodeRealizer;
import com.paterva.maltego.ui.graph.view2d.EntitySloppyPainter;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.view.ball.BallNodeRealizer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.openide.util.NbPreferences;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.I.;
import yguard.A.I.F;
import yguard.A.I.QA;
import yguard.A.I.S;

class BallPainter
extends F {
    private static final int HOTSPOT_SIZE = 10;
    private static boolean _paintAttachmentsOverlay;
    private static long _lastUpdate;
    private EntitySloppyPainter _sloppyPainter = new EntitySloppyPainter();

    protected void paintNode(.A a, Graphics2D graphics2D, boolean bl) {
        if (bl) {
            this._sloppyPainter.paintSloppy(a, graphics2D);
        } else {
            Y y = a.getNode();
            D d = y.H();
            double d2 = d.G(BallNodeRealizer.BALL_NODE_SIZE).getDouble((Object)y);
            double d3 = a.getY();
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)d);
            MaltegoEntity maltegoEntity = graphWrapper.entity(y);
            Color color = EntityColorFactory.getDefault().getColor(maltegoEntity);
            this.paintBall(a, graphics2D, color, d2);
            a.getLabel().setTextColor(color.darker().darker());
            if (System.currentTimeMillis() - _lastUpdate > 3000L) {
                _paintAttachmentsOverlay = NbPreferences.forModule(DetailedNodeRealizer.class).getBoolean("showAttachmentsOverlayIcons", true);
                _lastUpdate = System.currentTimeMillis();
            }
            if (_paintAttachmentsOverlay) {
                for (PropertyDescriptor propertyDescriptor : maltegoEntity.getProperties()) {
                    Attachments attachments;
                    if (!Attachments.class.equals((Object)propertyDescriptor.getType()) || (attachments = (Attachments)maltegoEntity.getValue(propertyDescriptor)) == null || attachments.isEmpty()) continue;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(a.getCenterX() - d2 / 2.0, d3);
                    graphics2D.scale(0.75, 0.75);
                    GraphicsUtils.drawPaperClip((Graphics2D)graphics2D, (double)0.0, (double)0.0);
                    graphics2D.setTransform(affineTransform);
                    break;
                }
            }
        }
    }

    private static double getZoom(.A a) {
        QA qA = (QA)a.getNode().H();
        S s = (S)qA.\u010c().current();
        return s.\u00dd();
    }

    private void paintBall(.A a, Graphics2D graphics2D, Color color, double d) {
        double d2 = BallPainter.getZoom(a);
        double d3 = d - 20.0;
        double d4 = a.getX() + 10.0 + a.getWidth() / 2.0 - d / 2.0;
        double d5 = a.getY() + 10.0;
        Color color2 = color.darker().darker();
        Color color3 = color.brighter().brighter();
        int n = 255;
        double d6 = 0.8;
        double d7 = 0.9;
        double d8 = 2.0 / d2;
        d8 = Math.min(d8, d3 / 10.0);
        graphics2D.setStroke(new BasicStroke((int)Math.ceil(d8 * 2.0)));
        int n2 = color2.getBlue();
        int n3 = color2.getGreen();
        int n4 = color2.getRed();
        double d9 = color3.getBlue() - n2;
        double d10 = color3.getGreen() - n3;
        double d11 = color3.getRed() - n4;
        int n5 = n2;
        int n6 = n3;
        int n7 = n4;
        Color color4 = new Color(n7, n6, n5, n);
        double d12 = d4;
        double d13 = d5;
        int n8 = (int)d12;
        int n9 = (int)d13;
        double d14 = d3;
        int n10 = (int)Math.ceil(d14);
        double d15 = 0.0;
        double d16 = 0.0;
        while (n10 > 0) {
            graphics2D.setColor(color4);
            graphics2D.drawOval(n8, n9, n10, n10);
            n8 = (int)(d12 += d8 * d6);
            n9 = (int)(d13 += d8 * d6);
            n10 = (int)Math.ceil(d14 -= 2.0 * d8);
            if (n10 <= 0) {
                int n11 = (int)Math.max(d8, 1.0);
                graphics2D.fillOval(n8 - n11, n9 - n11, 2 * n11 + 1, 2 * n11 + 1);
            }
            d15 = (d12 - d4) / (d3 / 2.0 * d6) * d7;
            d15 = Math.min(d15, 1.0);
            d16 = Math.sqrt(1.0 - Math.pow(1.0 - d15, 2.0));
            n5 = n2 + (int)(d9 * d16);
            n6 = n3 + (int)(d10 * d16);
            n7 = n4 + (int)(d11 * d16);
            color4 = new Color(n7, n6, n5, n);
        }
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    static {
        _lastUpdate = 0L;
    }
}

