/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.Utilities;

abstract class WeakListenerImpl
implements EventListener {
    private static final Logger LOG = Logger.getLogger(WeakListenerImpl.class.getName());
    private ListenerReference ref;
    Class listenerClass;
    private Reference<Object> source;

    protected WeakListenerImpl(Class listenerClass, EventListener l) {
        this.listenerClass = listenerClass;
        this.ref = new ListenerReference(l, this);
    }

    protected final void setSource(Object source) {
        this.source = source == null ? null : new WeakReference<Object>(source);
    }

    final Object getSource() {
        Reference<Object> r = this.source;
        return r == null ? null : r.get();
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject ev) {
        Object l = this.ref.get();
        if (l == null) {
            this.ref.requestCleanUp(ev == null ? null : ev.getSource());
        }
        return (EventListener)l;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object listener = this.ref.get();
        return this.getClass().getName() + "[" + (listener == null ? "null" : listener.getClass().getName() + "]");
    }

    public static <T extends EventListener> T create(Class<T> lType, Class<? super T> apiType, T l, Object source) {
        ProxyListener pl = new ProxyListener(lType, apiType, l);
        pl.setSource(source);
        return (T)((EventListener)lType.cast(pl.proxy));
    }

    private static final class ListenerReference
    extends WeakReference<Object>
    implements Runnable {
        private static Class lastClass;
        private static String lastMethodName;
        private static Method lastRemove;
        private static Object LOCK;
        WeakListenerImpl weakListener;

        public ListenerReference(Object ref, WeakListenerImpl weakListener) {
            super(ref, Utilities.activeReferenceQueue());
            this.weakListener = weakListener;
        }

        public synchronized void requestCleanUp(Object source) {
            if (this.weakListener == null) {
                return;
            }
            if (this.weakListener.getSource() != source) {
                this.weakListener.source = new WeakReference<Object>(source){
                    ListenerReference doNotGCRef;
                    {
                        this.doNotGCRef = new ListenerReference(new Object(), ListenerReference.this.weakListener);
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                WeakListenerImpl ref;
                Object src = null;
                Method remove = null;
                ListenerReference listenerReference = this;
                synchronized (listenerReference) {
                    block22: {
                        block21: {
                            ref = this.weakListener;
                            if (ref.source == null) break block21;
                            Object t = ref.source.get();
                            src = t;
                            if (t != null) break block22;
                        }
                        return;
                    }
                    this.weakListener = null;
                }
                Class<?> methodClass = src instanceof Class ? (Class<?>)src : src.getClass();
                String methodName = ref.removeMethodName();
                Object object = LOCK;
                synchronized (object) {
                    if (lastClass == methodClass && lastMethodName == methodName && lastRemove != null) {
                        remove = lastRemove;
                    }
                }
                if (remove == null) {
                    remove = this.getRemoveMethod(methodClass, methodName, new Class[]{ref.listenerClass});
                    if (remove == null) {
                        remove = this.getRemoveMethod(methodClass, methodName, new Class[]{String.class, ref.listenerClass});
                    }
                    if (remove == null) {
                        LOG.warning("Can't remove " + ref.listenerClass.getName() + " using method " + methodName + " from " + src);
                        return;
                    }
                    object = LOCK;
                    synchronized (object) {
                        lastClass = methodClass;
                        lastMethodName = methodName;
                        lastRemove = remove;
                    }
                }
                try {
                    if (remove.getParameterTypes().length == 1) {
                        remove.invoke(src, ref.getImplementator());
                    } else {
                        remove.invoke(src, "", ref.getImplementator());
                    }
                }
                catch (Exception ex) {
                    if ("removePreferenceChangeListener".equals(methodName) || "removeNodeChangeListener".equals(methodName)) break block20;
                    String errMessage = "Problem encountered while calling " + methodClass + "." + methodName + "(...) on " + src;
                    LOG.warning(errMessage);
                    boolean showErrMessage = ex instanceof InvocationTargetException || "object is not an instance of declaring class".equals(ex.getMessage());
                    LOG.log(Level.WARNING, showErrMessage ? errMessage : null, ex);
                }
            }
        }

        private Method getRemoveMethod(Class<?> methodClass, String methodName, Class<?>[] clarray) {
            Method m = null;
            try {
                m = methodClass.getMethod(methodName, clarray);
            }
            catch (NoSuchMethodException e) {
                do {
                    try {
                        m = methodClass.getDeclaredMethod(methodName, clarray);
                    }
                    catch (NoSuchMethodException ex) {
                        // empty catch block
                    }
                    methodClass = methodClass.getSuperclass();
                } while (m == null && methodClass != Object.class);
            }
            catch (LinkageError e) {
                LOG.log(Level.WARNING, null, e);
            }
            if (!(m == null || Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()))) {
                m.setAccessible(true);
            }
            return m;
        }

        static {
            LOCK = new Object();
        }
    }

    private static class ProxyListener
    extends WeakListenerImpl
    implements InvocationHandler {
        private static Method equalsMth;
        private static final Map<Class, Reference<Constructor>> constructors;
        public final Object proxy;

        public ProxyListener(Class c, Class api, EventListener listener) {
            super(api, listener);
            try {
                Object p;
                Constructor<?> proxyConstructor;
                Reference<Constructor> ref = constructors.get(c);
                Constructor<?> constructor = proxyConstructor = ref == null ? null : ref.get();
                if (proxyConstructor == null) {
                    Class<?> proxyClass = Proxy.getProxyClass(c.getClassLoader(), c);
                    proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
                    constructors.put(c, new SoftReference(proxyConstructor));
                }
                try {
                    p = proxyConstructor.newInstance(this);
                }
                catch (NoClassDefFoundError err) {
                    p = Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
                }
                this.proxy = p;
            }
            catch (Exception ex) {
                throw (IllegalStateException)new IllegalStateException(ex.toString()).initCause(ex);
            }
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = Object.class.getMethod("equals", Object.class);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            return equalsMth;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method == ProxyListener.getEquals()) {
                    boolean ret = this.equals(args[0]);
                    return ret ? Boolean.TRUE : Boolean.FALSE;
                }
                return method.invoke((Object)this, args);
            }
            EventObject ev = args != null && args[0] instanceof EventObject ? (EventObject)args[0] : null;
            EventListener listener = super.get(ev);
            if (listener != null) {
                return method.invoke((Object)listener, args);
            }
            return null;
        }

        @Override
        protected String removeMethodName() {
            String name = this.listenerClass.getName();
            int dot = name.lastIndexOf(46);
            int i = (name = name.substring(dot + 1)).lastIndexOf(36);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            return "remove".concat(name);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object obj) {
            return this.proxy == obj || this == obj;
        }

        @Override
        Object getImplementator() {
            return this.proxy;
        }

        static {
            constructors = new WeakHashMap<Class, Reference<Constructor>>();
        }
    }

    static final class Focus
    extends WeakListenerImpl
    implements FocusListener {
        public Focus(FocusListener l) {
            super(FocusListener.class, l);
        }

        @Override
        public void focusGained(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusGained(ev);
            }
        }

        @Override
        public void focusLost(FocusEvent ev) {
            FocusListener l = (FocusListener)super.get(ev);
            if (l != null) {
                l.focusLost(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    static final class Change
    extends WeakListenerImpl
    implements ChangeListener {
        public Change(ChangeListener l) {
            super(ChangeListener.class, l);
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            ChangeListener l = (ChangeListener)super.get(ev);
            if (l != null) {
                l.stateChanged(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    static final class Document
    extends WeakListenerImpl
    implements DocumentListener {
        public Document(DocumentListener l) {
            super(DocumentListener.class, l);
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.changedUpdate(ev);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.insertUpdate(ev);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            DocumentListener l = this.docGet(ev);
            if (l != null) {
                l.removeUpdate(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent ev) {
            DocumentListener l = (DocumentListener)((WeakListenerImpl)this).ref.get();
            if (l == null) {
                ((WeakListenerImpl)this).ref.requestCleanUp(ev.getDocument());
            }
            return l;
        }
    }

    static class VetoableChange
    extends WeakListenerImpl
    implements VetoableChangeListener {
        public VetoableChange(VetoableChangeListener l) {
            super(VetoableChangeListener.class, l);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            VetoableChangeListener l = (VetoableChangeListener)super.get(ev);
            if (l != null) {
                l.vetoableChange(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }

    static class PropertyChange
    extends WeakListenerImpl
    implements PropertyChangeListener {
        public PropertyChange(PropertyChangeListener l) {
            super(PropertyChangeListener.class, l);
        }

        PropertyChange(Class clazz, PropertyChangeListener l) {
            super(clazz, l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            PropertyChangeListener l = (PropertyChangeListener)super.get(ev);
            if (l != null) {
                l.propertyChange(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }
}

