/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.wizard.SampleHeaderRenderer;
import com.paterva.maltego.util.ui.table.ColumnSelectionTable;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openide.util.WeakListeners;

public abstract class SampleTableModel
extends AbstractTableModel {
    public static final String PROP_SELECTION_CHANGED = "selectionChanged";
    private static final int MAX_ROW_COUNT = 10;
    private TabularGraph _tabularGraph;
    private ArrayList<ArrayList<Object>> _sampleData;
    private TabularGraphListener _graphListener;
    private CustomizedSelectionTable _table;
    private Queue<Integer> _selection;
    private boolean _updatingTabularGraph = false;

    protected abstract Object getHeaderValue(int var1);

    public void setTabularGraph(TabularGraph tabularGraph) throws IOException {
        this._tabularGraph = tabularGraph;
        this._graphListener = new TabularGraphListener();
        this._tabularGraph.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._graphListener, (Object)this._tabularGraph));
        this.loadSampleData();
        this.createColumns();
        this.updateColumnNames();
        this.updateTableHeaders();
    }

    public TabularGraph getTabularGraph() {
        return this._tabularGraph;
    }

    public JTable getTable() {
        if (this._table == null) {
            this._table = new CustomizedSelectionTable();
            this._table.setAutoCreateColumnsFromModel(false);
            this._table.setModel(this);
            this._table.setColumnSelectionAllowed(true);
            this._table.setRowSelectionAllowed(false);
            this._table.getTableHeader().setReorderingAllowed(false);
            this._table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new SampleHeaderRenderer()));
            this._table.setFillsViewportHeight(true);
        }
        return this._table;
    }

    public void select(int[] nArray) {
        this._table.select(nArray);
        ListSelectionModel listSelectionModel = this._table.getColumnModel().getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        Rectangle rectangle = this._table.getCellRect(0, n, true);
        Rectangle rectangle2 = this._table.getCellRect(0, n2, true);
        this._table.scrollRectToVisible(rectangle.union(rectangle2));
    }

    @Override
    public int getRowCount() {
        if (this._sampleData != null) {
            this._sampleData.size();
            return this._sampleData.size() - (this._tabularGraph.hasHeaderRow() ? 1 : 0);
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this._tabularGraph != null) {
            return this._tabularGraph.getColumnCount();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ArrayList<Object> arrayList = this._sampleData.get(n + (this._tabularGraph.hasHeaderRow() ? 1 : 0));
        if (n2 < arrayList.size()) {
            Object object = arrayList.get(n2);
            if (object instanceof Date) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                return simpleDateFormat.format((Date)object);
            }
            if (object != null) {
                return object;
            }
        }
        return "";
    }

    protected void loadSampleData() throws IOException {
        this._sampleData = new ArrayList();
        TabularGraphIterator tabularGraphIterator = this._tabularGraph.getDataProvider().open();
        int n = 0;
        for (int i = 0; i < 10 && tabularGraphIterator.hasNext(); ++i) {
            ArrayList<Object> arrayList = tabularGraphIterator.getRow(null);
            this._sampleData.add(arrayList);
            n = Math.max(n, arrayList.size());
            tabularGraphIterator.next();
        }
        this._tabularGraph.getDataProvider().close();
        for (ArrayList<Object> arrayList : this._sampleData) {
            while (arrayList.size() < n) {
                arrayList.add(null);
            }
        }
        this._tabularGraph.setColumnCount(n);
        this.fireTableDataChanged();
    }

    protected void createColumns() {
        int n;
        for (n = this._table.getColumnCount() - 1; n >= 0; --n) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(n));
        }
        n = this._tabularGraph.getColumnCount() < 7 ? 1 : 0;
        this._table.setAutoResizeMode(n != 0 ? 4 : 0);
        for (int i = 0; i < this._tabularGraph.getColumnCount(); ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setPreferredWidth(100);
            this._table.getColumnModel().addColumn(tableColumn);
        }
    }

    protected void updateColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this._sampleData.get(0)) {
            if (this._tabularGraph.hasHeaderRow()) {
                arrayList.add(object == null ? "" : object.toString());
                continue;
            }
            arrayList.add("Column" + (arrayList.size() + 1));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        this._tabularGraph.setColumnNames(stringArray);
    }

    protected void updateTableHeaders() {
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(i);
            tableColumn.setHeaderValue(this.getHeaderValue(i));
        }
        this._table.getTableHeader().revalidate();
        this._table.getTableHeader().repaint();
    }

    protected String createHTMLHeader(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HTML><NOBR>");
        stringBuilder.append(string);
        stringBuilder.append("<BR>");
        stringBuilder.append(string2);
        stringBuilder.append("</NOBR></HTML>");
        return stringBuilder.toString();
    }

    protected boolean isUpdatingTabularGraph() {
        return this._updatingTabularGraph;
    }

    protected void onTabularGraphChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.isUpdatingTabularGraph()) {
            return;
        }
        if ("columnRemoved".equals(propertyChangeEvent.getPropertyName())) {
            Integer n = (Integer)((Object[])propertyChangeEvent.getOldValue())[1];
            if (this._table.isColumnSelected(n)) {
                this._table.changeSelection(0, n, true, false);
            }
        } else if ("hasHeaderRowChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.backupSelection();
            this.updateColumnNames();
            this.fireTableDataChanged();
            this.restoreSelection();
        }
    }

    protected void onColumnSelected(int n) {
    }

    protected void onColumnToggled(int[] nArray, int n, boolean bl) {
    }

    protected void backupSelection() {
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
        int n = listSelectionModel.getAnchorSelectionIndex();
        int n2 = listSelectionModel.getLeadSelectionIndex();
        int[] nArray = tableColumnModel.getSelectedColumns();
        this._selection = new ArrayDeque<Integer>(nArray.length + 2);
        this._selection.add(n);
        this._selection.add(n2);
        for (int n3 : nArray) {
            this._selection.add(n3);
        }
    }

    protected void restoreSelection() {
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
        int n = this._selection.remove();
        int n2 = this._selection.remove();
        for (Integer n3 : this._selection) {
            listSelectionModel.addSelectionInterval(n3, n3);
        }
        listSelectionModel.setAnchorSelectionIndex(n);
        listSelectionModel.setLeadSelectionIndex(n2);
        this._selection = null;
    }

    protected class CustomizedSelectionTable
    extends ColumnSelectionTable {
        protected CustomizedSelectionTable() {
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            SampleTableModel.this._updatingTabularGraph = true;
            int[] nArray = this.getSelectedColumns();
            super.changeSelection(n, n2, bl, bl2);
            if (!bl && !bl2) {
                int[] nArray2 = this.getSelectedColumns();
                if (nArray2.length == 1) {
                    SampleTableModel.this.onColumnSelected(nArray2[0]);
                }
            } else if (!bl2) {
                SampleTableModel.this.onColumnToggled(nArray, n2, this.isColumnSelected(n2));
            }
            this.firePropertyChange(SampleTableModel.PROP_SELECTION_CHANGED, null, null);
            SampleTableModel.this._updatingTabularGraph = false;
        }

        public void select(int[] nArray) {
            ListSelectionModel listSelectionModel = this.getColumnModel().getSelectionModel();
            int n = listSelectionModel.getAnchorSelectionIndex();
            listSelectionModel.clearSelection();
            for (int n2 : nArray) {
                listSelectionModel.addSelectionInterval(n2, n2);
            }
            listSelectionModel.setAnchorSelectionIndex(n);
            listSelectionModel.setLeadSelectionIndex(-1);
            this.firePropertyChange(SampleTableModel.PROP_SELECTION_CHANGED, null, null);
        }
    }

    protected class TabularGraphListener
    implements PropertyChangeListener {
        protected TabularGraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SampleTableModel.this.onTabularGraphChanged(propertyChangeEvent);
        }
    }
}

