/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.api.TabularGraphLink;
import com.paterva.maltego.graph.table.io.wizard.LinkMappingPanel;
import com.paterva.maltego.graph.table.io.wizard.MappingPanel;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.Exceptions;

public class LinkMappingController
extends ValidatingController<MappingPanel>
implements WizardDescriptor.ValidatingPanel {
    public LinkMappingController() {
        this.setName("Map Columns to Links");
    }

    protected MappingPanel createComponent() {
        return new LinkMappingPanel();
    }

    protected void readSettings(WizardDescriptor wizardDescriptor) {
        TabularGraph tabularGraph = (TabularGraph)wizardDescriptor.getProperty("graphTable");
        try {
            ((MappingPanel)this.component()).setTabularGraph(tabularGraph);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected void storeSettings(WizardDescriptor wizardDescriptor) {
    }

    public void validate() throws WizardValidationException {
        String string = null;
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        string = this.checkAllPropertiesMapped(tabularGraph);
        if (string != null) {
            throw new WizardValidationException((JComponent)this.component(), string, string);
        }
    }

    private String checkAllPropertiesMapped(TabularGraph tabularGraph) {
        List<TabularGraphLink> list = tabularGraph.getLinks();
        int n = 0;
        for (TabularGraphLink tabularGraphLink : list) {
            ++n;
            for (int n2 : tabularGraphLink.getColumns()) {
                PropertyDescriptor propertyDescriptor = tabularGraphLink.getProperty(n2);
                if (propertyDescriptor != null) continue;
                String string = tabularGraph.getColumnNames()[n2];
                ((MappingPanel)this.component()).select(tabularGraphLink.getColumns());
                return this.getUnmappedPropertyError(tabularGraphLink, n, string);
            }
        }
        return null;
    }

    private String getUnmappedPropertyError(TabularGraphLink tabularGraphLink, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tabularGraphLink.getIndex());
        stringBuilder.append("(");
        stringBuilder.append(n);
        stringBuilder.append(")->");
        stringBuilder.append(string);
        stringBuilder.append(" is not mapped to a property. All columns added to a link must be mapped.");
        return stringBuilder.toString();
    }
}

