/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.convert.TabularGraphConvertResult;
import com.paterva.maltego.graph.table.io.convert.TabularGraphConverter;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportOptions;
import com.paterva.maltego.graph.table.io.wizard.ImportFailurePanel;
import com.paterva.maltego.graph.table.io.wizard.ImportSuccessPanel;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;

class ImportProgressController
extends PassFailProgressController<TabularGraphConvertResult, ImportSuccessPanel, ImportFailurePanel> {
    private TabularGraphConvertResult _result;

    public ImportProgressController() {
        this.setName("Import");
    }

    protected void storeSettings(WizardDescriptor wizardDescriptor) {
        super.storeSettings(wizardDescriptor);
        wizardDescriptor.putProperty("importedGraph", (Object)this._result.Graph);
        wizardDescriptor.putProperty("newGraph", (Object)((ImportSuccessPanel)this.successComponent()).getNewGraph());
    }

    protected ImportSuccessPanel createPassComponent() {
        return new ImportSuccessPanel();
    }

    protected ImportFailurePanel createFailComponent() {
        return new ImportFailurePanel("Data read error!");
    }

    protected void pass(WizardDescriptor wizardDescriptor, ImportSuccessPanel importSuccessPanel, TabularGraphConvertResult tabularGraphConvertResult) {
        this._result = tabularGraphConvertResult;
        importSuccessPanel.setResult(tabularGraphConvertResult);
        importSuccessPanel.setNewGraph((Boolean)wizardDescriptor.getProperty("newGraph"));
        importSuccessPanel.setShowMergeOption((Boolean)wizardDescriptor.getProperty("showMergeGraphOption"));
    }

    protected void fail(ImportFailurePanel importFailurePanel, Exception exception) {
        if (exception == null) {
            importFailurePanel.setError(null);
        } else {
            importFailurePanel.setError(exception.getMessage());
        }
    }

    protected TabularGraphConvertResult doProcessing(WizardDescriptor wizardDescriptor, ProgressHandle progressHandle) throws Exception {
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        MatchingRule matchingRule = MatchingRule.Default;
        TabularGraphConverter tabularGraphConverter = new TabularGraphConverter(tabularGraph);
        tabularGraphConverter.setEntityRule(matchingRule);
        if (!TabularGraphImportOptions.isMergeLinks()) {
            matchingRule = null;
        }
        tabularGraphConverter.setLinkRule(matchingRule);
        tabularGraphConverter.setHandle(progressHandle);
        return tabularGraphConverter.convert();
    }

    public boolean canBack() {
        return false;
    }
}

