/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.TabularGraphDataProvider;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraph;
import com.paterva.maltego.util.FileExtensionFileFilter;
import com.paterva.maltego.util.ui.dialog.FileController;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

class ImportFileController<TData>
extends FileController {
    public ImportFileController() {
        super(0, null, null);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        super.readSettings(wizardDescriptor);
        TabularGraphFileImporter[] tabularGraphFileImporterArray = (TabularGraphFileImporter[])wizardDescriptor.getProperty("importers");
        this.populateFileTypes(tabularGraphFileImporterArray);
    }

    private void populateFileTypes(TabularGraphFileImporter[] fileExtensionFileFilter) {
        JFileChooser jFileChooser = (JFileChooser)this.component();
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TabularGraphFileImporter tabularGraphFileImporter : fileExtensionFileFilter) {
            String string = tabularGraphFileImporter.getExtension();
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter(tabularGraphFileImporter.getFileTypeDescription(), string));
            arrayList.add(string);
        }
        FileExtensionFileFilter fileExtensionFileFilter2 = new FileExtensionFileFilter(arrayList.toArray(new String[arrayList.size()]), "Tabular file");
        jFileChooser.addChoosableFileFilter((FileFilter)fileExtensionFileFilter2);
        jFileChooser.setFileFilter((FileFilter)fileExtensionFileFilter2);
    }

    public void validate() throws WizardValidationException {
        String string = null;
        File file = this.getSelectedFile();
        if (file == null || !file.exists()) {
            string = "Please select a file to import";
        } else {
            TabularGraphFileImporter[] tabularGraphFileImporterArray = (TabularGraphFileImporter[])this.getDescriptor().getProperty("importers");
            TabularGraphFileImporter tabularGraphFileImporter = null;
            for (TabularGraphFileImporter tabularGraphFileImporter2 : tabularGraphFileImporterArray) {
                if (!file.getName().endsWith("." + tabularGraphFileImporter2.getExtension())) continue;
                tabularGraphFileImporter = tabularGraphFileImporter2;
                break;
            }
            this.getDescriptor().putProperty("fileImporter", tabularGraphFileImporter);
            if (tabularGraphFileImporter == null) {
                string = "No importer found for the selected file type";
            } else {
                tabularGraphFileImporter.setFile(file);
                DefaultTabularGraph defaultTabularGraph = new DefaultTabularGraph(tabularGraphFileImporter);
                try {
                    string = this.testFirst10Rows(defaultTabularGraph);
                    if (string == null) {
                        this.getDescriptor().putProperty("graphTable", (Object)defaultTabularGraph);
                    }
                }
                catch (IOException iOException) {
                    string = "Unable to read file: " + iOException.getMessage();
                }
            }
        }
        if (string != null) {
            throw new WizardValidationException((JComponent)this.component(), string, string);
        }
    }

    String testFirst10Rows(TabularGraph tabularGraph) throws IOException {
        ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
        TabularGraphDataProvider tabularGraphDataProvider = tabularGraph.getDataProvider();
        TabularGraphIterator tabularGraphIterator = tabularGraphDataProvider.open();
        for (int i = 0; i < 10 && tabularGraphIterator.hasNext(); ++i) {
            ArrayList<Object> arrayList2 = tabularGraphIterator.getRow(null);
            arrayList.add(arrayList2);
            if (!arrayList2.isEmpty()) {
                for (Object object : arrayList2) {
                    if (object == null) continue;
                    tabularGraphDataProvider.close();
                    return null;
                }
            }
            tabularGraphIterator.next();
        }
        tabularGraphDataProvider.close();
        return "The file contains no useable data.";
    }
}

