/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.api.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.wizard.EntityMappingPanel;
import com.paterva.maltego.graph.table.io.wizard.MappingPanel;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.Exceptions;

public class EntityMappingController
extends ValidatingController<MappingPanel>
implements WizardDescriptor.ValidatingPanel {
    private boolean firstTime = true;

    public EntityMappingController() {
        this.setName("Map Columns to Entities");
    }

    protected MappingPanel createComponent() {
        return new EntityMappingPanel();
    }

    protected void readSettings(WizardDescriptor wizardDescriptor) {
        TabularGraph tabularGraph = (TabularGraph)wizardDescriptor.getProperty("graphTable");
        try {
            ((MappingPanel)this.component()).setTabularGraph(tabularGraph);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected void storeSettings(WizardDescriptor wizardDescriptor) {
    }

    public void validate() throws WizardValidationException {
        String string = null;
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        List<TabularGraphEntity> list = tabularGraph.getEntities();
        string = list == null || list.isEmpty() ? "No columns have been mapped." : this.checkAllPropertiesMapped(tabularGraph);
        if (string != null) {
            throw new WizardValidationException((JComponent)this.component(), string, string);
        }
    }

    private String checkAllPropertiesMapped(TabularGraph tabularGraph) {
        List<TabularGraphEntity> list = tabularGraph.getEntities();
        int n = 0;
        for (TabularGraphEntity tabularGraphEntity : list) {
            ++n;
            for (int n2 : tabularGraphEntity.getColumns()) {
                PropertyDescriptor propertyDescriptor = tabularGraphEntity.getProperty(n2);
                if (propertyDescriptor != null) continue;
                String string = tabularGraph.getColumnNames()[n2];
                ((MappingPanel)this.component()).select(tabularGraphEntity.getColumns());
                return this.getUnmappedPropertyError(tabularGraphEntity, n, string);
            }
        }
        return null;
    }

    private String getUnmappedPropertyError(TabularGraphEntity tabularGraphEntity, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tabularGraphEntity.getEntitySpec().getDisplayName());
        stringBuilder.append("(");
        stringBuilder.append(n);
        stringBuilder.append(")->");
        stringBuilder.append(string);
        stringBuilder.append(" is not mapped to a property. All columns added to an entity must be mapped.");
        return stringBuilder.toString();
    }
}

