/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.graph;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.api.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.api.TabularGraphLink;
import com.paterva.maltego.graph.table.io.graph.ConnectivityNodeRealizer;
import com.paterva.maltego.graph.table.io.graph.DeleteLinksAction;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.ui.graph.view2d.MouseWheelZoomListener;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.SelectionBoxViewMode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import yguard.A.A.A;
import yguard.A.A.C;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.A._;
import yguard.A.G.JA;
import yguard.A.G.NA;
import yguard.A.G.l;
import yguard.A.I.;
import yguard.A.I.BA;
import yguard.A.I.D;
import yguard.A.I.OA;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.dA;
import yguard.A.I.fB;
import yguard.A.I.o;
import yguard.A.I.q;
import yguard.A.I.rA;
import yguard.A.I.uB;
import yguard.A.I.yB;

public class ConnectivityPanel
extends JPanel {
    private S _graphView;
    private Map<TabularGraphEntity, Y> _entityMap;
    private Map<TabularGraphLink, H> _linkMap;
    private JPanel _graphViewPanel;
    private JButton _layoutButton;
    private JButton _zoomButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextArea jTextArea1;

    public ConnectivityPanel() {
        this.initComponents();
        this._graphView = new S();
        this.registerViewActions();
        this._graphView.J(true);
        this._graphView.putClientProperty((Object)"selectionbox.linecolor", (Object)new Color(35, 106, 109));
        this._graphView.putClientProperty((Object)"selectionbox.fillcolor", (Object)new Color(217, 242, 241, 70));
        this._graphView.D((fB)this.createEditMode());
        this._graphViewPanel.add((Component)this._graphView);
        this._layoutButton.setToolTipText("Layout Graph");
        this._zoomButton.setToolTipText("Zoom to Fit");
    }

    private void registerViewActions() {
        yB yB2 = new yB(this._graphView);
        ActionMap actionMap = this._graphView.\u00cb().getActionMap();
        if (actionMap != null) {
            actionMap.put("DELETE_SELECTION", (Action)SystemAction.get(DeleteLinksAction.class));
            InputMap inputMap = yB2.A(actionMap);
            this._graphView.\u00cb().setInputMap(0, inputMap);
        }
        this._graphView.\u00cb().addMouseWheelListener((MouseWheelListener)MouseWheelZoomListener.getInstance());
    }

    private rA createEditMode() {
        rA rA2 = new rA();
        rA2.allowBendCreation(false);
        rA2.allowEdgeCreation(true);
        rA2.allowLabelSelection(false);
        rA2.allowMoveLabels(false);
        rA2.allowMovePorts(false);
        rA2.allowNodeCreation(false);
        rA2.allowNodeEditing(false);
        rA2.allowResizeNodes(false);
        rA2.setSelectionBoxMode((fB)new SelectionBoxViewMode());
        fB fB2 = rA2.getCreateEdgeMode();
        if (fB2 instanceof uB) {
            ((uB)fB2).allowSelfloopCreation(false);
        }
        return rA2;
    }

    public void setTabularGraph(TabularGraph tabularGraph) {
        final QA qA = new QA();
        this._graphView.A(qA);
        this.addEntities(tabularGraph);
        this.addLinks(tabularGraph);
        qA.A(new _(){

            public void onGraphEvent(C c) {
                if (c.C() == 1) {
                    H h = (H)c.A();
                    qA.A(h, ConnectivityPanel.this.getNextName(qA));
                }
            }
        });
        this.layoutGraph(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectivityPanel.this.zoomToFit();
            }
        });
    }

    private String getNextName(QA qA) {
        String string = null;
        int n = 0;
        do {
            String string2;
            if (this.getEdge(qA, string2 = Integer.toString(++n)) != null) continue;
            string = string2;
        } while (string == null);
        return string;
    }

    private H getEdge(QA qA, String string) {
        Z z = qA.\u00c9();
        while (z.ok()) {
            H h = z.edge();
            if (string.equals(qA.Y(h))) {
                return h;
            }
            z.next();
        }
        return null;
    }

    private void addEntities(TabularGraph tabularGraph) {
        QA qA = this._graphView.H();
        List<TabularGraphEntity> list = tabularGraph.getEntities();
        this._entityMap = new HashMap<TabularGraphEntity, Y>();
        qA.B((.A)ConnectivityNodeRealizer.create());
        int n = 0;
        for (TabularGraphEntity tabularGraphEntity : list) {
            Y y = qA.\u00cb();
            ConnectivityNodeRealizer connectivityNodeRealizer = (ConnectivityNodeRealizer)qA.f(y);
            connectivityNodeRealizer.setUserData(tabularGraphEntity);
            connectivityNodeRealizer.setEntityIndex(++n);
            qA.A(y, this.getEntityName(tabularGraph, tabularGraphEntity));
            this._entityMap.put(tabularGraphEntity, y);
        }
    }

    private void addLinks(TabularGraph tabularGraph) {
        QA qA = this._graphView.H();
        List<TabularGraphLink> list = tabularGraph.getLinks();
        this._linkMap = new HashMap<TabularGraphLink, H>();
        qA.A((o)this.createEdgeRealizer());
        for (TabularGraphLink tabularGraphLink : list) {
            Y y = this._entityMap.get(tabularGraphLink.getSource());
            Y y2 = this._entityMap.get(tabularGraphLink.getTarget());
            H h = qA.A(y, y2);
            qA.A(h, Integer.toString(tabularGraphLink.getIndex()));
            this._linkMap.put(tabularGraphLink, h);
        }
    }

    private q createEdgeRealizer() {
        NakedEdgeRealizer nakedEdgeRealizer = new NakedEdgeRealizer();
        nakedEdgeRealizer.setSourceArrow(D.X);
        nakedEdgeRealizer.setSmoothedBends(true);
        nakedEdgeRealizer.setTargetArrow(D.f);
        nakedEdgeRealizer.setLineColor(MaltegoLinkSpec.getDefaultManualLinkColor());
        nakedEdgeRealizer.getLabel().setTextColor(MaltegoLinkSpec.getDefaultManualLinkColor());
        q.setSelectionColor((Color)NodeRealizerSettings.getDefault().getLinkSelectionColor());
        q.setSelectionStroke((dA)dA.D);
        return nakedEdgeRealizer;
    }

    private String getEntityName(TabularGraph tabularGraph, TabularGraphEntity tabularGraphEntity) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = tabularGraph.getColumnNames();
        int[] nArray = tabularGraphEntity.getColumns();
        for (int n : nArray) {
            if (n != nArray[0]) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[n]);
        }
        Object object = stringBuilder.toString();
        int n = 20;
        if (((String)object).length() > n) {
            object = ((String)object).substring(0, n) + "...";
        }
        return object;
    }

    public List<TabularGraphLink> getLinksRemoved() {
        ArrayList<TabularGraphLink> arrayList = new ArrayList<TabularGraphLink>();
        A a = this._graphView.H().\u00e8();
        Iterator<Map.Entry<TabularGraphLink, H>> iterator = this._linkMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TabularGraphLink, H> entry = iterator.next();
            H h = entry.getValue();
            if (a.contains((Object)h)) continue;
            TabularGraphLink tabularGraphLink = entry.getKey();
            arrayList.add(tabularGraphLink);
            iterator.remove();
        }
        return arrayList;
    }

    public List<TabularGraphLink> getLinksAdded() {
        ArrayList<TabularGraphLink> arrayList = new ArrayList<TabularGraphLink>();
        QA qA = this._graphView.H();
        Z z = qA.\u00c9();
        while (z.ok()) {
            H h = z.edge();
            if (this.getLink(h) == null) {
                TabularGraphEntity tabularGraphEntity = this.getEntity(h.X());
                TabularGraphEntity tabularGraphEntity2 = this.getEntity(h.V());
                DefaultTabularGraphLink defaultTabularGraphLink = new DefaultTabularGraphLink(tabularGraphEntity, tabularGraphEntity2);
                defaultTabularGraphLink.setIndex(Integer.parseInt(qA.Y(h)));
                arrayList.add(defaultTabularGraphLink);
                this._linkMap.put(defaultTabularGraphLink, h);
            }
            z.next();
        }
        return arrayList;
    }

    private TabularGraphLink getLink(H h) {
        for (Map.Entry<TabularGraphLink, H> entry : this._linkMap.entrySet()) {
            if (!h.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private TabularGraphEntity getEntity(Y y) {
        for (Map.Entry<TabularGraphEntity, Y> entry : this._entityMap.entrySet()) {
            if (!y.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private l getLayouter() {
        yguard.A.G.G.C c = new yguard.A.G.G.C();
        c.D((byte)1);
        yguard.A.G.S s = new yguard.A.G.S();
        s.setCoreLayouter((l)c);
        s.\u0122(true);
        s.\u00d1(600.0);
        return s;
    }

    private void layoutGraph(boolean bl) {
        if (bl) {
            OA oA = new OA();
            oA.setSmoothViewTransform(false);
            oA.setKeepZoomFactor(true);
            BA bA = new BA(3);
            bA.setLayoutMorpher(oA);
            bA.doLayout(this._graphView, this.getLayouter());
        } else {
            new JA(this.getLayouter()).doLayout((NA)this._graphView.H());
        }
    }

    private void zoomToFit() {
        this._graphView.\u00de();
        this._graphView.I();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._layoutButton = new JButton();
        this._zoomButton = new JButton();
        this._graphViewPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this._layoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/io/resources/LayoutHierarchical.png")));
        this._layoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._layoutButton.text"));
        this._layoutButton.setPreferredSize(new Dimension(30, 25));
        this._layoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectivityPanel.this._layoutButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this._layoutButton);
        this._zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/io/resources/Zoom.png")));
        this._zoomButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._zoomButton.text"));
        this._zoomButton.setPreferredSize(new Dimension(30, 25));
        this._zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectivityPanel.this._zoomButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this._zoomButton);
        this.add((Component)this.jPanel1, "North");
        this._graphViewPanel.setBorder(BorderFactory.createBevelBorder(1));
        this._graphViewPanel.setPreferredSize(new Dimension(500, 200));
        this._graphViewPanel.setLayout(new BorderLayout());
        this.add((Component)this._graphViewPanel, "Center");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jPanel2.border.title")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jTextArea1.setBackground(SystemColor.control);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(2);
        this.jTextArea1.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jPanel2.add((Component)this.jTextArea1, "Center");
        this.add((Component)this.jPanel2, "South");
    }

    private void _layoutButtonActionPerformed(ActionEvent actionEvent) {
        this.layoutGraph(true);
        this.zoomToFit();
    }

    private void _zoomButtonActionPerformed(ActionEvent actionEvent) {
        this.zoomToFit();
    }

    private static class NakedEdgeRealizer
    extends q {
        public NakedEdgeRealizer() {
        }

        private NakedEdgeRealizer(o o2) {
            super(o2);
        }

        public o createCopy(o o2) {
            return new NakedEdgeRealizer(o2);
        }

        protected void paintBends(Graphics2D graphics2D) {
        }

        protected void paintHighlightedBends(Graphics2D graphics2D) {
        }

        protected void paintPorts(Graphics2D graphics2D) {
        }
    }
}

