/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class TabularGraphImportOptions {
    private static final String SAMPLING_ENABLED = "samplingEnabled";
    private static final String SAMPLING_RATE = "samplingRate";
    private static final String ENTITY_LIMIT_ENABLED = "entityLimitEnabled";
    private static final String ENTITY_LIMIT = "entityLimit";
    private static final String MERGE_LINKS = "mergeLinks";

    public static void setSamplingEnabled(boolean bl) {
        TabularGraphImportOptions.getPreferences().putBoolean(SAMPLING_ENABLED, bl);
    }

    public static boolean isSamplingEnabled() {
        return TabularGraphImportOptions.getPreferences().getBoolean(SAMPLING_ENABLED, false);
    }

    public static void setSamplingRate(int n) {
        TabularGraphImportOptions.getPreferences().putInt(SAMPLING_RATE, n);
    }

    public static int getSamplingRate() {
        return TabularGraphImportOptions.getPreferences().getInt(SAMPLING_RATE, 10);
    }

    public static void setEntityLimitEnabled(boolean bl) {
        TabularGraphImportOptions.getPreferences().putBoolean(ENTITY_LIMIT_ENABLED, bl);
    }

    public static boolean isEntityLimitEnabled() {
        return TabularGraphImportOptions.getPreferences().getBoolean(ENTITY_LIMIT_ENABLED, true);
    }

    public static void setEntityLimit(int n) {
        TabularGraphImportOptions.getPreferences().putInt(ENTITY_LIMIT, n);
    }

    public static int getEntityLimit() {
        return TabularGraphImportOptions.getPreferences().getInt(ENTITY_LIMIT, 10000);
    }

    public static void setMergeLinks(boolean bl) {
        TabularGraphImportOptions.getPreferences().putBoolean(MERGE_LINKS, bl);
    }

    public static boolean isMergeLinks() {
        return TabularGraphImportOptions.getPreferences().getBoolean(MERGE_LINKS, true);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(TabularGraphImportOptions.class);
    }
}

