/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.api.PropertyToColumnMap;
import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.api.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.api.TabularGraphLink;
import com.paterva.maltego.graph.table.io.convert.TabularGraphConvertResult;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportOptions;
import com.paterva.maltego.graph.table.io.convert.TabularTranslator;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.merging.GraphMatchStrategy;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.awt.Color;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import yguard.A.A.D;
import yguard.A.I.QA;
import yguard.A.I.o;
import yguard.A.I.p;

public class TabularGraphConverter {
    private TabularGraph _tabularGraph;
    private MatchingRule _entityRule;
    private MatchingRule _linkRule;
    private ProgressHandle _handle;
    private String _sourceInfo;

    public TabularGraphConverter(TabularGraph tabularGraph) {
        if (tabularGraph == null) {
            throw new IllegalArgumentException("Graph may not be null");
        }
        this._tabularGraph = tabularGraph;
    }

    public void setEntityRule(MatchingRule matchingRule) {
        this._entityRule = matchingRule;
    }

    public void setLinkRule(MatchingRule matchingRule) {
        this._linkRule = matchingRule;
    }

    public void setHandle(ProgressHandle progressHandle) {
        this._handle = progressHandle;
    }

    public TabularGraphConvertResult convert() throws TypeInstantiationException, IOException {
        QA qA = TabularGraphConverter.createGraph2D();
        TabularGraphConvertResult tabularGraphConvertResult = new TabularGraphConvertResult();
        tabularGraphConvertResult.Graph = qA;
        this.buildGraph(tabularGraphConvertResult);
        return tabularGraphConvertResult;
    }

    private void buildGraph(TabularGraphConvertResult tabularGraphConvertResult) throws IOException {
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)tabularGraphConvertResult.Graph);
        List<TabularGraphEntity> list = this._tabularGraph.getEntities();
        List<TabularGraphLink> list2 = this._tabularGraph.getLinks();
        Map<Integer, TypeDescriptor> map = TabularGraphConverter.getDesiredColumnTypes(list);
        Map<Integer, TypeDescriptor> map2 = TabularGraphConverter.getDesiredColumnTypes(list2);
        GraphMatchStrategy.Simple simple = new GraphMatchStrategy.Simple(this._entityRule, this._linkRule);
        GraphMergeStrategy.PreferNew preferNew = new GraphMergeStrategy.PreferNew();
        GraphMerger.Strategic strategic = new GraphMerger.Strategic((GraphMatchStrategy)simple, (GraphMergeStrategy)preferNew, null);
        tabularGraphConvertResult.Errors = new ArrayList<String>();
        tabularGraphConvertResult.RowsFailed = 0;
        TabularGraphIterator tabularGraphIterator = this._tabularGraph.getDataProvider().open();
        int n = this._tabularGraph.hasHeaderRow() ? -1 : 0;
        int n2 = 0;
        int n3 = 0;
        while (tabularGraphIterator.hasNext()) {
            if (!this.ignoreRow(n)) {
                Map<TabularGraphEntity, MaltegoEntity> map3 = null;
                Map<TabularGraphLink, MaltegoLink> map4 = null;
                String string = null;
                ArrayList<Object> arrayList = tabularGraphIterator.getRow(map);
                try {
                    map3 = TabularTranslator.translateEntities(list, arrayList);
                }
                catch (Exception exception) {
                    string = exception.getMessage() + ": " + arrayList;
                }
                if (string == null) {
                    ArrayList<Object> arrayList2 = tabularGraphIterator.getRow(map2);
                    try {
                        map4 = TabularTranslator.translateLinks(list2, arrayList2);
                    }
                    catch (Exception exception) {
                        string = exception.getMessage() + ": " + arrayList2;
                    }
                }
                if (string == null) {
                    int n4 = graphWrapper.entityCount() + map3.size();
                    if (this.isEntityLimitReached(n4)) {
                        int n5 = TabularGraphImportOptions.getEntityLimit() - graphWrapper.entityCount();
                        HashMap<TabularGraphEntity, MaltegoEntity> hashMap = new HashMap<TabularGraphEntity, MaltegoEntity>();
                        int n6 = 0;
                        for (Map.Entry<TabularGraphEntity, MaltegoEntity> entry : map3.entrySet()) {
                            if (n6 >= n5) break;
                            hashMap.put(entry.getKey(), entry.getValue());
                            ++n6;
                        }
                        map3 = hashMap;
                    }
                    if (map3.size() > 0) {
                        MaltegoGraph maltegoGraph = this.createGraph(map3, map4);
                        strategic.setGraphs(graphWrapper, maltegoGraph, null);
                        strategic.append();
                        ++n2;
                        n3 += map3.size();
                    }
                } else {
                    tabularGraphConvertResult.Errors.add(string);
                    ++tabularGraphConvertResult.RowsFailed;
                }
                if (this._handle != null) {
                    this._handle.progress(n2 + " rows imported (" + n3 + " entities created)");
                }
            }
            if (this.isEntityLimitReached(graphWrapper.entityCount())) {
                tabularGraphConvertResult.Errors.add("Warning: Entity limit of " + TabularGraphImportOptions.getEntityLimit() + " reached");
                break;
            }
            if (Thread.interrupted()) break;
            ++n;
            tabularGraphIterator.next();
        }
        this._tabularGraph.getDataProvider().close();
        tabularGraphConvertResult.RowsSucceeded = n2;
    }

    private boolean ignoreRow(int n) {
        return n < 0 || TabularGraphImportOptions.isSamplingEnabled() && n % TabularGraphImportOptions.getSamplingRate() != 0;
    }

    private boolean isEntityLimitReached(int n) {
        return TabularGraphImportOptions.isEntityLimitEnabled() && n >= TabularGraphImportOptions.getEntityLimit();
    }

    private static Map<Integer, TypeDescriptor> getDesiredColumnTypes(List<? extends PropertyToColumnMap> list) {
        HashMap<Integer, TypeDescriptor> hashMap = new HashMap<Integer, TypeDescriptor>();
        for (PropertyToColumnMap propertyToColumnMap : list) {
            for (int n : propertyToColumnMap.getColumns()) {
                PropertyDescriptor propertyDescriptor = propertyToColumnMap.getProperty(n);
                TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(propertyDescriptor.getType());
                hashMap.put(n, typeDescriptor);
            }
        }
        return hashMap;
    }

    private MaltegoGraph createGraph(Map<TabularGraphEntity, MaltegoEntity> map, Map<TabularGraphLink, MaltegoLink> map2) {
        MaltegoGraph maltegoGraph = MaltegoGraphManager.createGraph();
        this.addToGraph(maltegoGraph, map, map2);
        return maltegoGraph;
    }

    private void addToGraph(MaltegoGraph maltegoGraph, Map<TabularGraphEntity, MaltegoEntity> map, Map<TabularGraphLink, MaltegoLink> map2) {
        for (Map.Entry<TabularGraphEntity, MaltegoEntity> entry : map.entrySet()) {
            maltegoGraph.add(entry.getValue());
        }
        for (Map.Entry<PropertyToColumnMap, Object> entry : map2.entrySet()) {
            TabularGraphLink tabularGraphLink = (TabularGraphLink)entry.getKey();
            MaltegoEntity maltegoEntity = map.get(tabularGraphLink.getSource());
            MaltegoEntity maltegoEntity2 = map.get(tabularGraphLink.getTarget());
            if (maltegoEntity == null || maltegoEntity2 == null) continue;
            MaltegoLink maltegoLink = (MaltegoLink)entry.getValue();
            DisplayInformationCollection displayInformationCollection = maltegoLink.getDisplayInformation();
            displayInformationCollection.add("Source", this.getSourceInfo());
            maltegoLink.setDisplayInformation(displayInformationCollection);
            maltegoGraph.connect(maltegoEntity, maltegoEntity2, maltegoLink);
        }
    }

    private String getSourceInfo() {
        if (this._sourceInfo == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<table border=\"1\" cellspacing = \"1\">");
            stringBuilder.append("<tr><td><b>Tabular source</b></td><td>");
            stringBuilder.append(this._tabularGraph.getDataProvider().getSourceName());
            stringBuilder.append("</td></tr><tr><td><b>Imported</b></td><td>");
            stringBuilder.append(new SimpleDateFormat("d MMM yyyy H:mm:ss").format(new Date()));
            stringBuilder.append("</td></tr>");
            stringBuilder.append("</table>");
            this._sourceInfo = stringBuilder.toString();
        }
        return this._sourceInfo;
    }

    private static QA createGraph2D() {
        QA qA = new QA();
        p p2 = new p();
        p2.setLineColor(Color.lightGray);
        p2.setArrow(yguard.A.I.D.f);
        qA.A((o)p2);
        EntityRegistry.associate((D)qA, (EntityRegistry)EntityRegistry.getDefault());
        return qA;
    }
}

