/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor.adapter;

import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.transform.api.TransformMessage;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TransformResult {
    private List<TransformMessage> _messages;
    private int _lastProgress = -1;
    private String _lastProgressMessage;
    private MaltegoGraph _graph;
    private boolean _transformComplete = false;
    private static TransformResult EMPTY = new TransformResult();

    public List<TransformMessage> getMessages() {
        return this._messages;
    }

    public int getLastProgress() {
        return this._lastProgress;
    }

    public MaltegoGraph getGraph() {
        return this._graph;
    }

    public boolean transformComplete() {
        return this._transformComplete;
    }

    public static TransformResult message(TransformMessage transformMessage) {
        TransformResult transformResult = new TransformResult();
        transformResult._messages = Collections.singletonList(transformMessage);
        return transformResult;
    }

    public static TransformResult messages(List<TransformMessage> list) {
        TransformResult transformResult = new TransformResult();
        transformResult._messages = list;
        return transformResult;
    }

    public static TransformResult info(String string) {
        return TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Info, string));
    }

    public static TransformResult info(String string, int n) {
        TransformResult transformResult = new TransformResult();
        transformResult._messages = Collections.singletonList(new TransformMessage(new Date(), TransformMessage.Severity.Info, string));
        transformResult._lastProgress = n;
        transformResult._lastProgressMessage = string;
        return transformResult;
    }

    public static TransformResult error(Exception exception) {
        return TransformResult.error(exception.getMessage());
    }

    public static TransformResult error(Exception exception, int n) {
        return TransformResult.error(exception.getMessage(), n);
    }

    public static TransformResult error(String string) {
        TransformResult transformResult = TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Error, string));
        transformResult._transformComplete = true;
        return transformResult;
    }

    public static TransformResult error(String string, int n) {
        TransformResult transformResult = TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Error, string, n));
        transformResult._transformComplete = true;
        return transformResult;
    }

    public static TransformResult progress(String string, int n, MaltegoGraph maltegoGraph, boolean bl) {
        TransformResult transformResult = new TransformResult();
        transformResult._graph = maltegoGraph;
        transformResult._lastProgress = n;
        transformResult._lastProgressMessage = string;
        transformResult._transformComplete = bl;
        return transformResult;
    }

    public static TransformResult empty() {
        return EMPTY;
    }

    public String getLastProgressMessage() {
        return this._lastProgressMessage;
    }

    public String toString() {
        return this._lastProgress + " " + this._lastProgressMessage;
    }

    static {
        TransformResult.EMPTY._transformComplete = true;
    }
}

