/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class TransformSet {
    public static final String PROP_TRANSFORMS = "transforms";
    private String _name;
    private String _description;
    private Set<String> _transforms;
    private PropertyChangeSupport _listeners;
    private boolean _dirty = true;

    public TransformSet(String string) {
        this._name = string;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markClean() {
        this._dirty = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._listeners == null) {
            this._listeners = new PropertyChangeSupport(this);
        }
        this._listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._listeners != null) {
            this._listeners.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._listeners != null) {
            this._listeners.firePropertyChange(string, object, object2);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean addTransform(String string) {
        if (this.transforms().add(string)) {
            this._dirty = true;
            this.firePropertyChange(PROP_TRANSFORMS, null, null);
            return true;
        }
        return false;
    }

    public boolean removeTransform(String string) {
        if (this.transforms().remove(string)) {
            this._dirty = true;
            this.firePropertyChange(PROP_TRANSFORMS, null, null);
            return true;
        }
        return false;
    }

    private Set<String> transforms() {
        if (this._transforms == null) {
            this._transforms = new TreeSet<String>();
        }
        return this._transforms;
    }

    public boolean contains(String string) {
        if (this._transforms == null) {
            return false;
        }
        return this._transforms.contains(string);
    }

    public Set<String> getAllTransforms() {
        return Collections.unmodifiableSet(this.transforms());
    }

    public boolean isAutoGenerated() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setDescription(String string) {
        if (this._description == null || !this._description.equals(string)) {
            this._description = string;
            this._dirty = true;
        }
    }

    public Set<TransformDefinition> getIntersection(Collection<TransformDefinition> collection) {
        if (collection.isEmpty() || this._transforms == null || this._transforms.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> set = this.transforms();
        TreeSet<TransformDefinition> treeSet = new TreeSet<TransformDefinition>();
        for (TransformDefinition transformDefinition : collection) {
            if (!set.contains(transformDefinition.getName())) continue;
            treeSet.add(transformDefinition);
        }
        return treeSet;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof TransformSet) {
            return this.equals((TransformSet)object);
        }
        return false;
    }

    public boolean equals(TransformSet transformSet) {
        if (transformSet == null) {
            return false;
        }
        return transformSet.getName().equals(this.getName());
    }

    public int hashCode() {
        int n = 7;
        n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
        return n;
    }
}

