/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.util.FastURL;
import java.io.IOException;
import org.openide.util.Lookup;

public abstract class TransformSeedRepository {
    public abstract void add(TransformSeed var1);

    public abstract void update(Iterable<TransformSeed> var1);

    public abstract void remove(FastURL var1);

    public abstract TransformSeed[] getAll();

    public abstract TransformSeed[] getEnabled();

    public abstract TransformSeed get(FastURL var1);

    public abstract void set(TransformSeed[] var1) throws IOException;

    public static TransformSeedRepository getDefault() {
        TransformSeedRepository transformSeedRepository = (TransformSeedRepository)Lookup.getDefault().lookup(TransformSeedRepository.class);
        if (transformSeedRepository == null) {
            transformSeedRepository = new DefaultTransformSeedRepository();
        }
        return transformSeedRepository;
    }

    private static class DefaultTransformSeedRepository
    extends TransformSeedRepository {
        private DefaultTransformSeedRepository() {
        }

        @Override
        public void add(TransformSeed transformSeed) {
            throw new UnsupportedOperationException("No seed repository registered.");
        }

        @Override
        public void update(Iterable<TransformSeed> iterable) {
            throw new UnsupportedOperationException("No seed repository registered.");
        }

        @Override
        public void remove(FastURL fastURL) {
            throw new UnsupportedOperationException("No seed repository registered.");
        }

        @Override
        public TransformSeed[] getAll() {
            throw new UnsupportedOperationException("No seed repository registered.");
        }

        @Override
        public TransformSeed get(FastURL fastURL) {
            throw new UnsupportedOperationException("No seed repository registered.");
        }

        @Override
        public void set(TransformSeed[] transformSeedArray) throws IOException {
            throw new UnsupportedOperationException("No seed repository registered.");
        }

        @Override
        public TransformSeed[] getEnabled() {
            throw new UnsupportedOperationException("No seed repository registered.");
        }
    }
}

