/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.descriptor.PropertyConstraint;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class EntityConstraint
implements Constraint {
    private String _typeName;
    private int _minimum = 0;
    private int _maximum = 0;
    private Collection<PropertyConstraint> _properties;

    public EntityConstraint() {
    }

    public EntityConstraint(String string) {
        this(string, 1, 1);
    }

    public EntityConstraint(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public EntityConstraint(String string, int n, int n2, Collection<PropertyConstraint> collection) {
        this._typeName = string;
        this._minimum = n;
        this._maximum = n2;
        this._properties = collection;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public void setTypeName(String string) {
        this._typeName = string;
    }

    public int getMinimum() {
        return this._minimum;
    }

    public void setMinimum(int n) {
        this._minimum = n;
    }

    public int getMaximum() {
        return this._maximum;
    }

    public void setMaximum(int n) {
        this._maximum = n;
    }

    public Collection<PropertyConstraint> getProperties() {
        if (this._properties == null) {
            this._properties = new LinkedList<PropertyConstraint>();
        }
        return this._properties;
    }

    public void setProperties(Collection<PropertyConstraint> collection) {
        this._properties = collection;
    }

    @Override
    public boolean isSatisfiedByAny(Iterable<? extends TypedPropertyBag> iterable, InheritedTypesProvider inheritedTypesProvider) {
        int n = this._minimum < 1 ? 1 : this._minimum;
        int n2 = 0;
        for (TypedPropertyBag typedPropertyBag : iterable) {
            if (n2 >= n) {
                return true;
            }
            if (!this.isSatisfiedByType(typedPropertyBag, inheritedTypesProvider) || !this.isSatisfiedByProperties(typedPropertyBag)) continue;
            ++n2;
        }
        return n2 >= n;
    }

    private boolean isSatisfiedByType(TypedPropertyBag typedPropertyBag, InheritedTypesProvider inheritedTypesProvider) {
        if (this._typeName == null) {
            return true;
        }
        if (inheritedTypesProvider != null) {
            List<String> list = inheritedTypesProvider.getAllInheritedTypes(typedPropertyBag.getTypeName());
            return list.contains(this._typeName);
        }
        return this._typeName.equals(typedPropertyBag.getTypeName());
    }

    private boolean isSatisfiedByProperties(TypedPropertyBag typedPropertyBag) {
        if (this._properties == null) {
            return true;
        }
        for (PropertyConstraint propertyConstraint : this._properties) {
            boolean bl = propertyConstraint.isSatisfiedBy(typedPropertyBag);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDisplay() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._typeName != null) {
            stringBuilder.append(this._typeName);
        }
        if (this._typeName == null && (this._properties == null || this._properties.isEmpty())) {
            stringBuilder.append("Any");
        }
        if (this._minimum == this._maximum) {
            if (this._minimum != 1) {
                stringBuilder.append("(" + this._minimum + ")");
            }
        } else {
            stringBuilder.append("(" + this._minimum + ":" + this._maximum + ")");
        }
        if (this._properties != null && !this._properties.isEmpty()) {
            stringBuilder.append("[");
            int n = 0;
            for (PropertyConstraint propertyConstraint : this._properties) {
                stringBuilder.append(propertyConstraint.getDisplay());
                if (n < this._properties.size() - 1) {
                    stringBuilder.append(" ");
                }
                ++n;
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getDisplay();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EntityConstraint entityConstraint = (EntityConstraint)object;
        if (this._typeName == null ? entityConstraint._typeName != null : !this._typeName.equals(entityConstraint._typeName)) {
            return false;
        }
        if (this._minimum != entityConstraint._minimum) {
            return false;
        }
        if (this._maximum != entityConstraint._maximum) {
            return false;
        }
        return ((Object)this.getProperties()).equals(entityConstraint.getProperties());
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (this._typeName != null ? this._typeName.hashCode() : 0);
        n = 97 * n + this._minimum;
        n = 97 * n + this._maximum;
        n = 97 * n + ((Object)this.getProperties()).hashCode();
        return n;
    }
}

