/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.http;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.http.AuthenticationPopup;
import com.paterva.maltego.util.ui.http.SimpleX509TrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.prefs.Preferences;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class HttpAgent {
    private URL _url;
    private HttpURLConnection _cn;
    private int _readTimeout = -1;
    private int _connectTimeout = -1;
    private String _userAgent;
    private String _mimeType;
    private String _characterSet;
    private int _contentLength;
    private boolean _responseParsed = false;
    private boolean _trustAllCerts = true;
    private String _requireCNSuffix = null;
    private String _contentEncoding;
    private String _acceptEncoding;

    public HttpAgent(URL uRL) {
        this._url = uRL;
        this._userAgent = this.getDefaultUserAgent();
        HttpURLConnection.setFollowRedirects(true);
    }

    public boolean trustAllCerts() {
        return this._trustAllCerts;
    }

    public void setTrustAllCerts(boolean bl) {
        this._trustAllCerts = bl;
    }

    public void doGet() throws IOException {
        this.connect(false);
        this.parseResponse();
    }

    public OutputStream doPost(String string) throws IOException {
        this.connect(true);
        this._cn.setRequestProperty("Content-Type", string);
        return this._cn.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostString(String string, String string2) throws IOException {
        OutputStream outputStream = this.doPost(string);
        try {
            outputStream.write(string2.getBytes("UTF-8"));
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return StringUtilities.toString((InputStream)this.getInputStream());
    }

    public String getContentAsString() throws IOException {
        this.parseResponse();
        return StringUtilities.toString((InputStream)this.getInputStream());
    }

    private void connect(boolean bl) throws IOException {
        this._responseParsed = false;
        URLConnection uRLConnection = this._url.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("URL protocol must be HTTP or HTTPS.");
        }
        if (uRLConnection instanceof HttpsURLConnection) {
            try {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                SimpleX509TrustManager simpleX509TrustManager = new SimpleX509TrustManager(this._trustAllCerts);
                simpleX509TrustManager.setRequireInCN(this._requireCNSuffix);
                sSLContext.init(null, new TrustManager[]{simpleX509TrustManager}, null);
                httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
                httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        if (HttpAgent.this._trustAllCerts) {
                            return true;
                        }
                        return string.equalsIgnoreCase(sSLSession.getPeerHost());
                    }
                });
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Exceptions.printStackTrace((Throwable)noSuchProviderException);
            }
            catch (KeyStoreException keyStoreException) {
                Exceptions.printStackTrace((Throwable)keyStoreException);
            }
            catch (KeyManagementException keyManagementException) {
                Exceptions.printStackTrace((Throwable)keyManagementException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Exceptions.printStackTrace((Throwable)noSuchAlgorithmException);
            }
        }
        this._cn = (HttpURLConnection)uRLConnection;
        if (this.getConnectTimeout() > -1) {
            this._cn.setConnectTimeout(this.getConnectTimeout());
        }
        if (this.getReadTimeout() > -1) {
            this._cn.setReadTimeout(this.getReadTimeout());
        }
        this._cn.setRequestProperty("User-Agent", ": " + this.getUserAgent());
        if (this._acceptEncoding != null) {
            this._cn.setRequestProperty("accept-encoding", this._acceptEncoding);
        }
        this._cn.setDoOutput(bl);
        this._cn.setUseCaches(false);
        this._cn.setDoInput(true);
        if (bl) {
            this._cn.setRequestMethod("POST");
        } else {
            this._cn.setRequestMethod("GET");
        }
    }

    public InputStream getInputStream() throws IOException {
        this.parseResponse();
        return this._cn.getInputStream();
    }

    public void disconnect() {
        if (this._cn != null) {
            this._cn.disconnect();
        }
    }

    private void tryParseResponse() {
        if (!this._responseParsed) {
            try {
                this.parseResponse();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parseResponse() throws IOException {
        int n = this._cn.getResponseCode();
        if (n != 200) {
            throw new IOException("Unexpected HTTP response: " + n);
        }
        this._contentLength = this._cn.getContentLength();
        this._contentEncoding = this._cn.getContentEncoding();
        String string = this._cn.getContentType();
        String string2 = null;
        if (string != null) {
            String[] stringArray = string.split(";");
            this._mimeType = stringArray[0].trim();
            for (int i = 1; i < stringArray.length && string2 == null; ++i) {
                String string3 = stringArray[i].trim();
                int n2 = string3.toLowerCase().indexOf("charset=");
                if (n2 == -1) continue;
                string2 = string3.substring(n2 + 8);
            }
        }
        this._characterSet = string2;
    }

    private Object readStream(int n, InputStream inputStream, String string) throws IOException {
        int n2 = Math.max(1024, Math.max(n, inputStream.available()));
        byte[] byArray = new byte[n2];
        byte[] byArray2 = null;
        int n3 = inputStream.read(byArray);
        while (n3 != -1) {
            if (byArray2 == null) {
                byArray2 = byArray;
                byArray = new byte[n2];
            } else {
                byte[] byArray3 = new byte[byArray2.length + n3];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, 0, byArray3, byArray2.length, n3);
                byArray2 = byArray3;
            }
            n3 = inputStream.read(byArray);
        }
        if (string == null) {
            return byArray2;
        }
        try {
            return new String(byArray2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byArray2;
        }
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(int n) {
        this._readTimeout = n;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int n) {
        this._connectTimeout = n;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String string) {
        this._userAgent = string;
    }

    public String getMimeType() {
        this.tryParseResponse();
        return this._mimeType;
    }

    public String getCharacterSet() {
        this.tryParseResponse();
        return this._characterSet;
    }

    public int getContentLength() {
        this.tryParseResponse();
        return this._contentLength;
    }

    public String getContentEncoding() {
        this.tryParseResponse();
        return this._contentEncoding;
    }

    private String getDefaultUserAgent() {
        return String.format("%s v%s.%s ; %s %s", System.getProperty("maltego.product-name"), System.getProperty("maltego.version"), System.getProperty("maltego.buildnumber"), System.getProperty("os.name"), System.getProperty("os.version"));
    }

    public void setRequireCNSuffix(String string) {
        this._requireCNSuffix = string;
    }

    public String getRequireCNSuffix() {
        return this._requireCNSuffix;
    }

    public void setAcceptEncoding(String string) {
        this._acceptEncoding = string;
    }

    static {
        Authenticator.setDefault(new PopupAuthenticator());
    }

    private static class PopupAuthenticator
    extends Authenticator {
        private static final String USERNAME_KEY = "LastUsedAuthenticatorUsername";

        private PopupAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            Preferences preferences = NbPreferences.forModule(PopupAuthenticator.class);
            AuthenticationPopup authenticationPopup = new AuthenticationPopup();
            authenticationPopup.setUsername(preferences.get(USERNAME_KEY, ""));
            authenticationPopup.setAuthenticationType(this.getRequestingScheme() == null ? "" : this.getRequestingScheme().toUpperCase());
            authenticationPopup.setHost(this.getRequestingHost());
            authenticationPopup.setPort(String.valueOf(this.getRequestingPort()));
            authenticationPopup.setUrl(this.getRequestingURL() == null ? "null" : this.getRequestingURL().toString());
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                authenticationPopup.setServerType("Proxy");
            } else {
                authenticationPopup.setServerType("Server");
            }
            PasswordAuthentication passwordAuthentication = null;
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)authenticationPopup, "Authentication required");
            JButton jButton = new JButton("Ok");
            JButton jButton2 = new JButton("Cancel");
            Object[] objectArray = new Object[]{jButton, jButton2};
            dialogDescriptor.setOptions(objectArray);
            dialogDescriptor.setOptionsAlign(0);
            dialogDescriptor.setClosingOptions(objectArray);
            dialogDescriptor.setModal(true);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == jButton) {
                String string = authenticationPopup.getUsername();
                char[] cArray = authenticationPopup.getPassword();
                passwordAuthentication = new PasswordAuthentication(string, cArray);
                preferences.put(USERNAME_KEY, string);
            }
            return passwordAuthentication;
        }
    }
}

