/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardSegment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.MissingResourceException;
import javax.swing.JComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class WizardUtilities {
    private WizardUtilities() {
    }

    public static WizardDescriptor createWizard(WizardSegment wizardSegment) {
        WizardDescriptor.Panel[] panelArray = wizardSegment.createPanels();
        WizardUtilities.updatePanels(panelArray);
        WizardDescriptor wizardDescriptor = new WizardDescriptor(wizardSegment.createIterator(panelArray));
        wizardSegment.initialize(wizardDescriptor, panelArray);
        return wizardDescriptor;
    }

    public static boolean runWizard(WizardDescriptor wizardDescriptor) {
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor) == WizardDescriptor.FINISH_OPTION;
    }

    public static boolean runWizard(WizardSegment wizardSegment) {
        WizardDescriptor wizardDescriptor = WizardUtilities.createWizard(wizardSegment);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor) == WizardDescriptor.FINISH_OPTION) {
            wizardSegment.handleFinish(wizardDescriptor);
            return true;
        }
        wizardSegment.handleCancel(wizardDescriptor);
        return false;
    }

    public static void updatePanels(WizardDescriptor.Panel[] panelArray) {
        Color color = Color.BLACK;
        try {
            String string = NbBundle.getBundle(WizardUtilities.class).getString("WizardUtilities.panel.bgColor");
            if (string != null) {
                try {
                    color = Color.decode(string);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        WizardUtilities.updatePanels(panelArray, "com/paterva/maltego/util/ui/dialog/Wizard.png", Color.white, color);
    }

    public static void updatePanels(WizardDescriptor.Panel[] panelArray, String string, Color color, Color color2) {
        Image image = null;
        if (string != null) {
            image = ImageUtilities.loadImage((String)string, (boolean)true);
        }
        String[] stringArray = new String[panelArray.length];
        for (int i = 0; i < panelArray.length; ++i) {
            Object object;
            if (panelArray[i] instanceof ValidatingController) {
                object = (ValidatingController)panelArray[i];
                stringArray[i] = ((ValidatingController)object).getName();
                ((ValidatingController)object).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                ((ValidatingController)object).putClientProperty("WizardPanel_contentData", stringArray);
                ((ValidatingController)object).putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                ((ValidatingController)object).putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                ((ValidatingController)object).putClientProperty("WizardPanel_contentBackColor", color2);
                ((ValidatingController)object).putClientProperty("WizardPanel_contentForegroundColor", color);
                ((ValidatingController)object).putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
                ((ValidatingController)object).putClientProperty("WizardPanel_image", image);
                continue;
            }
            object = panelArray[i].getComponent();
            stringArray[i] = ((Component)object).getName();
            if (!(object instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)object;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
            jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentBackColor", color2);
            jComponent.putClientProperty("WizardPanel_contentForegroundColor", color);
            jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_image", image);
        }
    }
}

