/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;

public class PasswordEditPanel
extends JPanel {
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator(this);
    private boolean _retype;
    private Timer _timer;
    private JLabel _capsLockLabel;
    private JPasswordField _passwordField1;
    private JPasswordField _passwordField2;
    private JLabel _retypeLabel;

    public PasswordEditPanel(boolean bl) {
        this._retype = bl;
        this.initComponents();
        if (!this._retype) {
            this._retypeLabel.setVisible(false);
            this._passwordField2.setVisible(false);
        }
        this._passwordField1.setText("");
        this._passwordField2.setText("");
        this._passwordField1.getDocument().addDocumentListener(this._changeSupport);
        this._passwordField2.getDocument().addDocumentListener(this._changeSupport);
        this.checkCapsLock();
    }

    private void checkCapsLock() {
        try {
            boolean bl = Toolkit.getDefaultToolkit().getLockingKeyState(20);
            this._capsLockLabel.setText("Caps Lock is " + (bl ? "ON" : "OFF"));
        }
        catch (Exception exception) {
            this._capsLockLabel.setText("");
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasswordEditPanel.this.checkCapsLock();
            }
        });
        this._timer.start();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public boolean isSame() {
        return Arrays.equals(this._passwordField1.getPassword(), this._passwordField2.getPassword());
    }

    public String getPassword() {
        return new String(this._passwordField1.getPassword());
    }

    public void setPassword(String string) {
        this._passwordField1.setText(string);
        this._passwordField2.setText(string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeSupport.removeChangeListener(changeListener);
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this._passwordField1 = new JPasswordField();
        this._retypeLabel = new JLabel();
        this._passwordField2 = new JPasswordField();
        this._capsLockLabel = new JLabel();
        jLabel.setText(NbBundle.getMessage(PasswordEditPanel.class, (String)"PasswordEditPanel.jLabel1.text"));
        this._passwordField1.setText(NbBundle.getMessage(PasswordEditPanel.class, (String)"PasswordEditPanel._passwordField1.text"));
        this._retypeLabel.setText(NbBundle.getMessage(PasswordEditPanel.class, (String)"PasswordEditPanel._retypeLabel.text"));
        this._passwordField2.setText(NbBundle.getMessage(PasswordEditPanel.class, (String)"PasswordEditPanel._passwordField2.text"));
        this._capsLockLabel.setForeground(SystemColor.controlShadow);
        this._capsLockLabel.setText(NbBundle.getMessage(PasswordEditPanel.class, (String)"PasswordEditPanel._capsLockLabel.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._passwordField1, -1, 229, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this._retypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._passwordField2, -1, 229, Short.MAX_VALUE)).addComponent(this._capsLockLabel, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._passwordField1, -2, -1, -2).addComponent(jLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._passwordField2, -2, -1, -2).addComponent(this._retypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._capsLockLabel).addGap(0, 0, Short.MAX_VALUE)));
    }
}

