/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.IconResourceProvider;
import com.paterva.maltego.util.ui.IconSelectorPanel;
import java.util.HashMap;
import java.util.Map;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public abstract class IconSelector {
    public static IconSelector getDefault() {
        IconSelector iconSelector = (IconSelector)Lookup.getDefault().lookup(IconSelector.class);
        if (iconSelector == null) {
            iconSelector = new DefaultIconSelector();
        }
        return iconSelector;
    }

    public Object getIcon(int n) {
        return this.getIcon(n, null);
    }

    public Object getIcon(int n, Object object) {
        String[] stringArray = IconResourceProvider.getDefault().getCategories();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (String string : stringArray) {
            String[] stringArray2 = IconResourceProvider.getDefault().getResources(string);
            hashMap.put(string, stringArray2);
        }
        return this.getIcon(n, hashMap, object);
    }

    public abstract Object getIcon(int var1, Map<String, String[]> var2, Object var3);

    private static class DefaultIconSelector
    extends IconSelector {
        private DefaultIconSelector() {
        }

        @Override
        public Object getIcon(int n, Map<String, String[]> map, Object object) {
            IconSelectorPanel iconSelectorPanel = new IconSelectorPanel();
            iconSelectorPanel.setAvailableResources(map);
            iconSelectorPanel.setSelectedValue(object);
            iconSelectorPanel.setIconSize(n);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)iconSelectorPanel, "Choose an icon");
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION) {
                return iconSelectorPanel.getSelectedValue();
            }
            return null;
        }
    }
}

