/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.modules.editor.fold.FoldView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;

public final class FoldViewFactory
extends EditorViewFactory
implements FoldHierarchyListener {
    static final String VIEW_FOLDS_EXPANDED_PROPERTY = "view-folds-expanded";
    private static final Logger LOG = Logger.getLogger(FoldViewFactory.class.getName());
    private FoldHierarchy foldHierarchy;
    private boolean foldHierarchyLocked;
    private Fold fold;
    private int foldStartOffset;
    private Iterator<Fold> collapsedFoldIterator;
    private boolean viewFoldsExpanded;

    static void register() {
        EditorViewFactory.registerFactory((EditorViewFactory.Factory)new FoldFactory());
    }

    public FoldViewFactory(JTextComponent component) {
        super(component);
        this.foldHierarchy = FoldHierarchy.get(component);
        this.foldHierarchy.addFoldHierarchyListener(this);
        this.viewFoldsExpanded = Boolean.TRUE.equals(component.getClientProperty(VIEW_FOLDS_EXPANDED_PROPERTY));
    }

    public void restart(int startOffset, int matchOffset) {
        Iterator it;
        this.foldHierarchy.lock();
        this.foldHierarchyLocked = true;
        this.collapsedFoldIterator = it = FoldUtilities.collapsedFoldIterator(this.foldHierarchy, startOffset, Integer.MAX_VALUE);
        this.foldStartOffset = -1;
    }

    private void updateFold(int offset) {
        if (this.foldStartOffset < offset) {
            while (this.collapsedFoldIterator.hasNext()) {
                this.fold = this.collapsedFoldIterator.next();
                this.foldStartOffset = this.fold.getStartOffset();
                if (this.foldStartOffset < offset) continue;
                return;
            }
            this.fold = null;
            this.foldStartOffset = Integer.MAX_VALUE;
        }
    }

    public int nextViewStartOffset(int offset) {
        if (!this.viewFoldsExpanded) {
            this.updateFold(offset);
            return this.foldStartOffset;
        }
        return Integer.MAX_VALUE;
    }

    public EditorView createView(int startOffset, int limitOffset) {
        assert (startOffset == this.foldStartOffset) : "startOffset=" + startOffset + " != foldStartOffset=" + this.foldStartOffset;
        if (this.fold.getEndOffset() <= limitOffset) {
            return new FoldView(this.textComponent(), this.fold);
        }
        return null;
    }

    public int viewEndOffset(int startOffset, int limitOffset) {
        int foldEndOffset = this.fold.getEndOffset();
        if (foldEndOffset <= limitOffset) {
            return foldEndOffset;
        }
        return -1;
    }

    public void finish() {
        this.fold = null;
        this.collapsedFoldIterator = null;
        if (this.foldHierarchyLocked) {
            this.foldHierarchy.unlock();
        }
    }

    @Override
    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        int priority = evt.getFoldStateChangeCount() > 0 ? 1 : 0;
        this.fireEvent(Collections.singletonList(EditorViewFactory.createChange((int)evt.getAffectedStartOffset(), (int)evt.getAffectedEndOffset())), priority);
    }

    public static final class FoldFactory
    implements EditorViewFactory.Factory {
        public EditorViewFactory createEditorViewFactory(JTextComponent component) {
            return new FoldViewFactory(component);
        }

        public int importance() {
            return 100;
        }
    }
}

