/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.html;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.ui.graph.EntityImageFactory;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.lobobrowser.html.HtmlObject;
import org.openide.nodes.Node;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;

class HtmlObjectFactory {
    HtmlObjectFactory() {
    }

    public static HtmlObject createEntityImage(Node node) {
        MaltegoEntity maltegoEntity;
        if (node != null && (maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class)) != null) {
            D d = ((Y)node.getLookup().lookup(Y.class)).H();
            return new EntityImageHtmlObject(d, maltegoEntity);
        }
        return null;
    }

    public static HtmlObject createLinkImage(Node node) {
        MaltegoLink maltegoLink;
        if (node != null && (maltegoLink = (MaltegoLink)node.getLookup().lookup(MaltegoLink.class)) != null) {
            D d = ((H)node.getLookup().lookup(H.class)).a();
            return new LinkImageHtmlObject(d, maltegoLink);
        }
        return null;
    }

    private static class LinkImageHtmlObject
    implements HtmlObject,
    ImageCallback {
        private JLabel _label = new JLabel();
        private MaltegoLink _link;

        public LinkImageHtmlObject() {
        }

        public LinkImageHtmlObject(D d, MaltegoLink maltegoLink) {
            this.setLink(d, maltegoLink);
        }

        public Component getComponent() {
            return this._label;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void destroy() {
        }

        public void reset(int n, int n2) {
        }

        public MaltegoLink getLink() {
            return this._link;
        }

        public void setLink(D d, MaltegoLink maltegoLink) {
            this._link = maltegoLink;
            if (this._link != null) {
                ImageIcon imageIcon = new ImageIcon(MaltegoLinkSpec.getSpec((MaltegoLink)maltegoLink).getIcon(48));
                this._label.setIcon(imageIcon);
            } else {
                this._label.setIcon(null);
            }
        }

        public void imageReady(Object object, Object object2) {
            this._label.setIcon((Icon)object2);
        }

        public void imageFailed(Object object, Exception exception) {
        }

        public boolean needAwtThread() {
            return true;
        }
    }

    private static class EntityImageHtmlObject
    implements HtmlObject,
    ImageCallback {
        private JLabel _label = new JLabel();
        private MaltegoEntity _entity;

        public EntityImageHtmlObject() {
        }

        public EntityImageHtmlObject(D d, MaltegoEntity maltegoEntity) {
            this.setEntity(d, maltegoEntity);
        }

        public Component getComponent() {
            return this._label;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void destroy() {
        }

        public void reset(int n, int n2) {
        }

        public MaltegoEntity getEntity() {
            return this._entity;
        }

        public void setEntity(D d, MaltegoEntity maltegoEntity) {
            this._entity = maltegoEntity;
            if (maltegoEntity != null) {
                this._label.setIcon(EntityImageFactory.forGraph((D)d).getIconMax(maltegoEntity, 90, 90, (ImageCallback)this));
            } else {
                this._label.setIcon(null);
            }
        }

        public void imageReady(Object object, Object object2) {
            this._label.setIcon((Icon)object2);
        }

        public void imageFailed(Object object, Exception exception) {
        }

        public boolean needAwtThread() {
            return true;
        }
    }
}

