/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.html;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.detailview.CenterOnNodeAction;
import com.paterva.maltego.detailview.DetailViewTopComponent;
import com.paterva.maltego.detailview.html.HtmlDetailViewSettings;
import com.paterva.maltego.detailview.html.HtmlObjectFactory;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.Collections;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLLinkElementImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.openide.awt.HtmlBrowser;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NotImplementedException;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLElement;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;

class DetailViewRenderContext
extends SimpleHtmlRendererContext {
    private static final String HTML_CLASSID_ENTITY_IMAGE = "maltego.entity.image";
    private static final String HTML_CLASSID_LINK_IMAGE = "maltego.link.image";
    private Node _node;
    private boolean _overLink = false;

    public DetailViewRenderContext(HtmlPanel htmlPanel, UserAgentContext userAgentContext) {
        super(htmlPanel, userAgentContext);
    }

    public void navigate(URL uRL, String string) {
        if (uRL != null) {
            String string2 = uRL.toString();
            if (string2.startsWith("http://localhost:1/maltego/navigateTo/")) {
                String string3 = string2.substring("http://localhost:1/maltego/navigateTo/".length());
                if (string3.length() > 0) {
                    this.navigateToEntity(string3);
                }
            } else {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        } else {
            super.navigate(uRL, string);
        }
    }

    public HtmlObject getHtmlObject(HTMLElement hTMLElement) {
        String string = hTMLElement.getAttribute("classid");
        String string2 = hTMLElement.getAttribute("data");
        Node node = null;
        if (StringUtilities.isNullOrEmpty((String)string2)) {
            node = this.getSelectedNode();
        }
        if (HTML_CLASSID_ENTITY_IMAGE.equals(string)) {
            if (node == null) {
                node = this.getEntityNode(string2);
            }
            if (node == null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Entity for data: " + string2 + " could not be found.");
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            return HtmlObjectFactory.createEntityImage(node);
        }
        if (HTML_CLASSID_LINK_IMAGE.equals(string)) {
            if (node == null) {
                node = this.getLinkNode(string2);
            }
            if (node == null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Link for data: " + string2 + " could not be found.");
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            return HtmlObjectFactory.createLinkImage(node);
        }
        NotImplementedException notImplementedException = new NotImplementedException("classID: " + string + " not implemented.");
        Exceptions.printStackTrace((Throwable)notImplementedException);
        return null;
    }

    public void setSelectedNode(Node node) {
        this._node = node;
    }

    public Node getSelectedNode() {
        return this._node;
    }

    private D getGraph() {
        Y y = (Y)this._node.getLookup().lookup(Y.class);
        if (y != null) {
            return y.H();
        }
        H h = (H)this._node.getLookup().lookup(H.class);
        if (h != null) {
            return h.a();
        }
        return null;
    }

    private Node getEntityNode(String string) {
        D d = this.getGraph();
        if (d != null) {
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)d);
            Guid guid = Guid.parse((String)string);
            MaltegoEntity maltegoEntity = graphWrapper.getEntity(guid);
            Y y = graphWrapper.node(maltegoEntity);
            Node node = GraphNodeManager.getInstance((D)d).getNode(y);
            return node;
        }
        return null;
    }

    private Node getLinkNode(String string) {
        D d = this.getGraph();
        if (d != null) {
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)d);
            Guid guid = Guid.parse((String)string);
            MaltegoLink maltegoLink = graphWrapper.getLink(guid);
            H h = graphWrapper.edge(maltegoLink);
            Node node = GraphNodeManager.getInstance((D)d).getNode(h);
            return node;
        }
        return null;
    }

    private void navigateToEntity(String string) {
        Node node = this.getEntityNode(string);
        if (node == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not find entity with GUID: " + string);
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        } else {
            ((CenterOnNodeAction)SystemAction.get(CenterOnNodeAction.class)).performAction(node);
            ExplorerManager explorerManager = DetailViewRenderContext.find(GraphEditorRegistry.getDefault().getTopmost());
            if (explorerManager != null) {
                try {
                    explorerManager.setSelectedNodes(new Node[]{node});
                }
                catch (PropertyVetoException propertyVetoException) {
                    Exceptions.printStackTrace((Throwable)propertyVetoException);
                }
            }
            DetailViewTopComponent.findInstance().render(Collections.singleton(node));
        }
    }

    private static ExplorerManager find(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        if (topComponent instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)topComponent).getExplorerManager();
        }
        return (ExplorerManager)topComponent.getLookup().lookup(ExplorerManager.class);
    }

    public void onMouseOver(HTMLElement hTMLElement, MouseEvent mouseEvent) {
        super.onMouseOver(hTMLElement, mouseEvent);
        if (!this._overLink && hTMLElement instanceof HTMLLinkElementImpl) {
            this._overLink = true;
            this.getHtmlPanel().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void onMouseOut(HTMLElement hTMLElement, MouseEvent mouseEvent) {
        super.onMouseOut(hTMLElement, mouseEvent);
        if (this._overLink && hTMLElement instanceof HTMLLinkElementImpl) {
            this.getHtmlPanel().setCursor(Cursor.getDefaultCursor());
            this._overLink = false;
        }
    }

    public boolean onMouseClick(HTMLElement hTMLElement, MouseEvent mouseEvent) {
        boolean bl = super.onMouseClick(hTMLElement, mouseEvent);
        for (String string : HtmlDetailViewSettings.KEYS) {
            HTMLElementImpl hTMLElementImpl = this.findByID(hTMLElement.getChildNodes(), string);
            if (hTMLElementImpl == null) continue;
            boolean bl2 = "none".equals(hTMLElementImpl.getCurrentStyle().getPropertyValue("display"));
            HtmlDetailViewSettings.setCollapsed(string, bl2);
            break;
        }
        return bl;
    }

    private HTMLElementImpl findByID(NodeList nodeList, String string) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            HTMLElementImpl hTMLElementImpl;
            if (!(nodeList.item(i) instanceof HTMLElement) || !string.equals((hTMLElementImpl = (HTMLElementImpl)nodeList.item(i)).getId())) continue;
            return hTMLElementImpl;
        }
        return null;
    }
}

