/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview;

import com.paterva.maltego.detailview.DetailViewSyncAction;
import com.paterva.maltego.detailview.EntityQuickFilter;
import com.paterva.maltego.ui.graph.nodes.EntityProperties;
import com.paterva.maltego.ui.graph.nodes.LinkProperties;
import com.paterva.maltego.util.ui.outline.OutlineSearchPanel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

class ListDetailView
extends JPanel {
    public static final int VIEW_TYPE_ENTITIES = 0;
    public static final int VIEW_TYPE_LINKS = 1;
    private Integer _viewType;
    private OutlineView _outline;
    private JToolBar _toolbar;

    public ListDetailView() {
        this.initComponents();
        this._outline.getOutline().setRootVisible(false);
        this._outline.getOutline().getColumnModel().addColumnModelListener(new DetailViewColumnListener());
        OutlineSearchPanel outlineSearchPanel = new OutlineSearchPanel();
        outlineSearchPanel.setOutline(this._outline.getOutline());
        outlineSearchPanel.setFilter((TextQuickFilter)new EntityQuickFilter());
        this._toolbar.add((Action)SystemAction.get(DetailViewSyncAction.class));
        this._toolbar.add((Component)outlineSearchPanel);
    }

    public void setViewType(int n) {
        if (this._viewType == null || n != this._viewType) {
            if (n == 0) {
                if ("true".equals(System.getProperty("maltego.show-weight", "false"))) {
                    this._outline.setProperties(new Node.Property[]{EntityProperties.weight(), EntityProperties.incomingLinks(), EntityProperties.outgoingLinks(), EntityProperties.bookmark()});
                } else {
                    this._outline.setProperties(new Node.Property[]{EntityProperties.incomingLinks(), EntityProperties.outgoingLinks(), EntityProperties.bookmark()});
                }
            } else {
                this._outline.setProperties(new Node.Property[]{LinkProperties.source(), LinkProperties.target()});
            }
            this._viewType = n;
        }
    }

    private void initComponents() {
        this._toolbar = new JToolBar();
        this._outline = new OutlineView("Name");
        this.setLayout(new BorderLayout());
        this._toolbar.setRollover(true);
        this.add((Component)this._toolbar, "North");
        this.add((Component)this._outline, "Center");
    }

    private class DetailViewColumnListener
    implements TableColumnModelListener {
        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            for (int i = tableColumnModelEvent.getFromIndex(); i <= tableColumnModelEvent.getToIndex(); ++i) {
                TableColumn tableColumn = ListDetailView.this._outline.getOutline().getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(150);
                    continue;
                }
                if (i <= 0) continue;
                tableColumn.setPreferredWidth(50);
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }
}

