/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.detailview.EmptyDetailView;
import com.paterva.maltego.detailview.ListDetailView;
import com.paterva.maltego.detailview.LookupResultChildFactory;
import com.paterva.maltego.detailview.html.HtmlDetailView;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphHoverContext;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.SelectionProvider;
import java.awt.CardLayout;
import java.awt.Container;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DetailViewTopComponent
extends TopComponent
implements ExplorerManager.Provider,
SelectionProvider {
    private static DetailViewTopComponent instance;
    static final String ICON_PATH = "com/paterva/maltego/detailview/DetailView16.png";
    private static final String PREFERRED_ID = "DetailViewTopComponent";
    private static final String SINGLE_NODE_VIEW = "SingleNodeView";
    private static final String MULTI_NODE_VIEW = "MultiNodeView";
    private static final String EMPTY_NODE_VIEW = "EmptyNodeView";
    private HtmlDetailView _htmlView = new HtmlDetailView();
    private ListDetailView _listView = new ListDetailView();
    private Lookup.Result _selectionResult = null;
    private Lookup.Result _hoverResult = null;
    private final ExplorerManager _explorer = new ExplorerManager();
    private AbstractNode _rootNode;
    private LookupResultChildFactory _childFactory;
    private boolean _activated = false;
    private InstanceContent _lookupContent;
    private LookupListener _hoverListener;
    private LookupListener _selectionListener;

    public DetailViewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(DetailViewTopComponent.class, (String)"CTL_DetailViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DetailViewTopComponent.class, (String)"HINT_DetailViewTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.add(new EmptyDetailView(), EMPTY_NODE_VIEW);
        this.add(this._listView, MULTI_NODE_VIEW);
        this.add(this._htmlView, SINGLE_NODE_VIEW);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._explorer));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this._explorer));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this._explorer));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true));
        this._lookupContent = new InstanceContent();
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)actionMap), new AbstractLookup((AbstractLookup.Content)this._lookupContent)}));
        this._childFactory = new LookupResultChildFactory();
        this._rootNode = new AbstractNode(Children.create((ChildFactory)this._childFactory, (boolean)true));
        this._explorer.setRootContext((Node)this._rootNode);
        this._selectionListener = new SelectionLookupListener();
        this._hoverListener = new HoverLookupListener();
    }

    private void initComponents() {
        this.setLayout(new CardLayout());
    }

    public static synchronized DetailViewTopComponent getDefault() {
        if (instance == null) {
            instance = new DetailViewTopComponent();
        }
        return instance;
    }

    public static synchronized DetailViewTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(DetailViewTopComponent.class.getName()).warning("Cannot find DetailViewTopComponent component. It will not be located properly in the window system.");
            return DetailViewTopComponent.getDefault();
        }
        if (topComponent instanceof DetailViewTopComponent) {
            return (DetailViewTopComponent)topComponent;
        }
        Logger.getLogger(DetailViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'DetailViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DetailViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    protected void componentActivated() {
        this._activated = true;
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)true);
    }

    protected void componentDeactivated() {
        this._activated = false;
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)false);
    }

    public void componentOpened() {
        Lookup.Template template = new Lookup.Template(Node.class);
        this._selectionResult = Utilities.actionsGlobalContext().lookup(template);
        this._selectionResult.addLookupListener(this._selectionListener);
        this._hoverResult = GraphHoverContext.hoverContext().lookup(template);
        this._hoverResult.addLookupListener(this._hoverListener);
        this._childFactory.setResult((Lookup.Result<Node>)this._selectionResult);
    }

    public void componentClosed() {
        this._selectionResult.removeLookupListener(this._selectionListener);
        this._selectionResult = null;
        this._hoverResult.removeLookupListener(this._hoverListener);
        this._hoverResult = null;
    }

    void writeProperties(Properties properties) {
        properties.setProperty("version", "1.0");
    }

    Object readProperties(Properties properties) {
        DetailViewTopComponent detailViewTopComponent = DetailViewTopComponent.getDefault();
        detailViewTopComponent.readPropertiesImpl(properties);
        return detailViewTopComponent;
    }

    private void readPropertiesImpl(Properties properties) {
        String string = properties.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void render(Collection collection) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        if (collection.size() == 0) {
            cardLayout.show((Container)((Object)this), EMPTY_NODE_VIEW);
        } else if (collection.size() > 1) {
            this._lookupContent.set(Collections.emptyList(), null);
            Object object = DetailViewTopComponent.getFirst(collection);
            if (object instanceof Node) {
                MaltegoEntity maltegoEntity = (MaltegoEntity)((Node)object).getLookup().lookup(MaltegoEntity.class);
                if (maltegoEntity != null) {
                    this._listView.setViewType(0);
                } else {
                    this._listView.setViewType(1);
                }
            }
            cardLayout.show((Container)((Object)this), MULTI_NODE_VIEW);
        } else {
            Node node = (Node)DetailViewTopComponent.getFirst(collection);
            this._lookupContent.set(Collections.singleton(node), null);
            if (node != null) {
                this._htmlView.setSelectedNode(node);
            }
            cardLayout.show((Container)((Object)this), SINGLE_NODE_VIEW);
        }
    }

    private Collection createLookupContent(Node node) {
        TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
        if (topComponent == null) {
            return Collections.singleton(node);
        }
        GraphCookie graphCookie = (GraphCookie)topComponent.getLookup().lookup(GraphCookie.class);
        GraphViewCookie graphViewCookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class);
        if (node == null) {
            return Arrays.asList(graphCookie, graphViewCookie);
        }
        return Arrays.asList(graphCookie, graphViewCookie, node);
    }

    private static Object getFirst(Collection collection) {
        Iterator iterator;
        if (collection != null && (iterator = collection.iterator()).hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private class HoverLookupListener
    implements LookupListener {
        private boolean changing = false;

        private HoverLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (!this.changing) {
                this.changing = true;
                if (!DetailViewTopComponent.this._activated) {
                    Lookup.Result result = DetailViewTopComponent.this._hoverResult;
                    Collection collection = DetailViewTopComponent.this._hoverResult.allInstances();
                    if (collection.isEmpty()) {
                        collection = DetailViewTopComponent.this._selectionResult.allInstances();
                        result = DetailViewTopComponent.this._selectionResult;
                    }
                    DetailViewTopComponent.this._childFactory.setResult((Lookup.Result<Node>)result);
                    DetailViewTopComponent.this._childFactory.resultChanged(lookupEvent);
                    DetailViewTopComponent.this.render(collection);
                }
                this.changing = false;
            }
        }
    }

    private class SelectionLookupListener
    implements LookupListener {
        private boolean changing = false;

        private SelectionLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (!this.changing) {
                this.changing = true;
                if (!DetailViewTopComponent.this._activated) {
                    Lookup.Result result = DetailViewTopComponent.this._selectionResult;
                    Collection collection = DetailViewTopComponent.this._selectionResult.allInstances();
                    if (collection.isEmpty()) {
                        collection = DetailViewTopComponent.this._hoverResult.allInstances();
                        result = DetailViewTopComponent.this._hoverResult;
                    }
                    DetailViewTopComponent.this._childFactory.setResult((Lookup.Result<Node>)result);
                    DetailViewTopComponent.this._childFactory.resultChanged(lookupEvent);
                    DetailViewTopComponent.this.render(collection);
                }
                this.changing = false;
            }
        }
    }
}

