/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.typing.editing.form.ControlAdapterFactory;
import com.paterva.maltego.typing.editing.form.adapters.AbstractFileBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ArrayEditorAdapter;
import com.paterva.maltego.typing.editing.form.adapters.BinaryFileBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.CheckBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.CheckListAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ColorChooserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ComboBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.DatePickerAdapter;
import com.paterva.maltego.typing.editing.form.adapters.DateTimePickerAdapter;
import com.paterva.maltego.typing.editing.form.adapters.FastUrlTextBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.FileBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ImageBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ImageViewAdapter;
import com.paterva.maltego.typing.editing.form.adapters.PasswordFieldAdapter;
import com.paterva.maltego.typing.editing.form.adapters.RadioButtonPanelAdapter;
import com.paterva.maltego.typing.editing.form.adapters.SpinnerAdapter;
import com.paterva.maltego.typing.editing.form.adapters.TextBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.TimeSpanEditorAdapter;
import com.paterva.maltego.typing.editors.BooleanFormat;
import com.paterva.maltego.typing.editors.FileBrowserEditorDescriptor;
import com.paterva.maltego.typing.editors.OptionEditorDescriptor;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.typing.editors.PasswordEditorDescriptor;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.BinaryFile;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.FastURL;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SpinnerNumberModel;

public class DefaultAdapterFactory
implements ControlAdapterFactory {
    private static DefaultAdapterFactory _instance;

    public static DefaultAdapterFactory instance() {
        if (_instance == null) {
            _instance = new DefaultAdapterFactory();
        }
        return _instance;
    }

    @Override
    public ControlAdapter create(DisplayDescriptor displayDescriptor) throws UnsupportedEditorException {
        if (displayDescriptor.getEditor() == null) {
            return this.createTypeAdapter(displayDescriptor);
        }
        if (displayDescriptor.getEditor() instanceof OptionEditorDescriptor) {
            OptionEditorDescriptor optionEditorDescriptor = (OptionEditorDescriptor)displayDescriptor.getEditor();
            return this.createOptionEditor(displayDescriptor, optionEditorDescriptor);
        }
        if (displayDescriptor.getEditor() instanceof PasswordEditorDescriptor) {
            return new PasswordFieldAdapter();
        }
        if (displayDescriptor.getEditor() instanceof FileBrowserEditorDescriptor) {
            return this.createFileBrowserAdapter(displayDescriptor, (FileBrowserEditorDescriptor)displayDescriptor.getEditor());
        }
        throw new UnsupportedEditorException(displayDescriptor);
    }

    private ControlAdapter createFileBrowserAdapter(DisplayDescriptor displayDescriptor, FileBrowserEditorDescriptor fileBrowserEditorDescriptor) throws UnsupportedEditorException {
        if (File.class.isAssignableFrom(displayDescriptor.getType()) || BinaryFile.class.isAssignableFrom(displayDescriptor.getType())) {
            AbstractFileBrowserAdapter abstractFileBrowserAdapter = (AbstractFileBrowserAdapter)this.createTypeAdapter(displayDescriptor);
            abstractFileBrowserAdapter.setExtensions(fileBrowserEditorDescriptor.getExtensions());
            abstractFileBrowserAdapter.setFilterTitle(fileBrowserEditorDescriptor.getFilterTitle());
            abstractFileBrowserAdapter.setSelectDirectories(fileBrowserEditorDescriptor.isSelectDirectories());
            abstractFileBrowserAdapter.setSelectFiles(fileBrowserEditorDescriptor.isSelectFiles());
            return abstractFileBrowserAdapter;
        }
        throw new UnsupportedEditorException("FileBrowserEditor can only be used with types file and binary.");
    }

    private ControlAdapter createOptionEditor(DisplayDescriptor displayDescriptor, OptionEditorDescriptor optionEditorDescriptor) {
        if (displayDescriptor.getTypeDescriptor().isArrayType()) {
            if (optionEditorDescriptor.isUserSpecified()) {
                return new ArrayEditorAdapter(displayDescriptor.getType(), displayDescriptor.getFormat());
            }
            return new CheckListAdapter(optionEditorDescriptor.getItems());
        }
        return new ComboBoxAdapter(optionEditorDescriptor.getItems(), optionEditorDescriptor.isUserSpecified());
    }

    private SpinnerAdapter createNumericAdapter(DisplayDescriptor displayDescriptor, Number number) {
        Number number2 = (Number)displayDescriptor.getDefaultValue();
        if (number2 == null) {
            number2 = (Number)displayDescriptor.getTypeDescriptor().getDefaultValue();
        }
        return this.createNumericAdapter(number2, number);
    }

    private SpinnerAdapter createNumericAdapter(Number number, Number number2) {
        Comparable<?> comparable = null;
        Comparable<?> comparable2 = null;
        SpinnerAdapter spinnerAdapter = new SpinnerAdapter();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(number, comparable, comparable2, number2);
        spinnerAdapter.setModel(spinnerNumberModel);
        return spinnerAdapter;
    }

    private ControlAdapter createTypeAdapter(DisplayDescriptor displayDescriptor) throws UnsupportedEditorException {
        Class clazz = displayDescriptor.getType();
        if (displayDescriptor.getType().isArray()) {
            return new ArrayEditorAdapter(displayDescriptor.getType(), displayDescriptor.getFormat());
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(displayDescriptor, (Number)1);
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(displayDescriptor, (Number)0.1);
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(displayDescriptor, (Number)0.1);
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(displayDescriptor, (Number)1);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(displayDescriptor, (Number)1);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return new TextBoxAdapter();
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            return this.createBooleanAdapter(displayDescriptor.getFormat());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return this.createDatePicker(displayDescriptor.getFormat());
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return this.createDateTimePicker(displayDescriptor.getFormat());
        }
        if (TimeSpan.class.isAssignableFrom(clazz)) {
            return new TimeSpanEditorAdapter();
        }
        if (FastURL.class.isAssignableFrom(clazz)) {
            return new FastUrlTextBoxAdapter();
        }
        if (Image.class.isAssignableFrom(clazz)) {
            if (displayDescriptor.isReadonly()) {
                return new ImageViewAdapter();
            }
            return new ImageBrowserAdapter();
        }
        if (BinaryFile.class.isAssignableFrom(clazz)) {
            return new BinaryFileBrowserAdapter();
        }
        if (File.class.isAssignableFrom(clazz)) {
            return new FileBrowserAdapter();
        }
        if (Color.class.isAssignableFrom(clazz)) {
            return new ColorChooserAdapter();
        }
        if (Attachments.class.isAssignableFrom(clazz)) {
            return null;
        }
        throw new UnsupportedEditorException(clazz);
    }

    private DatePickerAdapter createDatePicker(Format format) {
        DateFormat dateFormat = format == null ? new SimpleDateFormat(TypeRegistry.getDefaultDateFormat()) : (DateFormat)format;
        return new DatePickerAdapter(dateFormat);
    }

    private DateTimePickerAdapter createDateTimePicker(Format format) {
        DateFormat dateFormat = format == null ? DateTime.getDefaultFormat() : (DateFormat)format;
        return new DateTimePickerAdapter(dateFormat);
    }

    @Override
    public ControlAdapter create(Class clazz) throws UnsupportedEditorException {
        return this.create(clazz, null);
    }

    @Override
    public ControlAdapter create(Class clazz, Format format) throws UnsupportedEditorException {
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(0, (Number)1);
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(0.0, (Number)0.1);
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter(Float.valueOf(0.0f), (Number)0.1);
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            return this.createNumericAdapter((byte)0, (Number)1);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            return this.createBooleanAdapter(format);
        }
        if (Image.class.isAssignableFrom(clazz)) {
            return new ImageBrowserAdapter();
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return this.createDatePicker(format);
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return this.createDateTimePicker(format);
        }
        if (TimeSpan.class.isAssignableFrom(clazz)) {
            return new TimeSpanEditorAdapter();
        }
        if (Color.class.isAssignableFrom(clazz)) {
            return new ColorChooserAdapter();
        }
        return new TextBoxAdapter();
    }

    private ControlAdapter createBooleanAdapter(Format format) {
        if (format instanceof BooleanFormat) {
            OptionItemCollection optionItemCollection = new OptionItemCollection(Boolean.TYPE, format);
            optionItemCollection.add((Object)true);
            optionItemCollection.add((Object)false);
            return new RadioButtonPanelAdapter(optionItemCollection);
        }
        return new CheckBoxAdapter();
    }
}

